/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.boot.autoconfigure.handlebars;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.helper.ext.AssignHelper;
import com.github.jknack.handlebars.helper.ext.IncludeHelper;
import com.github.jknack.handlebars.helper.ext.JodaHelper;
import com.github.jknack.handlebars.helper.ext.NumberHelper;
import com.github.jknack.handlebars.jackson.JacksonHelper;
import com.github.jknack.handlebars.springmvc.HandlebarsViewResolver;
import jakarta.annotation.PostConstruct;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import pl.allegro.tech.boot.autoconfigure.handlebars.HandlebarsHelper;

@AutoConfiguration
@ConditionalOnClass(value={HandlebarsViewResolver.class})
@ConditionalOnWebApplication
public class HandlebarsHelpersAutoConfiguration {
    @Bean
    public BeanPostProcessor handlebarsBeanPostProcessor(final HandlebarsViewResolver handlebarsViewResolver) {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                HandlebarsHelper annotation = (HandlebarsHelper)AnnotationUtils.findAnnotation(bean.getClass(), HandlebarsHelper.class);
                if (annotation != null) {
                    handlebarsViewResolver.registerHelpers(bean);
                }
                return bean;
            }
        };
    }

    @Configuration
    @ConditionalOnClass(value={StringHelpers.class})
    static class StringHelpersAutoConfiguration {
        @Autowired
        private HandlebarsViewResolver handlebarsViewResolver;

        StringHelpersAutoConfiguration() {
        }

        @PostConstruct
        public void registerHelpers() {
            StringHelpers.register((Handlebars)this.handlebarsViewResolver.getHandlebars());
        }
    }

    @Configuration
    @ConditionalOnClass(value={JodaHelper.class, DateTimeFormat.class})
    static class JodaHelpersAutoConfiguration {
        @Autowired
        private HandlebarsViewResolver handlebarsViewResolver;

        JodaHelpersAutoConfiguration() {
        }

        @PostConstruct
        public void registerHelpers() {
            this.handlebarsViewResolver.registerHelpers(JodaHelper.class);
        }
    }

    @Configuration
    @ConditionalOnClass(value={NumberHelper.class})
    static class NumberHelpersAutoConfiguration {
        @Autowired
        private HandlebarsViewResolver handlebarsViewResolver;

        NumberHelpersAutoConfiguration() {
        }

        @PostConstruct
        public void registerHelpers() {
            NumberHelper.register((Handlebars)this.handlebarsViewResolver.getHandlebars());
        }
    }

    @Configuration
    @ConditionalOnClass(value={IncludeHelper.class})
    static class IncludeHelperAutoConfiguration {
        @Autowired
        private HandlebarsViewResolver handlebarsViewResolver;

        IncludeHelperAutoConfiguration() {
        }

        @PostConstruct
        public void registerHelper() {
            this.handlebarsViewResolver.registerHelper("include", IncludeHelper.INSTANCE);
        }
    }

    @Configuration
    @ConditionalOnClass(value={AssignHelper.class})
    static class AssignHelperAutoConfiguration {
        @Autowired
        private HandlebarsViewResolver handlebarsViewResolver;

        AssignHelperAutoConfiguration() {
        }

        @PostConstruct
        public void registerHelper() {
            this.handlebarsViewResolver.registerHelper("assign", AssignHelper.INSTANCE);
        }
    }

    @Configuration
    @ConditionalOnClass(value={JacksonHelper.class})
    static class JsonHelperAutoConfiguration {
        @Autowired
        private HandlebarsViewResolver handlebarsViewResolver;

        JsonHelperAutoConfiguration() {
        }

        @PostConstruct
        public void registerHelper() {
            this.handlebarsViewResolver.registerHelper("json", JacksonHelper.INSTANCE);
        }
    }
}

