/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.boot.autoconfigure.handlebars;

import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import com.github.jknack.handlebars.springmvc.HandlebarsViewResolver;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.template.AbstractTemplateViewResolverProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.util.Assert;
import pl.allegro.tech.boot.autoconfigure.handlebars.HandlebarsValueResolversProperties;

@ConfigurationProperties(prefix="handlebars")
@EnableConfigurationProperties(value={HandlebarsValueResolversProperties.class})
public class HandlebarsProperties
extends AbstractTemplateViewResolverProperties {
    static final String DEFAULT_PREFIX = "classpath:templates/";
    static final String DEFAULT_SUFFIX = ".hbs";
    private Boolean registerMessageHelper = true;
    private Boolean failOnMissingFile = false;
    private Boolean bindI18nToMessageSource = false;
    private final HandlebarsValueResolversProperties valueResolversProperties;

    @Autowired
    protected HandlebarsProperties(HandlebarsValueResolversProperties valueResolversProperties) {
        super(DEFAULT_PREFIX, DEFAULT_SUFFIX);
        this.valueResolversProperties = valueResolversProperties;
        this.setCache(true);
    }

    public void applyToMvcViewResolver(Object viewResolver) {
        super.applyToMvcViewResolver(viewResolver);
        Assert.isInstanceOf(HandlebarsViewResolver.class, (Object)viewResolver, (String)("ViewResolver is not an instance of HandlebarsViewResolver :" + viewResolver));
        HandlebarsViewResolver resolver = (HandlebarsViewResolver)viewResolver;
        ArrayList<ValueResolver> valueResolvers = new ArrayList<ValueResolver>();
        this.addValueResolverIfNeeded(valueResolvers, this.valueResolversProperties.isJavaBean(), JavaBeanValueResolver.INSTANCE);
        this.addValueResolverIfNeeded(valueResolvers, this.valueResolversProperties.isMap(), (ValueResolver)MapValueResolver.INSTANCE);
        this.addValueResolverIfNeeded(valueResolvers, this.valueResolversProperties.isField(), FieldValueResolver.INSTANCE);
        this.addValueResolverIfNeeded(valueResolvers, this.valueResolversProperties.isMethod(), MethodValueResolver.INSTANCE);
        resolver.setValueResolvers(this.listToArray(valueResolvers));
        resolver.setRegisterMessageHelper(this.registerMessageHelper.booleanValue());
        resolver.setFailOnMissingFile(this.failOnMissingFile.booleanValue());
        resolver.setBindI18nToMessageSource(this.bindI18nToMessageSource.booleanValue());
    }

    public void setRegisterMessageHelper(Boolean registerMessageHelper) {
        this.registerMessageHelper = registerMessageHelper;
    }

    public void setFailOnMissingFile(Boolean failOnMissingFile) {
        this.failOnMissingFile = failOnMissingFile;
    }

    public void setBindI18nToMessageSource(Boolean bindI18nToMessageSource) {
        this.bindI18nToMessageSource = bindI18nToMessageSource;
    }

    private void addValueResolverIfNeeded(List<ValueResolver> resolvers, boolean property, ValueResolver resolver) {
        if (property) {
            resolvers.add(resolver);
        }
    }

    private ValueResolver[] listToArray(List<ValueResolver> resolvers) {
        return resolvers.toArray(new ValueResolver[resolvers.size()]);
    }
}

