/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain.scm;

import java.io.File;
import java.util.Optional;
import pl.allegro.tech.build.axion.release.domain.scm.ScmIdentity;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPushOptions;

public class ScmProperties {
    private final String type;
    private final File directory;
    private final String remote;
    private final boolean pushTagsOnly;
    private final boolean fetchTags;
    private final boolean attachRemote;
    private final String remoteUrl;
    private final String overriddenBranchName;
    private final Boolean overriddenIsClean;
    private final ScmIdentity identity;
    private final Boolean unshallowRepoOnCI;

    public ScmProperties(String type, File directory, String remote, boolean pushTagsOnly, boolean fetchTags, boolean attachRemote, String remoteUrl, String overriddenBranchName, Boolean overriddenIsClean, ScmIdentity identity, Boolean unshallowRepoOnCI) {
        this.type = type;
        this.directory = directory;
        this.remote = remote;
        this.pushTagsOnly = pushTagsOnly;
        this.fetchTags = fetchTags;
        this.attachRemote = attachRemote;
        this.remoteUrl = remoteUrl;
        this.overriddenBranchName = overriddenBranchName;
        this.overriddenIsClean = overriddenIsClean;
        this.identity = identity;
        this.unshallowRepoOnCI = unshallowRepoOnCI;
    }

    public ScmPushOptions pushOptions() {
        return new ScmPushOptions(this.remote, this.pushTagsOnly);
    }

    public final String getType() {
        return this.type;
    }

    public final File getDirectory() {
        return this.directory;
    }

    public final String getRemote() {
        return this.remote;
    }

    public final boolean isPushTagsOnly() {
        return this.pushTagsOnly;
    }

    public final boolean isFetchTags() {
        return this.fetchTags;
    }

    public final boolean isAttachRemote() {
        return this.attachRemote;
    }

    public final String getRemoteUrl() {
        return this.remoteUrl;
    }

    public String getOverriddenBranchName() {
        return this.overriddenBranchName;
    }

    public Optional<Boolean> getOverriddenIsClean() {
        return Optional.ofNullable(this.overriddenIsClean);
    }

    public final ScmIdentity getIdentity() {
        return this.identity;
    }

    public Boolean isUnshallowRepoOnCI() {
        return this.unshallowRepoOnCI;
    }
}

