/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.infrastructure.git;

import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.NetRCCredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import pl.allegro.tech.build.axion.release.domain.scm.ScmIdentity;
import pl.allegro.tech.build.axion.release.infrastructure.git.SshConnector;

class TransportConfigFactory {
    TransportConfigFactory() {
    }

    TransportConfigCallback create(ScmIdentity identity) {
        if (identity.isPrivateKeyBased()) {
            return this.createForSsh(identity);
        }
        if (identity.isUsernameBased()) {
            return this.createForUsername(identity);
        }
        if (identity.isUseDefault()) {
            return this.createForDefault(identity);
        }
        throw new IllegalArgumentException("Transport callback can be created only for none (empty), private key or username based identity");
    }

    private TransportConfigCallback createForDefault(ScmIdentity identity) {
        return transport -> {
            if (transport instanceof SshTransport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)new SshConnector(identity));
            } else if (transport instanceof HttpTransport) {
                transport.setCredentialsProvider((CredentialsProvider)new NetRCCredentialsProvider());
            }
        };
    }

    private TransportConfigCallback createForSsh(ScmIdentity identity) {
        return transport -> {
            SshTransport sshTransport = (SshTransport)transport;
            sshTransport.setSshSessionFactory((SshSessionFactory)new SshConnector(identity));
        };
    }

    private TransportConfigCallback createForUsername(ScmIdentity identity) {
        return transport -> transport.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(identity.getUsername(), identity.getPassword()));
    }
}

