/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain.properties;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPosition;

public class TagProperties {
    private final String prefix;
    private final List<String> fallbackPrefixes;
    private final String versionSeparator;
    private final Serializer serialize;
    private final Deserializer deserialize;
    private final InitialVersionSupplier initialVersion;

    public TagProperties(String prefix, List<String> fallbackPrefixes, String versionSeparator, Serializer serialize, Deserializer deserialize, InitialVersionSupplier initialVersion) {
        this.prefix = prefix;
        this.fallbackPrefixes = fallbackPrefixes;
        this.versionSeparator = versionSeparator;
        this.serialize = serialize;
        this.deserialize = deserialize;
        this.initialVersion = initialVersion;
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final List<String> getFallbackPrefixes() {
        return this.fallbackPrefixes;
    }

    public final List<String> getAllPrefixes() {
        return Stream.concat(Stream.of(this.prefix), this.fallbackPrefixes.stream()).collect(Collectors.toList());
    }

    public final String getVersionSeparator() {
        return this.versionSeparator;
    }

    public final Serializer getSerialize() {
        return this.serialize;
    }

    public final Deserializer getDeserialize() {
        return this.deserialize;
    }

    public final InitialVersionSupplier getInitialVersion() {
        return this.initialVersion;
    }

    public static interface Serializer {
        public String apply(TagProperties var1, String var2);
    }

    public static interface Deserializer {
        public String apply(TagProperties var1, ScmPosition var2, String var3);
    }

    public static interface InitialVersionSupplier {
        public String apply(TagProperties var1, ScmPosition var2);
    }
}

