/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.infrastructure.git;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import pl.allegro.tech.build.axion.release.TagPrefixConf;
import pl.allegro.tech.build.axion.release.domain.scm.ScmException;
import pl.allegro.tech.build.axion.release.domain.scm.ScmIdentity;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPosition;
import pl.allegro.tech.build.axion.release.domain.scm.ScmProperties;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPushOptions;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPushResult;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPushResultOutcome;
import pl.allegro.tech.build.axion.release.domain.scm.ScmRepository;
import pl.allegro.tech.build.axion.release.domain.scm.ScmRepositoryUnavailableException;
import pl.allegro.tech.build.axion.release.domain.scm.TagsOnCommit;
import pl.allegro.tech.build.axion.release.infrastructure.git.SystemReaderWithoutSystemConfig;
import pl.allegro.tech.build.axion.release.infrastructure.git.TransportConfigFactory;

public class GitRepository
implements ScmRepository {
    private static final Logger logger = Logging.getLogger(GitRepository.class);
    private static final String GIT_TAG_PREFIX = "refs/tags/";
    private final TransportConfigFactory transportConfigFactory = new TransportConfigFactory();
    private final File repositoryDir;
    private final Git jgitRepository;
    private final ScmProperties properties;

    public GitRepository(ScmProperties properties) {
        SystemReader.setInstance((SystemReader)new SystemReaderWithoutSystemConfig(properties.isIgnoreGlobalGitConfig()));
        try {
            this.repositoryDir = properties.getDirectory();
            this.jgitRepository = Git.open((File)this.repositoryDir);
            this.properties = properties;
        }
        catch (RepositoryNotFoundException exception) {
            throw new ScmRepositoryUnavailableException(exception);
        }
        catch (IOException exception) {
            throw new ScmException(exception);
        }
        if (properties.isAttachRemote()) {
            this.attachRemote(properties.getRemote(), properties.getRemoteUrl());
        }
        if (properties.isFetchTags()) {
            this.fetchTags(properties.getIdentity(), properties.getRemote());
        }
        if (this.onCI() && properties.isUnshallowRepoOnCI().booleanValue()) {
            this.unshallowRepo(properties.getIdentity());
        }
    }

    private void unshallowRepo(ScmIdentity identity) {
        try {
            logger.lifecycle("Unshallowing repo because the build is being executed on CI");
            ((FetchCommand)this.jgitRepository.fetch().setUnshallow(true).setTransportConfigCallback(this.transportConfigFactory.create(identity))).call();
        }
        catch (GitAPIException e) {
            logger.warn("Unable to unshallow repo on GitHub actions, continuing with shallow repo", (Throwable)e);
        }
    }

    @Override
    public void fetchTags(ScmIdentity identity, String remoteName) {
        FetchCommand fetch = (FetchCommand)this.jgitRepository.fetch().setRemote(remoteName).setTagOpt(TagOpt.FETCH_TAGS).setTransportConfigCallback(this.transportConfigFactory.create(identity));
        try {
            fetch.call();
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public void tag(String tagName) {
        try {
            String headId = this.head().name();
            List tags = this.jgitRepository.tagList().call();
            boolean isOnExistingTag = tags.stream().anyMatch(ref -> {
                boolean onHead;
                boolean onTag = ref.getName().equals(GIT_TAG_PREFIX + tagName);
                try {
                    ObjectId peeledObjectId = this.jgitRepository.getRepository().getRefDatabase().peel(ref).getPeeledObjectId();
                    if (peeledObjectId != null) {
                        onHead = peeledObjectId.getName().equals(headId);
                    } else {
                        onHead = ref.getName().equals(headId);
                        logger.debug("Using lightweight (not annotated) tag " + ref.getName() + ".");
                    }
                }
                catch (IOException e) {
                    throw new ScmException(e);
                }
                return onTag && onHead;
            });
            if (!isOnExistingTag) {
                this.jgitRepository.tag().setName(tagName).call();
            } else {
                logger.debug("The head commit " + headId + " already has the tag " + tagName + ".");
            }
        }
        catch (IOException | GitAPIException e) {
            throw new ScmException(e);
        }
    }

    private ObjectId head() throws IOException {
        return this.jgitRepository.getRepository().resolve("HEAD");
    }

    @Override
    public void dropTag(String tagName) {
        try {
            this.jgitRepository.tagDelete().setTags(new String[]{GIT_TAG_PREFIX + tagName}).call();
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public ScmPushResult push(ScmIdentity identity, ScmPushOptions pushOptions) {
        return this.push(identity, pushOptions, false);
    }

    public ScmPushResult push(ScmIdentity identity, ScmPushOptions pushOptions, boolean all) {
        PushCommand command;
        ScmPushResult result;
        if (!pushOptions.isPushTagsOnly() && (result = this.verifyPushResults(this.callPush(command = this.pushCommand(identity, pushOptions.getRemote(), all)))).getOutcome().equals((Object)ScmPushResultOutcome.FAILED)) {
            return result;
        }
        command = this.pushCommand(identity, pushOptions.getRemote(), all);
        return this.verifyPushResults(this.callPush(command.setPushTags()));
    }

    private Iterable<PushResult> callPush(PushCommand pushCommand) {
        try {
            return pushCommand.call();
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    private ScmPushResult verifyPushResults(Iterable<PushResult> pushResults) {
        PushResult pushResult = pushResults.iterator().next();
        Optional<RemoteRefUpdate> failedRefUpdate = pushResult.getRemoteUpdates().stream().filter(ref -> !ref.getStatus().equals((Object)RemoteRefUpdate.Status.OK) && !ref.getStatus().equals((Object)RemoteRefUpdate.Status.UP_TO_DATE)).findFirst();
        boolean isSuccess = failedRefUpdate.isEmpty();
        Optional<RemoteRefUpdate.Status> failureCause = isSuccess ? Optional.empty() : Optional.of(failedRefUpdate.get().getStatus());
        return new ScmPushResult(isSuccess ? ScmPushResultOutcome.SUCCESS : ScmPushResultOutcome.FAILED, failureCause, Optional.ofNullable(pushResult.getMessages()));
    }

    private PushCommand pushCommand(ScmIdentity identity, String remoteName, boolean all) {
        PushCommand push = this.jgitRepository.push();
        push.setRemote(remoteName);
        if (all) {
            push.setPushAll();
        }
        push.setTransportConfigCallback(this.transportConfigFactory.create(identity));
        return push;
    }

    @Override
    public void attachRemote(String remoteName, String remoteUrl) {
        StoredConfig config = this.jgitRepository.getRepository().getConfig();
        try {
            RemoteConfig remote = new RemoteConfig((Config)config, remoteName);
            ArrayList pushUris = new ArrayList(remote.getPushURIs());
            for (URIish uri : pushUris) {
                remote.removePushURI(uri);
            }
            remote.addPushURI(new URIish(remoteUrl));
            remote.update((Config)config);
            config.save();
        }
        catch (IOException | URISyntaxException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public void commit(List<String> patterns, String message) {
        try {
            if (!patterns.isEmpty()) {
                String canonicalPath = Pattern.quote(this.repositoryDir.getCanonicalPath() + File.separatorChar);
                AddCommand command = this.jgitRepository.add();
                patterns.stream().map(p -> p.replaceFirst(canonicalPath, "")).forEach(arg_0 -> ((AddCommand)command).addFilepattern(arg_0));
                command.call();
            }
            this.jgitRepository.commit().setMessage(message).call();
        }
        catch (IOException | GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public ScmPosition positionOfLastChangeIn(String path, List<String> excludeSubFolders, Set<String> dependenciesFolders) {
        RevCommit lastCommit;
        try {
            LogCommand logCommand;
            if (path.isEmpty()) {
                logCommand = this.jgitRepository.log().setMaxCount(1);
                for (String excludedPath : excludeSubFolders) {
                    logCommand.excludePath(this.asUnixPath(excludedPath));
                }
            } else {
                String unixStylePath = this.asUnixPath(path);
                this.assertPathExists(unixStylePath);
                logCommand = this.jgitRepository.log().setMaxCount(1).addPath(unixStylePath);
                for (String dep : dependenciesFolders) {
                    logCommand.addPath(this.asUnixPath(dep));
                }
            }
            lastCommit = (RevCommit)logCommand.call().iterator().next();
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
        ScmPosition currentPosition = this.currentPosition();
        if (lastCommit == null) {
            return currentPosition;
        }
        return new ScmPosition(lastCommit.getName(), currentPosition.getBranch(), currentPosition.getIsClean());
    }

    @Override
    public Boolean isIdenticalForPath(String path, String latestChangeRevision, String tagCommitRevision) {
        if (latestChangeRevision.isEmpty() || tagCommitRevision.isEmpty()) {
            return false;
        }
        if (latestChangeRevision.equals(tagCommitRevision)) {
            return true;
        }
        try {
            ObjectId lastChange = this.jgitRepository.getRepository().resolve(latestChangeRevision);
            ObjectId taggedCommit = this.jgitRepository.getRepository().resolve(tagCommitRevision);
            DiffFormatter diffFormatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
            diffFormatter.setPathFilter((TreeFilter)PathFilter.create((String)this.asUnixPath(path)));
            diffFormatter.setRepository(this.jgitRepository.getRepository());
            return diffFormatter.scan((AnyObjectId)lastChange, (AnyObjectId)taggedCommit).isEmpty();
        }
        catch (IOException e) {
            throw new ScmException(e);
        }
    }

    private String asUnixPath(String path) {
        return path == null ? null : path.replaceAll("\\\\", "/");
    }

    private void assertPathExists(String path) {
        File subpath = new File(this.repositoryDir, path);
        if (!subpath.exists()) {
            throw new ScmException(String.format("Path '%s' does not exist in repository '%s'.", path, this.repositoryDir.getAbsolutePath()));
        }
    }

    @Override
    public ScmPosition currentPosition() {
        String revision = this.getRevision();
        String branchName = this.branchName();
        boolean isClean = !this.checkUncommittedChanges();
        return new ScmPosition(revision, branchName, isClean);
    }

    private String getRevision() {
        try {
            String revision = "";
            if (this.hasCommits()) {
                ObjectId head = this.head();
                revision = head.name();
            }
            return revision;
        }
        catch (IOException e) {
            throw new ScmException(e);
        }
    }

    private String branchName() {
        return this.branchNameFromGithubEnvVariable().orElseGet(this::branchNameFromGit);
    }

    private Optional<String> branchNameFromGithubEnvVariable() {
        if (this.onGithubActions()) {
            return this.env("GITHUB_HEAD_REF").filter(it -> !it.isBlank());
        }
        return Optional.empty();
    }

    private boolean onGithubActions() {
        return this.env("GITHUB_ACTIONS").map(it -> it.equals("true")).orElse(false);
    }

    private boolean onCI() {
        return this.env("CI").map(it -> it.equals("true")).orElse(false);
    }

    private Optional<String> env(String name) {
        return Optional.ofNullable(System.getenv(name));
    }

    private String branchNameFromGit() {
        try {
            Optional<Ref> ref = Optional.ofNullable(this.jgitRepository.getRepository().exactRef("HEAD"));
            String branchName = ref.map(r -> r.getTarget().getName()).map(Repository::shortenRefName).orElse(null);
            if (this.properties.getOverriddenBranchName() != null && !this.properties.getOverriddenBranchName().isEmpty()) {
                branchName = Repository.shortenRefName((String)this.properties.getOverriddenBranchName());
            }
            return branchName;
        }
        catch (IOException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public TagsOnCommit latestTags(List<Pattern> patterns) {
        return this.latestTagsInternal(patterns, null, true);
    }

    @Override
    public TagsOnCommit latestTags(List<Pattern> patterns, String sinceCommit) {
        return this.latestTagsInternal(patterns, sinceCommit, false);
    }

    private TagsOnCommit latestTagsInternal(List<Pattern> patterns, String maybeSinceCommit, boolean inclusive) {
        List<TagsOnCommit> taggedCommits = this.taggedCommitsInternal(patterns, maybeSinceCommit, inclusive, true);
        return taggedCommits.isEmpty() ? TagsOnCommit.empty() : taggedCommits.get(0);
    }

    @Override
    public List<TagsOnCommit> taggedCommits(List<Pattern> patterns) {
        return this.taggedCommitsInternal(patterns, null, true, false);
    }

    private List<TagsOnCommit> taggedCommitsInternal(List<Pattern> patterns, String maybeSinceCommit, boolean inclusive, boolean stopOnFirstTag) {
        ArrayList<TagsOnCommit> taggedCommits = new ArrayList<TagsOnCommit>();
        if (!this.hasCommits()) {
            return taggedCommits;
        }
        try {
            RevCommit currentCommit;
            ObjectId headId = this.jgitRepository.getRepository().resolve("HEAD");
            ObjectId startingCommit = maybeSinceCommit != null ? ObjectId.fromString((String)maybeSinceCommit) : headId;
            RevWalk walk = this.walker(startingCommit);
            if (!inclusive) {
                walk.next();
            }
            Map<String, List<String>> allTags = this.tagsMatching(patterns, walk);
            while ((currentCommit = walk.next()) != null) {
                List<String> currentTagsList = allTags.get(currentCommit.getId().getName());
                if (currentTagsList == null) continue;
                TagsOnCommit taggedCommit = new TagsOnCommit(currentCommit.getId().name(), currentTagsList);
                taggedCommits.add(taggedCommit);
                if (!stopOnFirstTag) continue;
                break;
            }
            walk.dispose();
        }
        catch (IOException | GitAPIException e) {
            throw new ScmException(e);
        }
        return taggedCommits;
    }

    private RevWalk walker(ObjectId startingCommit) throws IOException {
        RevWalk walk = new RevWalk(this.jgitRepository.getRepository());
        walk.sort(RevSort.NONE);
        RevCommit head = walk.parseCommit((AnyObjectId)startingCommit);
        walk.markStart(head);
        return walk;
    }

    private Map<String, List<String>> tagsMatching(List<Pattern> patterns, RevWalk walk) throws GitAPIException {
        List tags = this.jgitRepository.tagList().call();
        return tags.stream().map(tag -> new TagNameAndId(tag.getName().substring(GIT_TAG_PREFIX.length()), this.parseCommitSafe(walk, (AnyObjectId)tag.getObjectId()))).filter(t -> patterns.stream().anyMatch(pattern2 -> pattern2.matcher(t.name).matches())).collect(HashMap::new, (m, t) -> m.computeIfAbsent(t.id, s -> new ArrayList()).add(t.name), HashMap::putAll);
    }

    private String parseCommitSafe(RevWalk walk, AnyObjectId commitId) {
        try {
            return walk.parseCommit(commitId).getName();
        }
        catch (IOException e) {
            throw new ScmException(e);
        }
    }

    private boolean hasCommits() {
        LogCommand log = this.jgitRepository.log();
        log.setMaxCount(1);
        try {
            log.call();
            return true;
        }
        catch (NoHeadException exception) {
            return false;
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public boolean remoteAttached(String remoteName) {
        StoredConfig config = this.jgitRepository.getRepository().getConfig();
        return config.getSubsections("remote").stream().anyMatch(n -> n.equals(remoteName));
    }

    @Override
    public boolean checkUncommittedChanges() {
        Optional<Boolean> overriddenIsClean = this.properties.getOverriddenIsClean();
        if (overriddenIsClean.isPresent()) {
            return overriddenIsClean.get() == false;
        }
        try {
            return !this.jgitRepository.status().call().isClean();
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public int numberOfCommitsAheadOrBehindRemote() {
        try {
            String branchName = this.jgitRepository.getRepository().getFullBranch();
            BranchTrackingStatus status = BranchTrackingStatus.of((Repository)this.jgitRepository.getRepository(), (String)branchName);
            if (status == null) {
                throw new ScmException("Branch " + branchName + " is not set to track another branch");
            }
            if (status.getAheadCount() > 0) {
                return status.getAheadCount();
            }
            if (status.getBehindCount() > 0) {
                return -status.getBehindCount();
            }
            return 0;
        }
        catch (IOException e) {
            throw new ScmException(e);
        }
    }

    public Status listChanges() {
        try {
            return this.jgitRepository.status().call();
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public boolean isLegacyDefTagnameRepo() {
        try {
            List call = this.jgitRepository.tagList().call();
            if (call.isEmpty()) {
                return false;
            }
            return call.stream().allMatch(ref -> ref.getName().startsWith(GIT_TAG_PREFIX + TagPrefixConf.fullLegacyPrefix()));
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    @Override
    public List<String> lastLogMessages(int messageCount) {
        try {
            return StreamSupport.stream(this.jgitRepository.log().setMaxCount(messageCount).call().spliterator(), false).map(RevCommit::getFullMessage).collect(Collectors.toList());
        }
        catch (GitAPIException e) {
            throw new ScmException(e);
        }
    }

    public Git getJgitRepository() {
        return this.jgitRepository;
    }

    private static final class TagNameAndId {
        final String name;
        final String id;

        TagNameAndId(String name, String id) {
            this.name = name;
            this.id = id;
        }
    }
}

