/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain.scm;

import org.gradle.api.tasks.Input;

public class ScmPosition {
    private final String revision;
    private final String shortRevision;
    private final String branch;
    private final boolean isClean;
    private final boolean isReleaseBranch;
    private final Boolean isSnapshot;

    public ScmPosition(String revision, String shortRevision, String branch, boolean isClean, boolean isReleaseBranch, boolean isSnapshot) {
        this.revision = revision;
        this.shortRevision = shortRevision;
        this.branch = branch;
        this.isClean = isClean;
        this.isReleaseBranch = isReleaseBranch;
        this.isSnapshot = isSnapshot;
    }

    public ScmPosition(String revision, String shortRevision, String branch, boolean isClean, boolean isReleaseBranch) {
        this(revision, shortRevision, branch, isClean, isReleaseBranch, false);
    }

    public ScmPosition(String revision, String shortRevision, String branch, boolean isClean) {
        this(revision, shortRevision, branch, isClean, false, false);
    }

    public ScmPosition(String revision, String shortRevision, String branch) {
        this(revision, shortRevision, branch, true, false, false);
    }

    public ScmPosition(String revision, String branch, boolean isClean, boolean isReleaseBranch) {
        this.revision = revision;
        this.shortRevision = revision.length() > 7 ? revision.substring(0, 7) : "";
        this.branch = branch;
        this.isClean = isClean;
        this.isReleaseBranch = isReleaseBranch;
        this.isSnapshot = null;
    }

    public ScmPosition(String revision, String branch, boolean isClean) {
        this(revision, branch, isClean, false);
    }

    public ScmPosition(String revision, String branch) {
        this(revision, branch, true, false);
    }

    public String toString() {
        return "ScmPosition[revision = " + this.revision + ", shortRevision = " + this.shortRevision + ", branch = " + this.branch + ", isClean = " + this.isClean + ", isReleaseBranch = " + this.isReleaseBranch + ", isSnapshot = " + this.isSnapshot + "]";
    }

    @Input
    public String getRevision() {
        return this.revision;
    }

    @Input
    public String getShortRevision() {
        return this.shortRevision;
    }

    @Input
    public String getBranch() {
        return this.branch;
    }

    @Input
    public boolean getIsClean() {
        return this.isClean;
    }

    @Input
    public boolean getIsReleaseBranch() {
        return this.isReleaseBranch;
    }

    @Input
    public boolean getIsSnapshot() {
        if (this.isSnapshot == null) {
            throw new IllegalStateException("isSnapshot is not yet determined");
        }
        return this.isSnapshot;
    }

    public ScmPosition withSnapshotStatus(boolean isSnapshot) {
        return new ScmPosition(this.revision, this.shortRevision, this.branch, this.isClean, this.isReleaseBranch, isSnapshot);
    }
}

