/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.discovery.consul.recipes;

import java.net.URI;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import pl.allegro.tech.discovery.consul.recipes.datacenter.ConsulDatacenterReader;
import pl.allegro.tech.discovery.consul.recipes.json.JsonDeserializer;
import pl.allegro.tech.discovery.consul.recipes.json.JsonSerializer;
import pl.allegro.tech.discovery.consul.recipes.leader.LeaderElector;
import pl.allegro.tech.discovery.consul.recipes.locate.ConsulAgentLocator;
import pl.allegro.tech.discovery.consul.recipes.session.Session;
import pl.allegro.tech.discovery.consul.recipes.watch.ConsulWatcher;
import pl.allegro.tech.discovery.consul.recipes.watch.EndpointWatcher;
import pl.allegro.tech.discovery.consul.recipes.watch.catalog.ServiceInstances;
import pl.allegro.tech.discovery.consul.recipes.watch.catalog.ServiceInstancesWatcher;
import pl.allegro.tech.discovery.consul.recipes.watch.catalog.Services;
import pl.allegro.tech.discovery.consul.recipes.watch.catalog.ServicesWatcher;
import pl.allegro.tech.discovery.consul.recipes.watch.health.HealthServiceInstancesWatcher;

public class ConsulRecipes {
    private OkHttpClient simpleClient = null;
    private OkHttpClient watchesClient = null;
    private final URI localAgentUri;
    private final JsonSerializer jsonSerializer;
    private final JsonDeserializer jsonDeserializer;
    private final int watchesMaxConnectionPerRoute;
    private final int watchesMaxConnectionsTotal;
    private final long simpleReadTimeoutMillis;
    private final long simpleConnectionTimeoutMillis;
    private final long watchesReadTimeoutMillis;
    private final long watchesConnectionTimeoutMillis;

    private ConsulRecipes(URI localAgentUri, JsonSerializer jsonSerializer, JsonDeserializer jsonDeserializer, int watchesMaxConnectionPerRoute, int watchesMaxConnectionsTotal, long simpleReadTimeoutMillis, long simpleConnectionTimeoutMillis, OkHttpClient simpleClient, OkHttpClient watchesClient, long watchesReadTimeoutMillis, long watchesConnectionTimeoutMillis) {
        this.localAgentUri = localAgentUri;
        this.jsonSerializer = jsonSerializer;
        this.jsonDeserializer = jsonDeserializer;
        this.watchesMaxConnectionPerRoute = watchesMaxConnectionPerRoute;
        this.watchesMaxConnectionsTotal = watchesMaxConnectionsTotal;
        this.simpleReadTimeoutMillis = simpleReadTimeoutMillis;
        this.simpleConnectionTimeoutMillis = simpleConnectionTimeoutMillis;
        this.simpleClient = simpleClient;
        this.watchesClient = watchesClient;
        this.watchesReadTimeoutMillis = watchesReadTimeoutMillis;
        this.watchesConnectionTimeoutMillis = watchesConnectionTimeoutMillis;
    }

    public static Builder consulRecipes() {
        return new Builder();
    }

    public ConsulDatacenterReader.Builder consulDatacenterReader() {
        return ConsulDatacenterReader.consulDatacenterReader(this.jsonDeserializer, this.getSimpleClient()).withAgentUri(this.localAgentUri);
    }

    public ConsulAgentLocator.Builder consulAgentLocator() {
        return ConsulAgentLocator.consulAgentLocator(this.jsonDeserializer, this.consulDatacenterReader().build(), this.getSimpleClient()).withAgentUri(this.localAgentUri);
    }

    public ConsulWatcher.Builder consulWatcher(ExecutorService workerPool) {
        return ConsulWatcher.consulWatcher(this.getWatchesClient(), workerPool).withAgentUri(this.localAgentUri);
    }

    public EndpointWatcher<Services> catalogServicesWatcher(ConsulWatcher watcher) {
        return new ServicesWatcher(watcher, this.jsonDeserializer);
    }

    public EndpointWatcher<ServiceInstances> catalogServiceInstancesWatcher(String serviceName, ConsulWatcher watcher) {
        return new ServiceInstancesWatcher(serviceName, watcher, this.jsonDeserializer);
    }

    public EndpointWatcher<ServiceInstances> healthServiceInstancesWatcher(String serviceName, ConsulWatcher watcher) {
        return new HealthServiceInstancesWatcher(serviceName, watcher, this.jsonDeserializer);
    }

    public LeaderElector.Builder leaderElector(String serviceName) {
        return LeaderElector.forService(serviceName, this.getSimpleClient(), this.jsonSerializer, this.jsonDeserializer).withAgentUri(this.localAgentUri);
    }

    public Session.Builder session(String serviceName) {
        return Session.forService(serviceName, this.getSimpleClient(), this.jsonSerializer, this.jsonDeserializer).withAgentUri(this.localAgentUri);
    }

    private OkHttpClient getSimpleClient() {
        if (this.simpleClient == null) {
            this.simpleClient = new OkHttpClient.Builder().readTimeout(this.simpleReadTimeoutMillis, TimeUnit.MILLISECONDS).connectTimeout(this.simpleConnectionTimeoutMillis, TimeUnit.MILLISECONDS).build();
        }
        return this.simpleClient;
    }

    private OkHttpClient getWatchesClient() {
        if (this.watchesClient == null) {
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(this.watchesMaxConnectionsTotal);
            dispatcher.setMaxRequestsPerHost(this.watchesMaxConnectionPerRoute);
            this.watchesClient = new OkHttpClient.Builder().readTimeout(this.watchesReadTimeoutMillis, TimeUnit.MILLISECONDS).connectTimeout(this.watchesConnectionTimeoutMillis, TimeUnit.MILLISECONDS).dispatcher(dispatcher).build();
        }
        return this.watchesClient;
    }

    public static class Builder {
        private JsonDeserializer jsonDeserializer;
        private JsonSerializer jsonSerializer;
        private OkHttpClient simpleClient;
        private OkHttpClient watchesClient;
        private URI localAgentUri = URI.create("http://localhost:8500");
        private int watchesMaxConnectionPerRoute = 1000;
        private int watchesMaxConnectionsTotal = 1000;
        private long simpleReadTimeout = 2000L;
        private long simpleConnectionTimeout = 2000L;
        private long watchesReadTimeout = Duration.ofMinutes(6L).toMillis();
        private long watchesConnectionTimeout = Duration.ofSeconds(2L).toMillis();

        private Builder() {
        }

        public ConsulRecipes build() {
            return new ConsulRecipes(this.localAgentUri, this.jsonSerializer, this.jsonDeserializer, this.watchesMaxConnectionPerRoute, this.watchesMaxConnectionsTotal, this.simpleReadTimeout, this.simpleConnectionTimeout, this.simpleClient, this.watchesClient, this.watchesReadTimeout, this.watchesConnectionTimeout);
        }

        public Builder withJsonSerializer(JsonSerializer jsonSerializer) {
            this.jsonSerializer = jsonSerializer;
            return this;
        }

        public Builder withJsonDeserializer(JsonDeserializer jsonDeserializer) {
            this.jsonDeserializer = jsonDeserializer;
            return this;
        }

        public Builder withSimpleHttpClient(OkHttpClient simpleClient) {
            this.simpleClient = simpleClient;
            return this;
        }

        public Builder withWatchesHttpClient(OkHttpClient watchesClient) {
            this.watchesClient = watchesClient;
            return this;
        }

        public Builder withAgentUri(URI localAgentUri) {
            this.localAgentUri = localAgentUri;
            return this;
        }

        public Builder withMaxWatchedEndpoints(int maxObservedEndpoints) {
            this.withWatchesMaxConnectionsPerRoute(maxObservedEndpoints);
            this.withWatchesMaxConnectionsTotal(maxObservedEndpoints);
            return this;
        }

        public Builder withWatchesMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
            this.watchesMaxConnectionPerRoute = maxConnectionsPerRoute;
            return this;
        }

        public Builder withWatchesMaxConnectionsTotal(int maxConnectionsTotal) {
            this.watchesMaxConnectionsTotal = maxConnectionsTotal;
            return this;
        }

        public Builder withSimpleConnectionTimeoutMillis(long connectionTimeout) {
            this.simpleConnectionTimeout = connectionTimeout;
            return this;
        }

        public Builder withSimpleReadTimeoutMillis(long readTimeout) {
            this.simpleReadTimeout = readTimeout;
            return this;
        }

        public Builder withWatchesConnectionTimeoutMillis(long connectionTimeout) {
            this.watchesConnectionTimeout = connectionTimeout;
            return this;
        }

        public Builder withWatchesReadTimeoutMillis(int readTimeout) {
            this.watchesReadTimeout = readTimeout;
            return this;
        }
    }
}

