/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.discovery.consul.recipes.locate;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.discovery.consul.recipes.datacenter.ConsulDatacenterReader;
import pl.allegro.tech.discovery.consul.recipes.json.JsonDeserializer;
import pl.allegro.tech.discovery.consul.recipes.locate.FailedToFindAgentsException;

public class ConsulAgentLocator {
    private static final Logger logger = LoggerFactory.getLogger(ConsulAgentLocator.class);
    private static final String CONSUL_SERVICE_NAME = "consul";
    private final HttpUrl agentUri;
    private final JsonDeserializer jsonDeserializer;
    private final ConsulDatacenterReader locationReader;
    private final OkHttpClient httpClient;
    private final int agentPort;

    private ConsulAgentLocator(URI agentUri, JsonDeserializer jsonDeserializer, ConsulDatacenterReader locationReader, OkHttpClient httpClient, int agentPort) {
        this.agentUri = HttpUrl.get((URI)agentUri);
        this.jsonDeserializer = jsonDeserializer;
        this.locationReader = locationReader;
        this.httpClient = httpClient;
        this.agentPort = agentPort;
    }

    public static Builder consulAgentLocator(JsonDeserializer jsonDeserializer, ConsulDatacenterReader locationReader, OkHttpClient httpClient) {
        if (jsonDeserializer == null) {
            throw new IllegalStateException("Configured JsonDeserializer required.");
        }
        return new Builder(jsonDeserializer, locationReader, httpClient);
    }

    public Map<String, AgentData> locateDatacenterAgents() {
        return this.locateDatacenterAgents(CONSUL_SERVICE_NAME);
    }

    public Map<String, AgentData> locateDatacenterAgents(String serviceName) {
        return this.locateDatacenterAgents(serviceName, data -> {
            int agentIndex = ThreadLocalRandom.current().nextInt(data.size());
            return (Map)data.get(agentIndex);
        });
    }

    public Map<String, AgentData> locateDatacenterAgents(String serviceName, Function<List<Map<String, Object>>, Map<String, Object>> preferredAgent) {
        String localDatacenter = this.locationReader.localDatacenter();
        List<String> knownDatacenters = this.locationReader.knownDatacenters();
        HashMap<String, AgentData> agents = new HashMap<String, AgentData>();
        for (String datacenter : knownDatacenters) {
            if (localDatacenter.equals(datacenter)) {
                agents.put(datacenter, new AgentData("localhost", this.agentUri.uri()));
                continue;
            }
            AgentData agentData = this.readAgentAddress(datacenter, serviceName, preferredAgent);
            if (agentData == null) continue;
            agents.put(datacenter, agentData);
        }
        if (agents.isEmpty()) {
            throw new FailedToFindAgentsException("Failed to find any agents for service name: " + serviceName);
        }
        return agents;
    }

    private AgentData readAgentAddress(String datacenter, String serviceName, Function<List<Map<String, Object>>, Map<String, Object>> preferredAgent) {
        HttpUrl uri = this.agentUri.newBuilder("v1/health/service/" + serviceName).addQueryParameter("passing", null).addQueryParameter("dc", datacenter).build();
        try {
            Response response = this.httpClient.newCall(new Request.Builder().get().url(uri).build()).execute();
            if (!response.isSuccessful()) {
                logger.error("Received status code other than 2xx when asking for service {} at {}", (Object)serviceName, (Object)uri);
                return null;
            }
            List<Map<String, Object>> data = this.jsonDeserializer.deserializeMapList(response.body().string());
            if (data.isEmpty()) {
                logger.error("No healthy instances of service {} found at {}", (Object)serviceName, (Object)uri);
                return null;
            }
            String address = (String)((Map)preferredAgent.apply(data).get("Node")).get("Address");
            String name = (String)((Map)preferredAgent.apply(data).get("Node")).get("Node");
            return new AgentData(name, URI.create("http://" + address + ":" + this.agentPort));
        }
        catch (Exception exception) {
            logger.error("Failed to read information about remote agent from: {}", (Object)uri, (Object)exception);
            return null;
        }
    }

    public static class AgentData {
        private final String name;
        private final URI uri;

        AgentData(String name, URI uri) {
            this.name = name;
            this.uri = uri;
        }

        public String getName() {
            return this.name;
        }

        public URI getUri() {
            return this.uri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AgentData)) {
                return false;
            }
            AgentData agentData = (AgentData)o;
            return Objects.equals(this.name, agentData.name) && Objects.equals(this.uri, agentData.uri);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.uri);
        }
    }

    public static class Builder {
        private final JsonDeserializer jsonDeserializer;
        private final ConsulDatacenterReader locationReader;
        private final OkHttpClient httpClient;
        private URI agentUri = URI.create("http://localhost:8500");
        private int agentPort = 8500;

        private Builder(JsonDeserializer jsonDeserializer, ConsulDatacenterReader locationReader, OkHttpClient httpClient) {
            this.jsonDeserializer = jsonDeserializer;
            this.locationReader = locationReader;
            this.httpClient = httpClient;
        }

        public ConsulAgentLocator build() {
            return new ConsulAgentLocator(this.agentUri, this.jsonDeserializer, this.locationReader, this.httpClient, this.agentPort);
        }

        public Builder withAgentUri(URI localAgentUri) {
            this.agentUri = localAgentUri;
            return this;
        }

        public Builder withAgentPort(int agentPort) {
            this.agentPort = agentPort;
            return this;
        }
    }
}

