/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.discovery.consul.recipes.watch;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class BackoffRunner
implements AutoCloseable {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final long initialBackoff;
    private final long maxBackoff;

    BackoffRunner(long initialBackoff, long maxBackoff) {
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
    }

    long runWithBackoff(int retry, Runnable action) {
        long backoff = Math.min(this.initialBackoff << retry, this.maxBackoff);
        this.executorService.schedule(action, backoff, TimeUnit.MILLISECONDS);
        return backoff;
    }

    @Override
    public void close() throws Exception {
        this.executorService.shutdownNow();
        this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
    }
}

