/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.discovery.consul.recipes.watch;

import java.net.URI;
import java.time.Clock;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.discovery.consul.recipes.watch.BackoffRunner;
import pl.allegro.tech.discovery.consul.recipes.watch.Canceller;
import pl.allegro.tech.discovery.consul.recipes.watch.ConsulLongPollCallback;
import pl.allegro.tech.discovery.consul.recipes.watch.ConsulWatcherStats;
import pl.allegro.tech.discovery.consul.recipes.watch.WatchResult;

public class ConsulWatcher
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ConsulWatcher.class);
    private final ExecutorService workerPool;
    private final OkHttpClient httpClient;
    private final HttpUrl baseUrl;
    private final BackoffRunner backoffRunner;
    private final boolean allowStale;
    private final ConsulWatcherStats stats;

    private ConsulWatcher(URI uri, ExecutorService workerPool, OkHttpClient httpClient, Clock clock, boolean allowStale, long initialBackoff, long maxBackoff, long recentStatsMillis) {
        this.baseUrl = HttpUrl.get((URI)uri);
        this.workerPool = workerPool;
        this.httpClient = httpClient;
        this.backoffRunner = new BackoffRunner(initialBackoff, maxBackoff);
        this.allowStale = allowStale;
        this.stats = new ConsulWatcherStats(clock, recentStatsMillis);
    }

    public static Builder consulWatcher(OkHttpClient httpClient, ExecutorService workerPool) {
        return new Builder(httpClient, workerPool);
    }

    public Canceller watchEndpoint(String endpoint, Consumer<WatchResult<String>> consumer, Consumer<Exception> failureConsumer) {
        HttpUrl normalizedEndpoint = this.normalizeEndpoint(endpoint);
        logger.info("Starting HTTP long poll for endpoint: {}", (Object)normalizedEndpoint);
        Canceller callbackCanceller = new Canceller();
        this.watchAtIndex(normalizedEndpoint, new ConsulLongPollCallback(this.workerPool, this.backoffRunner, normalizedEndpoint, consumer, failureConsumer, this::reconnect, this.stats, callbackCanceller), 0L);
        return callbackCanceller;
    }

    private HttpUrl normalizeEndpoint(String endpoint) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder(endpoint).addQueryParameter("wait", "5m");
        if (this.allowStale) {
            builder.addQueryParameter("stale", "");
        }
        return builder.build();
    }

    private void watchAtIndex(HttpUrl endpoint, ConsulLongPollCallback callback, long index) {
        if (!callback.isCancelled()) {
            logger.trace("Starting long poll at endpoint {} with index {}", (Object)endpoint, (Object)index);
            HttpUrl url = endpoint.newBuilder().addQueryParameter("index", Long.toString(index)).build();
            Request request = new Request.Builder().get().url(url).build();
            this.httpClient.newCall(request).enqueue((Callback)callback);
        } else {
            logger.info("Stopping long poll at endpoint {}", (Object)endpoint);
        }
    }

    private void reconnect(HttpUrl endpoint, long index, ConsulLongPollCallback callback) {
        this.watchAtIndex(endpoint, callback, index);
    }

    public ConsulWatcherStats stats() {
        return this.stats;
    }

    @Override
    public void close() throws Exception {
        this.httpClient.dispatcher().cancelAll();
        this.backoffRunner.close();
    }

    public static class Builder {
        private URI agentUri = URI.create("http://localhost:8500");
        private final ExecutorService workerPool;
        private final OkHttpClient httpClient;
        private Clock clock = Clock.systemDefaultZone();
        private boolean allowStale = true;
        private int initialReconnectBackoffMillis = 100;
        private int maxReconnectBackoffMillis = 60000;
        private long recentStatsMillis = TimeUnit.MINUTES.toMillis(1L);

        private Builder(OkHttpClient httpClient, ExecutorService workerPool) {
            this.workerPool = workerPool;
            this.httpClient = httpClient;
        }

        public ConsulWatcher build() {
            return new ConsulWatcher(this.agentUri, this.workerPool, this.httpClient, this.clock, this.allowStale, this.initialReconnectBackoffMillis, this.maxReconnectBackoffMillis, this.recentStatsMillis);
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withAgentUri(URI agentUri) {
            this.agentUri = agentUri;
            return this;
        }

        public Builder withBackoff(int initialReconnectBackoffMillis, int maxReconnectBackoffMillis) {
            this.initialReconnectBackoffMillis = initialReconnectBackoffMillis;
            this.maxReconnectBackoffMillis = maxReconnectBackoffMillis;
            return this;
        }

        public Builder requireDefaultConsistency() {
            this.allowStale = false;
            return this;
        }

        public Builder withRecentStatsMillis(long recentStatsMillis) {
            this.recentStatsMillis = recentStatsMillis;
            return this;
        }
    }
}

