/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.discovery.consul.recipes.watch;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import pl.allegro.tech.discovery.consul.recipes.watch.RecentCounter;

public class ConsulWatcherStats {
    private final AtomicLong eventsTotal = new AtomicLong(0L);
    private final AtomicLong actionableEvents = new AtomicLong(0L);
    private final AtomicLong contentNotChangedEvents = new AtomicLong(0L);
    private final AtomicLong indexNotChangedEvents = new AtomicLong(0L);
    private final AtomicLong failures = new AtomicLong(0L);
    private final RecentCounter recentFailures;

    public ConsulWatcherStats(Clock clock, long recentStatsMillis) {
        this.recentFailures = new RecentCounter(clock, recentStatsMillis);
    }

    public ConsulWatcherStats() {
        this.recentFailures = new RecentCounter(Clock.systemDefaultZone(), TimeUnit.MINUTES.toMillis(1L));
    }

    void eventReceived() {
        this.eventsTotal.incrementAndGet();
    }

    void callbackCalled() {
        this.actionableEvents.incrementAndGet();
    }

    void contentNotChanged() {
        this.contentNotChangedEvents.incrementAndGet();
    }

    void indexNotChanged() {
        this.indexNotChangedEvents.incrementAndGet();
    }

    void failed() {
        this.failures.incrementAndGet();
        this.recentFailures.increment();
    }

    public long getEventsTotal() {
        return this.eventsTotal.get();
    }

    public long getActionableEvents() {
        return this.actionableEvents.get();
    }

    public long getContentNotChangedEvents() {
        return this.contentNotChangedEvents.get();
    }

    public long getIndexNotChangedEvents() {
        return this.indexNotChangedEvents.get();
    }

    public long getFailures() {
        return this.failures.get();
    }

    public long getRecentFailures() {
        return this.recentFailures.lastCompletedCount();
    }
}

