/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.discovery.consul.recipes.watch;

import java.util.function.Consumer;
import pl.allegro.tech.discovery.consul.recipes.json.JsonDecoder;
import pl.allegro.tech.discovery.consul.recipes.watch.Canceller;
import pl.allegro.tech.discovery.consul.recipes.watch.ConsulWatcher;
import pl.allegro.tech.discovery.consul.recipes.watch.ConsulWatcherStats;
import pl.allegro.tech.discovery.consul.recipes.watch.WatchResult;

public class EndpointWatcher<T> {
    private final String endpoint;
    private final ConsulWatcher watcher;
    private final JsonDecoder<T> decoder;

    public EndpointWatcher(String endpoint, ConsulWatcher watcher, JsonDecoder<T> decoder) {
        this.endpoint = endpoint;
        this.watcher = watcher;
        this.decoder = decoder;
    }

    public Canceller watch(Consumer<WatchResult<T>> consumer, Consumer<Exception> failureConsumer) {
        return this.watcher.watchEndpoint(this.endpoint, watchResult -> {
            try {
                consumer.accept(watchResult.map(this.decoder::decode));
            }
            catch (Exception e) {
                failureConsumer.accept(e);
            }
        }, failureConsumer);
    }

    public ConsulWatcherStats stats() {
        return this.watcher.stats();
    }

    public String endpoint() {
        return this.endpoint;
    }
}

