/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.discovery.consul.recipes.watch;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class RecentCounter {
    private final Clock clock;
    private final long intervalMillis;
    private AtomicLong lastUpdate;
    private AtomicInteger lastIndex;
    private LongAdder[] counts = new LongAdder[]{new LongAdder(), new LongAdder(), new LongAdder()};

    public RecentCounter(Clock clock, long intervalMillis) {
        if (intervalMillis < TimeUnit.SECONDS.toMillis(1L)) {
            throw new IllegalArgumentException("Interval needs to be at least 1 second. " + intervalMillis + "ms provided.");
        }
        this.clock = clock;
        this.intervalMillis = intervalMillis;
        this.lastUpdate = new AtomicLong(clock.millis());
        this.lastIndex = new AtomicInteger(this.currentIndex(this.lastUpdate.get()));
    }

    public void increment() {
        long now = this.clock.millis();
        int index = this.currentIndex(now);
        int nextIndex = this.nextIndex(now);
        int previousIndex = this.previousIndex(now);
        if (this.lastUpdate.get() <= now - this.intervalMillis * 2L) {
            this.counts[index].reset();
            this.counts[nextIndex].reset();
            this.counts[previousIndex].reset();
        } else if (this.lastIndex.get() != index) {
            this.counts[index].reset();
        }
        this.counts[index].increment();
        this.lastUpdate.set(now);
        this.lastIndex.set(index);
    }

    public long lastCompletedCount() {
        long now = this.clock.millis();
        if (this.lastUpdate.get() <= now - 2L * this.intervalMillis) {
            return 0L;
        }
        return this.counts[this.previousIndex(now)].sum();
    }

    public long currentCount() {
        long now = this.clock.millis();
        if (this.lastUpdate.get() <= now - this.intervalMillis) {
            return 0L;
        }
        return this.counts[this.currentIndex(now)].sum();
    }

    private int currentIndex(long millis) {
        return this.offsetIndex(millis, 0);
    }

    private int previousIndex(long millis) {
        return this.offsetIndex(millis, 2);
    }

    private int nextIndex(long millis) {
        return this.offsetIndex(millis, 1);
    }

    private int offsetIndex(long millis, int offset) {
        return ((int)(millis / this.intervalMillis) + offset) % 3;
    }
}

