/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.discovery.consul.recipes.watch;

import java.util.Objects;
import java.util.function.Function;

public class WatchResult<T> {
    private final long index;
    private final T body;

    public WatchResult(long index, T body) {
        this.index = index;
        this.body = body;
    }

    public long getIndex() {
        return this.index;
    }

    public T getBody() {
        return this.body;
    }

    public <R> WatchResult<R> map(Function<T, R> mapper) {
        return new WatchResult<R>(this.index, mapper.apply(this.body));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchResult that = (WatchResult)o;
        return this.index == that.index && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.body);
    }
}

