/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.discovery.consul.recipes.watch.catalog;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Services {
    private final Map<String, List<String>> serviceNamesToTags;

    public Services(Map<String, List<String>> serviceNamesToTags) {
        this.serviceNamesToTags = serviceNamesToTags;
    }

    boolean containsService(String serviceName) {
        return this.serviceNamesToTags.containsKey(serviceName);
    }

    List<String> tagsForService(String serviceName) {
        if (!this.containsService(serviceName)) {
            throw new IllegalArgumentException("Service " + serviceName + " is not found in catalog.");
        }
        return this.serviceNamesToTags.get(serviceName);
    }

    public Set<String> serviceNames() {
        return this.serviceNamesToTags.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Services services = (Services)o;
        return Objects.equals(this.serviceNamesToTags, services.serviceNamesToTags);
    }

    public int hashCode() {
        return Objects.hash(this.serviceNamesToTags);
    }
}

