/*
 * Decompiled with CFR 0.152.
 */
package pl.andrzejressel.dto.serializator;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pl.andrzejressel.dto.serializator.Serializator;

public interface AppendSerializator<T>
extends Serializator<T> {
    @Contract(pure=true)
    @NotNull
    public List<ByteBuffer> serializeToList(T var1);

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteBuffer serialize(T t) {
        List<ByteBuffer> bbs = this.serializeToList(t);
        int sum = bbs.stream().mapToInt(Buffer::capacity).sum();
        ByteBuffer finalBB = ByteBuffer.allocate(sum);
        bbs.forEach(byteBuffer -> finalBB.put(byteBuffer.rewind()));
        return finalBB;
    }
}

