/*
 * Decompiled with CFR 0.152.
 */
package pl.andrzejressel.dto.serializator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import pl.andrzejressel.dto.serializator.AppendSerializator;
import pl.andrzejressel.dto.serializator.Serializator;

public class ListSerializator<T>
implements AppendSerializator<List<T>> {
    private final Serializator<T> instance;

    public ListSerializator(Serializator<T> instance) {
        this.instance = instance;
    }

    @Override
    @NotNull
    public List<ByteBuffer> serializeToList(List<T> t) {
        ByteBuffer sizeBB = ByteBuffer.allocate(4);
        sizeBB.putInt(t.size());
        List elements = t.stream().map(this.instance::serialize).collect(Collectors.toList());
        ArrayList<ByteBuffer> finalBBs = new ArrayList<ByteBuffer>();
        finalBBs.add(sizeBB);
        finalBBs.addAll(elements);
        return finalBBs;
    }

    @Override
    public List<T> deserialize(ByteBuffer bb) {
        int size = bb.getInt();
        ArrayList<T> elements = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            elements.add(this.instance.deserialize(bb));
        }
        return elements;
    }
}

