/*
 * Decompiled with CFR 0.152.
 */
package pl.andrzejressel.dto.serializator;

import java.nio.ByteBuffer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pl.andrzejressel.dto.serializator.Serializator;

public class LongSerializator
implements Serializator<Long> {
    public static Serializator<Long> INSTANCE = new LongSerializator();

    private LongSerializator() {
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public ByteBuffer serialize(@NotNull Long l) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(l);
        return bb;
    }

    @Override
    @NotNull
    public Long deserialize(@NotNull ByteBuffer bb) {
        return bb.getLong();
    }
}

