/*
 * Decompiled with CFR 0.152.
 */
package pl.andrzejressel.dto.serializator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import pl.andrzejressel.dto.serializator.AppendSerializator;
import pl.andrzejressel.dto.serializator.Serializator;
import pl.andrzejressel.dto.serializator.Tuple2;

public class Map2Serializator<A, B, RET>
implements AppendSerializator<RET> {
    private final Tuple2<Serializator<A>, Serializator<B>> serializators;
    private final Function<RET, Tuple2<A, B>> deconstruct;
    private final Function<Tuple2<A, B>, RET> construct;

    public Map2Serializator(Tuple2<Serializator<A>, Serializator<B>> serializators, Function<RET, Tuple2<A, B>> deconstruct, Function<Tuple2<A, B>, RET> construct) {
        this.serializators = serializators;
        this.deconstruct = deconstruct;
        this.construct = construct;
    }

    @Override
    @NotNull
    public List<ByteBuffer> serializeToList(RET ret) {
        Tuple2<A, B> deconstructed = this.deconstruct.apply(ret);
        ByteBuffer a = ((Serializator)this.serializators.a).serialize(deconstructed.a);
        ByteBuffer b = ((Serializator)this.serializators.b).serialize(deconstructed.b);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>();
        bbs.add(a);
        bbs.add(b);
        return bbs;
    }

    @Override
    public RET deserialize(ByteBuffer bb) {
        Object a = ((Serializator)this.serializators.a).deserialize(bb);
        Object b = ((Serializator)this.serializators.b).deserialize(bb);
        return this.construct.apply(new Tuple2(a, b));
    }
}

