/*
 * Decompiled with CFR 0.152.
 */
package pl.andrzejressel.dto.serializator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import pl.andrzejressel.dto.serializator.AppendSerializator;
import pl.andrzejressel.dto.serializator.Serializator;
import pl.andrzejressel.dto.serializator.Tuple3;

public class Map3Serializator<A, B, C, RET>
implements AppendSerializator<RET> {
    private final Tuple3<Serializator<A>, Serializator<B>, Serializator<C>> serializators;
    private final Function<RET, Tuple3<A, B, C>> deconstruct;
    private final Function<Tuple3<A, B, C>, RET> construct;

    public Map3Serializator(Tuple3<Serializator<A>, Serializator<B>, Serializator<C>> serializators, Function<RET, Tuple3<A, B, C>> deconstruct, Function<Tuple3<A, B, C>, RET> construct) {
        this.serializators = serializators;
        this.deconstruct = deconstruct;
        this.construct = construct;
    }

    @Override
    @NotNull
    public List<ByteBuffer> serializeToList(RET ret) {
        Tuple3<A, B, C> deconstructed = this.deconstruct.apply(ret);
        ByteBuffer a = ((Serializator)this.serializators.a).serialize(deconstructed.a);
        ByteBuffer b = ((Serializator)this.serializators.b).serialize(deconstructed.b);
        ByteBuffer c = ((Serializator)this.serializators.c).serialize(deconstructed.c);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>();
        bbs.add(a);
        bbs.add(b);
        bbs.add(c);
        return bbs;
    }

    @Override
    public RET deserialize(ByteBuffer bb) {
        Object a = ((Serializator)this.serializators.a).deserialize(bb);
        Object b = ((Serializator)this.serializators.b).deserialize(bb);
        Object c = ((Serializator)this.serializators.c).deserialize(bb);
        return this.construct.apply(new Tuple3(a, b, c));
    }
}

