/*
 * Decompiled with CFR 0.152.
 */
package pl.andrzejressel.dto.serializator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import pl.andrzejressel.dto.serializator.AppendSerializator;
import pl.andrzejressel.dto.serializator.Serializator;
import pl.andrzejressel.dto.serializator.Tuple4;

public class Map4Serializator<A, B, C, D, RET>
implements AppendSerializator<RET> {
    private final Tuple4<Serializator<A>, Serializator<B>, Serializator<C>, Serializator<D>> serializators;
    private final Function<RET, Tuple4<A, B, C, D>> deconstruct;
    private final Function<Tuple4<A, B, C, D>, RET> construct;

    public Map4Serializator(Tuple4<Serializator<A>, Serializator<B>, Serializator<C>, Serializator<D>> serializators, Function<RET, Tuple4<A, B, C, D>> deconstruct, Function<Tuple4<A, B, C, D>, RET> construct) {
        this.serializators = serializators;
        this.deconstruct = deconstruct;
        this.construct = construct;
    }

    @Override
    @NotNull
    public List<ByteBuffer> serializeToList(RET ret) {
        Tuple4<A, B, C, D> deconstructed = this.deconstruct.apply(ret);
        ByteBuffer a = ((Serializator)this.serializators.a).serialize(deconstructed.a);
        ByteBuffer b = ((Serializator)this.serializators.b).serialize(deconstructed.b);
        ByteBuffer c = ((Serializator)this.serializators.c).serialize(deconstructed.c);
        ByteBuffer d = ((Serializator)this.serializators.d).serialize(deconstructed.d);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>();
        bbs.add(a);
        bbs.add(b);
        bbs.add(c);
        bbs.add(d);
        return bbs;
    }

    @Override
    public RET deserialize(ByteBuffer bb) {
        Object a = ((Serializator)this.serializators.a).deserialize(bb);
        Object b = ((Serializator)this.serializators.b).deserialize(bb);
        Object c = ((Serializator)this.serializators.c).deserialize(bb);
        Object d = ((Serializator)this.serializators.d).deserialize(bb);
        return this.construct.apply(new Tuple4(a, b, c, d));
    }
}

