/*
 * Decompiled with CFR 0.152.
 */
package pl.andrzejressel.dto.serializator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import pl.andrzejressel.dto.serializator.AppendSerializator;
import pl.andrzejressel.dto.serializator.Serializator;
import pl.andrzejressel.dto.serializator.Tuple5;

public class Map5Serializator<A, B, C, D, E, RET>
implements AppendSerializator<RET> {
    private final Tuple5<Serializator<A>, Serializator<B>, Serializator<C>, Serializator<D>, Serializator<E>> serializators;
    private final Function<RET, Tuple5<A, B, C, D, E>> deconstruct;
    private final Function<Tuple5<A, B, C, D, E>, RET> construct;

    public Map5Serializator(Tuple5<Serializator<A>, Serializator<B>, Serializator<C>, Serializator<D>, Serializator<E>> serializators, Function<RET, Tuple5<A, B, C, D, E>> deconstruct, Function<Tuple5<A, B, C, D, E>, RET> construct) {
        this.serializators = serializators;
        this.deconstruct = deconstruct;
        this.construct = construct;
    }

    @Override
    @NotNull
    public List<ByteBuffer> serializeToList(RET ret) {
        Tuple5<A, B, C, D, E> deconstructed = this.deconstruct.apply(ret);
        ByteBuffer a = ((Serializator)this.serializators.a).serialize(deconstructed.a);
        ByteBuffer b = ((Serializator)this.serializators.b).serialize(deconstructed.b);
        ByteBuffer c = ((Serializator)this.serializators.c).serialize(deconstructed.c);
        ByteBuffer d = ((Serializator)this.serializators.d).serialize(deconstructed.d);
        ByteBuffer e = ((Serializator)this.serializators.e).serialize(deconstructed.e);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>();
        bbs.add(a);
        bbs.add(b);
        bbs.add(c);
        bbs.add(d);
        bbs.add(e);
        return bbs;
    }

    @Override
    public RET deserialize(ByteBuffer bb) {
        Object a = ((Serializator)this.serializators.a).deserialize(bb);
        Object b = ((Serializator)this.serializators.b).deserialize(bb);
        Object c = ((Serializator)this.serializators.c).deserialize(bb);
        Object d = ((Serializator)this.serializators.d).deserialize(bb);
        Object e = ((Serializator)this.serializators.e).deserialize(bb);
        return this.construct.apply(new Tuple5(a, b, c, d, e));
    }
}

