/*
 * Decompiled with CFR 0.152.
 */
package pl.andrzejressel.dto.serializator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import pl.andrzejressel.dto.serializator.AppendSerializator;
import pl.andrzejressel.dto.serializator.Serializator;
import pl.andrzejressel.dto.serializator.Tuple6;

public class Map6Serializator<A, B, C, D, E, F, RET>
implements AppendSerializator<RET> {
    private final Tuple6<Serializator<A>, Serializator<B>, Serializator<C>, Serializator<D>, Serializator<E>, Serializator<F>> serializators;
    private final Function<RET, Tuple6<A, B, C, D, E, F>> deconstruct;
    private final Function<Tuple6<A, B, C, D, E, F>, RET> construct;

    public Map6Serializator(Tuple6<Serializator<A>, Serializator<B>, Serializator<C>, Serializator<D>, Serializator<E>, Serializator<F>> serializators, Function<RET, Tuple6<A, B, C, D, E, F>> deconstruct, Function<Tuple6<A, B, C, D, E, F>, RET> construct) {
        this.serializators = serializators;
        this.deconstruct = deconstruct;
        this.construct = construct;
    }

    @Override
    @NotNull
    public List<ByteBuffer> serializeToList(RET ret) {
        Tuple6<A, B, C, D, E, F> deconstructed = this.deconstruct.apply(ret);
        ByteBuffer a = ((Serializator)this.serializators.a).serialize(deconstructed.a);
        ByteBuffer b = ((Serializator)this.serializators.b).serialize(deconstructed.b);
        ByteBuffer c = ((Serializator)this.serializators.c).serialize(deconstructed.c);
        ByteBuffer d = ((Serializator)this.serializators.d).serialize(deconstructed.d);
        ByteBuffer e = ((Serializator)this.serializators.e).serialize(deconstructed.e);
        ByteBuffer f = ((Serializator)this.serializators.f).serialize(deconstructed.f);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>();
        bbs.add(a);
        bbs.add(b);
        bbs.add(c);
        bbs.add(d);
        bbs.add(e);
        bbs.add(f);
        return bbs;
    }

    @Override
    public RET deserialize(ByteBuffer bb) {
        Object a = ((Serializator)this.serializators.a).deserialize(bb);
        Object b = ((Serializator)this.serializators.b).deserialize(bb);
        Object c = ((Serializator)this.serializators.c).deserialize(bb);
        Object d = ((Serializator)this.serializators.d).deserialize(bb);
        Object e = ((Serializator)this.serializators.e).deserialize(bb);
        Object f = ((Serializator)this.serializators.f).deserialize(bb);
        return this.construct.apply(new Tuple6(a, b, c, d, e, f));
    }
}

