/*
 * Decompiled with CFR 0.152.
 */
package pl.andrzejressel.dto.serializator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import pl.andrzejressel.dto.serializator.AppendSerializator;
import pl.andrzejressel.dto.serializator.Serializator;

public class MapSerializator<K, V>
implements AppendSerializator<Map<K, V>> {
    private final Serializator<K> keySerializator;
    private final Serializator<V> valueSerializator;

    public MapSerializator(Serializator<K> keySerializator, Serializator<V> valueSerializator) {
        this.keySerializator = keySerializator;
        this.valueSerializator = valueSerializator;
    }

    @Override
    @NotNull
    public List<ByteBuffer> serializeToList(Map<K, V> m) {
        ByteBuffer sizeBB = ByteBuffer.allocate(4);
        sizeBB.putInt(m.size());
        ArrayList<ByteBuffer> finalBBs = new ArrayList<ByteBuffer>(m.size() * 2);
        finalBBs.add(sizeBB);
        m.forEach((k, v) -> {
            finalBBs.add(this.keySerializator.serialize(k));
            finalBBs.add(this.valueSerializator.serialize(v));
        });
        return finalBBs;
    }

    @Override
    public Map<K, V> deserialize(ByteBuffer bb) {
        int size = bb.getInt();
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < size; ++i) {
            map.put(this.keySerializator.deserialize(bb), this.valueSerializator.deserialize(bb));
        }
        return map;
    }
}

