/*
 * Decompiled with CFR 0.152.
 */
package pl.andrzejressel.dto.serializator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import pl.andrzejressel.dto.serializator.AppendSerializator;
import pl.andrzejressel.dto.serializator.Serializator;

public class NullableSerializator<T>
implements AppendSerializator<T> {
    private final Serializator<T> s;

    public static <T> Serializator<T> create(Serializator<T> t) {
        return new NullableSerializator<T>(t);
    }

    public NullableSerializator(Serializator<T> s) {
        this.s = s;
    }

    @Override
    @NotNull
    public List<ByteBuffer> serializeToList(T t) {
        if (t == null) {
            return List.of(this.getNullByteBuffer());
        }
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        result.add(this.getNonNullByteBuffer());
        result.add(this.s.serialize(t));
        return result;
    }

    @Override
    public T deserialize(ByteBuffer bb) {
        byte firstBit = bb.get();
        if (firstBit == 0) {
            return null;
        }
        return this.s.deserialize(bb);
    }

    private ByteBuffer getNullByteBuffer() {
        return ByteBuffer.wrap(new byte[]{0});
    }

    private ByteBuffer getNonNullByteBuffer() {
        return ByteBuffer.wrap(new byte[]{1});
    }
}

