/*
 * Decompiled with CFR 0.152.
 */
package pl.andrzejressel.dto.serializator;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import pl.andrzejressel.dto.serializator.Serializator;

public class StringSerializator
implements Serializator<String> {
    public static Serializator<String> INSTANCE = new StringSerializator();

    private StringSerializator() {
    }

    @Override
    @NotNull
    public ByteBuffer serialize(@NotNull String l) {
        byte[] bytes = l.getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb = ByteBuffer.allocate(4 + bytes.length);
        bb.putInt(bytes.length);
        bb.put(bytes);
        return bb;
    }

    @Override
    @NotNull
    public String deserialize(@NotNull ByteBuffer bb) {
        int stringSize = bb.getInt();
        byte[] buffer = new byte[stringSize];
        bb.get(buffer);
        return new String(buffer, StandardCharsets.UTF_8);
    }
}

