/*
 * Decompiled with CFR 0.152.
 */
package pl.bclogic.pulsator4droid.library;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import java.util.List;
import pl.bclogic.pulsator4droid.library.R;

public class PulsatorLayout
extends RelativeLayout {
    public static final int INFINITE = 0;
    public static final int INTERP_LINEAR = 0;
    public static final int INTERP_ACCELERATE = 1;
    public static final int INTERP_DECELERATE = 2;
    public static final int INTERP_ACCELERATE_DECELERATE = 3;
    private static final int DEFAULT_COUNT = 4;
    private static final int DEFAULT_COLOR = Color.rgb((int)0, (int)116, (int)193);
    private static final int DEFAULT_DURATION = 7000;
    private static final int DEFAULT_REPEAT = 0;
    private static final boolean DEFAULT_START_FROM_SCRATCH = true;
    private static final int DEFAULT_INTERPOLATOR = 0;
    private int mCount;
    private int mDuration;
    private int mRepeat;
    private boolean mStartFromScratch;
    private int mColor;
    private int mInterpolator;
    private final List<View> mViews = new ArrayList<View>();
    private AnimatorSet mAnimatorSet;
    private Paint mPaint;
    private float mRadius;
    private float mCenterX;
    private float mCenterY;
    private boolean mIsStarted;
    private final Animator.AnimatorListener mAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animator) {
            PulsatorLayout.this.mIsStarted = true;
        }

        public void onAnimationEnd(Animator animator) {
            PulsatorLayout.this.mIsStarted = false;
        }

        public void onAnimationCancel(Animator animator) {
            PulsatorLayout.this.mIsStarted = false;
        }

        public void onAnimationRepeat(Animator animator) {
        }
    };

    public PulsatorLayout(Context context) {
        this(context, null, 0);
    }

    public PulsatorLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PulsatorLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attr = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Pulsator4Droid, 0, 0);
        this.mCount = 4;
        this.mDuration = 7000;
        this.mRepeat = 0;
        this.mStartFromScratch = true;
        this.mColor = DEFAULT_COLOR;
        this.mInterpolator = 0;
        try {
            this.mCount = attr.getInteger(R.styleable.Pulsator4Droid_pulse_count, 4);
            this.mDuration = attr.getInteger(R.styleable.Pulsator4Droid_pulse_duration, 7000);
            this.mRepeat = attr.getInteger(R.styleable.Pulsator4Droid_pulse_repeat, 0);
            this.mStartFromScratch = attr.getBoolean(R.styleable.Pulsator4Droid_pulse_startFromScratch, true);
            this.mColor = attr.getColor(R.styleable.Pulsator4Droid_pulse_color, DEFAULT_COLOR);
            this.mInterpolator = attr.getInteger(R.styleable.Pulsator4Droid_pulse_interpolator, 0);
        }
        finally {
            attr.recycle();
        }
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mColor);
        this.build();
    }

    public synchronized void start() {
        if (this.mAnimatorSet == null || this.mIsStarted) {
            return;
        }
        this.mAnimatorSet.start();
        if (!this.mStartFromScratch) {
            ArrayList animators = this.mAnimatorSet.getChildAnimations();
            for (Animator animator : animators) {
                ObjectAnimator objectAnimator = (ObjectAnimator)animator;
                long delay = objectAnimator.getStartDelay();
                objectAnimator.setStartDelay(0L);
                objectAnimator.setCurrentPlayTime((long)this.mDuration - delay);
            }
        }
    }

    public synchronized void stop() {
        if (this.mAnimatorSet == null || !this.mIsStarted) {
            return;
        }
        this.mAnimatorSet.end();
    }

    public synchronized boolean isStarted() {
        return this.mAnimatorSet != null && this.mIsStarted;
    }

    public int getCount() {
        return this.mCount;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count cannot be negative");
        }
        if (count != this.mCount) {
            this.mCount = count;
            this.reset();
            this.invalidate();
        }
    }

    public void setDuration(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException("Duration cannot be negative");
        }
        if (millis != this.mDuration) {
            this.mDuration = millis;
            this.reset();
            this.invalidate();
        }
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color) {
        if (color != this.mColor) {
            this.mColor = color;
            if (this.mPaint != null) {
                this.mPaint.setColor(color);
            }
        }
    }

    public int getInterpolator() {
        return this.mInterpolator;
    }

    public void setInterpolator(int type) {
        if (type != this.mInterpolator) {
            this.mInterpolator = type;
            this.reset();
            this.invalidate();
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec) - this.getPaddingTop() - this.getPaddingBottom();
        this.mCenterX = (float)width * 0.5f;
        this.mCenterY = (float)height * 0.5f;
        this.mRadius = (float)Math.min(width, height) * 0.5f;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void clear() {
        this.stop();
        for (View view : this.mViews) {
            this.removeView(view);
        }
        this.mViews.clear();
    }

    private void build() {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        int repeatCount = this.mRepeat == 0 ? -1 : this.mRepeat;
        ArrayList<ObjectAnimator> animators = new ArrayList<ObjectAnimator>();
        for (int index = 0; index < this.mCount; ++index) {
            PulseView pulseView = new PulseView(this.getContext());
            pulseView.setScaleX(0.0f);
            pulseView.setScaleY(0.0f);
            pulseView.setAlpha(1.0f);
            this.addView(pulseView, index, (ViewGroup.LayoutParams)layoutParams);
            this.mViews.add(pulseView);
            long delay = index * this.mDuration / this.mCount;
            ObjectAnimator scaleXAnimator = ObjectAnimator.ofFloat((Object)((Object)pulseView), (String)"ScaleX", (float[])new float[]{0.0f, 1.0f});
            scaleXAnimator.setRepeatCount(repeatCount);
            scaleXAnimator.setRepeatMode(1);
            scaleXAnimator.setStartDelay(delay);
            animators.add(scaleXAnimator);
            ObjectAnimator scaleYAnimator = ObjectAnimator.ofFloat((Object)((Object)pulseView), (String)"ScaleY", (float[])new float[]{0.0f, 1.0f});
            scaleYAnimator.setRepeatCount(repeatCount);
            scaleYAnimator.setRepeatMode(1);
            scaleYAnimator.setStartDelay(delay);
            animators.add(scaleYAnimator);
            ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)((Object)pulseView), (String)"Alpha", (float[])new float[]{1.0f, 0.0f});
            alphaAnimator.setRepeatCount(repeatCount);
            alphaAnimator.setRepeatMode(1);
            alphaAnimator.setStartDelay(delay);
            animators.add(alphaAnimator);
        }
        this.mAnimatorSet = new AnimatorSet();
        this.mAnimatorSet.playTogether(animators);
        this.mAnimatorSet.setInterpolator((TimeInterpolator)PulsatorLayout.createInterpolator(this.mInterpolator));
        this.mAnimatorSet.setDuration((long)this.mDuration);
        this.mAnimatorSet.addListener(this.mAnimatorListener);
    }

    private void reset() {
        boolean isStarted = this.isStarted();
        this.clear();
        this.build();
        if (isStarted) {
            this.start();
        }
    }

    private static Interpolator createInterpolator(int type) {
        switch (type) {
            case 1: {
                return new AccelerateInterpolator();
            }
            case 2: {
                return new DecelerateInterpolator();
            }
            case 3: {
                return new AccelerateDecelerateInterpolator();
            }
        }
        return new LinearInterpolator();
    }

    private class PulseView
    extends View {
        public PulseView(Context context) {
            super(context);
        }

        protected void onDraw(Canvas canvas) {
            canvas.drawCircle(PulsatorLayout.this.mCenterX, PulsatorLayout.this.mCenterY, PulsatorLayout.this.mRadius, PulsatorLayout.this.mPaint);
        }
    }
}

