/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.writer;

import io.micronaut.aop.HotSwappableInterceptedProxy;
import io.micronaut.aop.Intercepted;
import io.micronaut.aop.InterceptedProxy;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.Introduced;
import io.micronaut.aop.chain.InterceptorChain;
import io.micronaut.aop.chain.MethodInterceptorChain;
import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.Label;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.configuration.ConfigurationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.ExecutableMethodWriter;
import io.micronaut.inject.writer.OriginatingElements;
import io.micronaut.inject.writer.ProxyingBeanDefinitionVisitor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class AopProxyWriter
extends AbstractClassFileWriter
implements ProxyingBeanDefinitionVisitor {
    public static final int HASHCODE = 31;
    public static final int MAX_LOCALS = 3;
    public static final Method METHOD_GET_PROXY_TARGET = Method.getMethod(ReflectionUtils.getRequiredInternalMethod(ExecutionHandleLocator.class, "getProxyTargetMethod", Class.class, Qualifier.class, String.class, Class[].class));
    public static final Method METHOD_GET_PROXY_TARGET_BEAN = Method.getMethod(ReflectionUtils.getRequiredInternalMethod(BeanLocator.class, "getProxyTargetBean", Class.class, Qualifier.class));
    public static final Type FIELD_TYPE_INTERCEPTORS = Type.getType(Interceptor[][].class);
    public static final Type TYPE_INTERCEPTOR_CHAIN = Type.getType(InterceptorChain.class);
    public static final Type TYPE_METHOD_INTERCEPTOR_CHAIN = Type.getType(MethodInterceptorChain.class);
    public static final String FIELD_TARGET = "$target";
    public static final String FIELD_READ_WRITE_LOCK = "$target_rwl";
    public static final Type TYPE_READ_WRITE_LOCK = Type.getType(ReentrantReadWriteLock.class);
    public static final String FIELD_READ_LOCK = "$target_rl";
    public static final String FIELD_WRITE_LOCK = "$target_wl";
    public static final Type TYPE_LOCK = Type.getType(Lock.class);
    public static final Type TYPE_BEAN_LOCATOR = Type.getType(BeanLocator.class);
    public static final String METHOD_RESOLVE_TARGET = "$resolveTarget";
    private static final Method METHOD_PROXY_TARGET_TYPE = Method.getMethod(ReflectionUtils.getRequiredInternalMethod(ProxyBeanDefinition.class, "getTargetDefinitionType", new Class[0]));
    private static final Method METHOD_PROXY_TARGET_CLASS = Method.getMethod(ReflectionUtils.getRequiredInternalMethod(ProxyBeanDefinition.class, "getTargetType", new Class[0]));
    private static final java.lang.reflect.Method RESOLVE_INTRODUCTION_INTERCEPTORS_METHOD = ReflectionUtils.getRequiredInternalMethod(InterceptorChain.class, "resolveIntroductionInterceptors", BeanContext.class, ExecutableMethod.class, List.class);
    private static final java.lang.reflect.Method RESOLVE_AROUND_INTERCEPTORS_METHOD = ReflectionUtils.getRequiredInternalMethod(InterceptorChain.class, "resolveAroundInterceptors", BeanContext.class, ExecutableMethod.class, List.class);
    private static final Constructor CONSTRUCTOR_METHOD_INTERCEPTOR_CHAIN = ReflectionUtils.findConstructor(MethodInterceptorChain.class, Interceptor[].class, Object.class, ExecutableMethod.class, Object[].class).orElseThrow(() -> new IllegalStateException("new MethodInterceptorChain(..) constructor not found. Incompatible version of Micronaut?"));
    private static final Constructor CONSTRUCTOR_METHOD_INTERCEPTOR_CHAIN_NO_PARAMS = ReflectionUtils.findConstructor(MethodInterceptorChain.class, Interceptor[].class, Object.class, ExecutableMethod.class).orElseThrow(() -> new IllegalStateException("new MethodInterceptorChain(..) constructor not found. Incompatible version of Micronaut?"));
    private static final String FIELD_INTERCEPTORS = "$interceptors";
    private static final String FIELD_BEAN_LOCATOR = "$beanLocator";
    private static final String FIELD_BEAN_QUALIFIER = "$beanQualifier";
    private static final String FIELD_PROXY_METHODS = "$proxyMethods";
    private static final Type FIELD_TYPE_PROXY_METHODS = Type.getType(ExecutableMethod[].class);
    private static final Type EXECUTABLE_METHOD_TYPE = Type.getType(ExecutableMethod.class);
    private static final Type INTERCEPTOR_ARRAY_TYPE = Type.getType(Interceptor[].class);
    private final String packageName;
    private final String targetClassShortName;
    private final ClassWriter classWriter;
    private final String targetClassFullName;
    private final String proxyFullName;
    private final BeanDefinitionWriter proxyBeanDefinitionWriter;
    private final String proxyInternalName;
    private final Map<String, AnnotationValue<?>> interceptorBinding;
    private final Set<ClassElement> interfaceTypes;
    private final Type proxyType;
    private final boolean hotswap;
    private final boolean lazy;
    private final boolean isInterface;
    private final BeanDefinitionWriter parentWriter;
    private final boolean isIntroduction;
    private final boolean implementInterface;
    private boolean isProxyTarget;
    private MethodVisitor constructorWriter;
    private final List<ExecutableMethodWriter> proxiedMethods = new ArrayList<ExecutableMethodWriter>();
    private final Set<MethodRef> proxiedMethodsRefSet = new HashSet<MethodRef>();
    private final List<MethodRef> proxyTargetMethods = new ArrayList<MethodRef>();
    private int proxyMethodCount = 0;
    private GeneratorAdapter constructorGenerator;
    private int interceptorArgumentIndex;
    private int beanContextArgumentIndex = -1;
    private int qualifierIndex;
    private final List<Runnable> deferredInjectionPoints = new ArrayList<Runnable>();
    private boolean constructorRequiresReflection;
    private MethodElement declaredConstructor;
    private MethodElement newConstructor;
    private ParameterElement interceptorParameter;
    private ParameterElement qualifierParameter;

    public AopProxyWriter(BeanDefinitionWriter parent, OptionalValues<Boolean> settings, ConfigurationMetadataBuilder<?> metadataBuilder, AnnotationValue<?> ... interceptorBinding) {
        super(parent.getOriginatingElements());
        this.isIntroduction = false;
        this.implementInterface = true;
        this.parentWriter = parent;
        this.isProxyTarget = settings.get(Interceptor.PROXY_TARGET).orElse(false) != false || parent.isInterface();
        this.hotswap = this.isProxyTarget && settings.get(Interceptor.HOTSWAP).orElse(false) != false;
        this.lazy = this.isProxyTarget && settings.get(Interceptor.LAZY).orElse(false) != false;
        this.isInterface = parent.isInterface();
        this.packageName = parent.getPackageName();
        this.targetClassShortName = parent.getBeanSimpleName();
        this.targetClassFullName = this.packageName + '.' + this.targetClassShortName;
        this.classWriter = new ClassWriter(3);
        this.proxyFullName = parent.getBeanDefinitionName() + "$Intercepted";
        String proxyShortName = NameUtils.getSimpleName(this.proxyFullName);
        this.proxyInternalName = AopProxyWriter.getInternalName(this.proxyFullName);
        this.proxyType = AopProxyWriter.getTypeReferenceForName(this.proxyFullName, new String[0]);
        this.interceptorBinding = new LinkedHashMap(this.toInterceptorBindingMap(interceptorBinding));
        this.interfaceTypes = Collections.emptySet();
        this.proxyBeanDefinitionWriter = new BeanDefinitionWriter(NameUtils.getPackageName(this.proxyFullName), proxyShortName, this.isInterface, parent, parent.getAnnotationMetadata(), metadataBuilder);
        this.startClass(this.classWriter, AopProxyWriter.getInternalName(this.proxyFullName), AopProxyWriter.getTypeReferenceForName(this.targetClassFullName, new String[0]));
        this.processAlreadyVisitedMethods(parent);
        this.proxyBeanDefinitionWriter.setInterceptedType(this.targetClassFullName);
    }

    public AopProxyWriter(String packageName, String className, boolean isInterface, Element originatingElement, AnnotationMetadata annotationMetadata, ClassElement[] interfaceTypes, ConfigurationMetadataBuilder<?> metadataBuilder, ConfigurationMetadata configurationMetadata, AnnotationValue<?> ... interceptorBinding) {
        this(packageName, className, isInterface, true, originatingElement, annotationMetadata, interfaceTypes, metadataBuilder, configurationMetadata, interceptorBinding);
    }

    public AopProxyWriter(String packageName, String className, boolean isInterface, boolean implementInterface, Element originatingElement, AnnotationMetadata annotationMetadata, ClassElement[] interfaceTypes, ConfigurationMetadataBuilder<?> metadataBuilder, ConfigurationMetadata configurationMetadata, AnnotationValue<?> ... interceptorBinding) {
        super(OriginatingElements.of(originatingElement));
        this.isIntroduction = true;
        this.implementInterface = implementInterface;
        if (!implementInterface && ArrayUtils.isEmpty(interfaceTypes)) {
            throw new IllegalArgumentException("if argument implementInterface is false at least one interface should be provided to the 'interfaceTypes' argument");
        }
        this.packageName = packageName;
        this.isInterface = isInterface;
        this.hotswap = false;
        this.lazy = false;
        this.targetClassShortName = className;
        this.targetClassFullName = packageName + '.' + this.targetClassShortName;
        this.parentWriter = null;
        this.proxyFullName = this.targetClassFullName + "$Intercepted";
        this.proxyInternalName = AopProxyWriter.getInternalName(this.proxyFullName);
        this.proxyType = AopProxyWriter.getTypeReferenceForName(this.proxyFullName, new String[0]);
        this.interceptorBinding = this.toInterceptorBindingMap(interceptorBinding);
        this.interfaceTypes = interfaceTypes != null ? new LinkedHashSet<ClassElement>(Arrays.asList(interfaceTypes)) : Collections.emptySet();
        this.classWriter = new ClassWriter(3);
        String proxyShortName = NameUtils.getSimpleName(this.proxyFullName);
        if (configurationMetadata != null) {
            String existingPrefix = annotationMetadata.stringValue(ConfigurationReader.class, "prefix").orElse("");
            String computedPrefix = StringUtils.isNotEmpty(existingPrefix) ? existingPrefix + "." + configurationMetadata.getName() : configurationMetadata.getName();
            annotationMetadata = DefaultAnnotationMetadata.mutateMember(annotationMetadata, ConfigurationReader.class.getName(), "prefix", computedPrefix);
        }
        this.proxyBeanDefinitionWriter = new BeanDefinitionWriter(NameUtils.getPackageName(this.proxyFullName), proxyShortName, isInterface, this, annotationMetadata, metadataBuilder);
        if (isInterface) {
            if (implementInterface) {
                this.proxyBeanDefinitionWriter.setInterceptedType(this.targetClassFullName);
            }
        } else {
            this.proxyBeanDefinitionWriter.setInterceptedType(this.targetClassFullName);
        }
        this.startClass(this.classWriter, this.proxyInternalName, AopProxyWriter.getTypeReferenceForName(this.targetClassFullName, new String[0]));
    }

    public boolean isProxyTarget() {
        return this.isProxyTarget;
    }

    @Override
    protected void startClass(ClassVisitor classWriter, String className, Type superType) {
        String[] interfaces = this.getImplementedInterfaceInternalNames();
        classWriter.visit(52, 4096, className, null, !this.isInterface ? superType.getInternalName() : null, interfaces);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
        classWriter.visitField(18, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS.getDescriptor(), null, null);
        classWriter.visitField(18, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS.getDescriptor(), null, null);
    }

    private String[] getImplementedInterfaceInternalNames() {
        return (String[])this.interfaceTypes.stream().map(o -> JavaModelUtils.getTypeReference(o).getInternalName()).toArray(String[]::new);
    }

    @Override
    @Deprecated
    public Element getOriginatingElement() {
        return this.proxyBeanDefinitionWriter.getOriginatingElement();
    }

    @Override
    public boolean isSingleton() {
        return this.proxyBeanDefinitionWriter.isSingleton();
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public void visitBeanDefinitionInterface(Class<? extends BeanDefinition> interfaceType) {
        this.proxyBeanDefinitionWriter.visitBeanDefinitionInterface(interfaceType);
    }

    @Override
    public String getBeanTypeName() {
        return this.proxyBeanDefinitionWriter.getBeanTypeName();
    }

    @Override
    public Type getProvidedType() {
        return this.proxyBeanDefinitionWriter.getProvidedType();
    }

    @Override
    public void setValidated(boolean validated) {
        this.proxyBeanDefinitionWriter.setValidated(validated);
    }

    @Override
    public void setInterceptedType(String typeName) {
        this.proxyBeanDefinitionWriter.setInterceptedType(typeName);
    }

    @Override
    public Optional<Type> getInterceptedType() {
        return this.proxyBeanDefinitionWriter.getInterceptedType();
    }

    @Override
    public boolean isValidated() {
        return this.proxyBeanDefinitionWriter.isValidated();
    }

    @Override
    public String getBeanDefinitionName() {
        return this.proxyBeanDefinitionWriter.getBeanDefinitionName();
    }

    @Override
    public void visitBeanDefinitionConstructor(MethodElement constructor, boolean requiresReflection) {
        this.constructorRequiresReflection = requiresReflection;
        this.declaredConstructor = constructor;
    }

    @Override
    public void visitDefaultConstructor(AnnotationMetadata annotationMetadata) {
        this.constructorRequiresReflection = false;
        ClassElement classElement = ClassElement.of(this.proxyType.getClassName());
        this.declaredConstructor = MethodElement.of(classElement, annotationMetadata, classElement, classElement, "<init>", new ParameterElement[0]);
    }

    private void initConstructor(MethodElement constructor) {
        ClassElement interceptorList = ClassElement.of(List.class, AnnotationMetadata.EMPTY_METADATA, Collections.singletonMap("E", ClassElement.of(BeanRegistration.class, AnnotationMetadata.EMPTY_METADATA, Collections.singletonMap("T", ClassElement.of(Interceptor.class)))));
        this.interceptorParameter = ParameterElement.of(interceptorList, FIELD_INTERCEPTORS);
        this.qualifierParameter = ParameterElement.of(Qualifier.class, "$qualifier");
        this.newConstructor = constructor.withNewParameters(ParameterElement.of(BeanContext.class, "$beanContext"), this.qualifierParameter, this.interceptorParameter);
        ParameterElement[] parameters = constructor.getParameters();
        this.beanContextArgumentIndex = parameters.length;
        this.qualifierIndex = parameters.length + 1;
        this.interceptorArgumentIndex = parameters.length + 2;
    }

    @Override
    @NonNull
    public String getBeanDefinitionReferenceClassName() {
        return this.proxyBeanDefinitionWriter.getBeanDefinitionReferenceClassName();
    }

    public void visitIntroductionMethod(TypedElement declaringBean, MethodElement methodElement) {
        this.visitAroundMethod(declaringBean, methodElement);
    }

    public void visitAroundMethod(TypedElement beanType, MethodElement methodElement) {
        String methodName = methodElement.getName();
        ClassElement returnType = methodElement.isSuspend() ? ClassElement.of(Object.class) : methodElement.getReturnType();
        List<ParameterElement> argumentTypeList = Arrays.asList(methodElement.getSuspendParameters());
        int argumentCount = argumentTypeList.size();
        Type returnTypeObject = JavaModelUtils.getTypeReference(returnType);
        boolean isPrimitive = returnType.isPrimitive();
        boolean isVoidReturn = isPrimitive && returnTypeObject.equals(Type.VOID_TYPE);
        Type declaringTypeReference = JavaModelUtils.getTypeReference(beanType);
        MethodRef methodKey = new MethodRef(methodName, argumentTypeList, returnTypeObject);
        if (!this.proxiedMethodsRefSet.contains(methodKey)) {
            int index = this.proxyMethodCount++;
            String interceptedProxyClassName = null;
            String interceptedProxyBridgeMethodName = null;
            if (!(this.isProxyTarget || methodElement.isAbstract() && !methodElement.isDefault())) {
                interceptedProxyClassName = this.proxyFullName;
                interceptedProxyBridgeMethodName = "$$access$$" + methodName;
                String bridgeDesc = AopProxyWriter.getMethodDescriptor(returnType, argumentTypeList);
                MethodVisitor bridgeWriter = this.classWriter.visitMethod(4096, interceptedProxyBridgeMethodName, bridgeDesc, null, null);
                GeneratorAdapter bridgeGenerator = new GeneratorAdapter(bridgeWriter, 4096, interceptedProxyBridgeMethodName, bridgeDesc);
                bridgeGenerator.loadThis();
                for (int i = 0; i < argumentTypeList.size(); ++i) {
                    bridgeGenerator.loadArg(i);
                }
                String desc = AopProxyWriter.getMethodDescriptor(returnType, argumentTypeList);
                bridgeWriter.visitMethodInsn(183, declaringTypeReference.getInternalName(), methodName, desc, this.isInterface && methodElement.isDefault());
                AopProxyWriter.pushReturnValue(bridgeWriter, returnType);
                bridgeWriter.visitMaxs(13, 1);
                bridgeWriter.visitEnd();
            }
            BeanDefinitionWriter beanDefinitionWriter = this.parentWriter == null ? this.proxyBeanDefinitionWriter : this.parentWriter;
            ExecutableMethodWriter executableMethodWriter = beanDefinitionWriter.visitExecutableMethod(beanType, methodElement, interceptedProxyClassName, interceptedProxyBridgeMethodName);
            this.proxiedMethods.add(executableMethodWriter);
            this.proxiedMethodsRefSet.add(methodKey);
            this.proxyTargetMethods.add(methodKey);
            this.buildMethodOverride(returnType, methodName, index, argumentTypeList, argumentCount, isVoidReturn);
        }
    }

    private void buildMethodOverride(TypedElement returnType, String methodName, int index, List<ParameterElement> argumentTypeList, int argumentCount, boolean isVoidReturn) {
        String desc = AopProxyWriter.getMethodDescriptor(returnType, argumentTypeList);
        MethodVisitor overridden = this.classWriter.visitMethod(1, methodName, desc, null, null);
        GeneratorAdapter overriddenMethodGenerator = new GeneratorAdapter(overridden, 1, methodName, desc);
        overriddenMethodGenerator.loadThis();
        overriddenMethodGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
        overriddenMethodGenerator.push(index);
        overriddenMethodGenerator.visitInsn(50);
        int methodProxyVar = overriddenMethodGenerator.newLocal(EXECUTABLE_METHOD_TYPE);
        overriddenMethodGenerator.storeLocal(methodProxyVar);
        overriddenMethodGenerator.loadThis();
        overriddenMethodGenerator.getField(this.proxyType, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS);
        overriddenMethodGenerator.push(index);
        overriddenMethodGenerator.visitInsn(50);
        int interceptorsLocalVar = overriddenMethodGenerator.newLocal(INTERCEPTOR_ARRAY_TYPE);
        overriddenMethodGenerator.storeLocal(interceptorsLocalVar);
        overriddenMethodGenerator.newInstance(TYPE_METHOD_INTERCEPTOR_CHAIN);
        overriddenMethodGenerator.dup();
        overriddenMethodGenerator.loadLocal(interceptorsLocalVar);
        overriddenMethodGenerator.loadThis();
        if (this.isProxyTarget) {
            if (this.hotswap || this.lazy) {
                overriddenMethodGenerator.invokeInterface(Type.getType(InterceptedProxy.class), Method.getMethod("java.lang.Object interceptedTarget()"));
            } else {
                overriddenMethodGenerator.getField(this.proxyType, FIELD_TARGET, AopProxyWriter.getTypeReferenceForName(this.targetClassFullName, new String[0]));
            }
        }
        overriddenMethodGenerator.loadLocal(methodProxyVar);
        if (argumentCount > 0) {
            overriddenMethodGenerator.push(argumentCount);
            overriddenMethodGenerator.newArray(Type.getType(Object.class));
            for (int i = 0; i < argumentCount; ++i) {
                overriddenMethodGenerator.dup();
                ParameterElement argType = argumentTypeList.get(i);
                overriddenMethodGenerator.push(i);
                overriddenMethodGenerator.loadArg(i);
                AopProxyWriter.pushBoxPrimitiveIfNecessary(argType, (MethodVisitor)overriddenMethodGenerator);
                overriddenMethodGenerator.visitInsn(83);
            }
            overriddenMethodGenerator.invokeConstructor(TYPE_METHOD_INTERCEPTOR_CHAIN, Method.getMethod(CONSTRUCTOR_METHOD_INTERCEPTOR_CHAIN));
        } else {
            overriddenMethodGenerator.invokeConstructor(TYPE_METHOD_INTERCEPTOR_CHAIN, Method.getMethod(CONSTRUCTOR_METHOD_INTERCEPTOR_CHAIN_NO_PARAMS));
        }
        int chainVar = overriddenMethodGenerator.newLocal(TYPE_METHOD_INTERCEPTOR_CHAIN);
        overriddenMethodGenerator.storeLocal(chainVar);
        overriddenMethodGenerator.loadLocal(chainVar);
        overriddenMethodGenerator.visitMethodInsn(182, TYPE_INTERCEPTOR_CHAIN.getInternalName(), "proceed", AopProxyWriter.getMethodDescriptor(Object.class.getName(), new String[0]), false);
        if (isVoidReturn) {
            this.returnVoid(overriddenMethodGenerator);
        } else {
            AopProxyWriter.pushCastToType((MethodVisitor)overriddenMethodGenerator, returnType);
            AopProxyWriter.pushReturnValue(overriddenMethodGenerator, returnType);
        }
        overriddenMethodGenerator.visitMaxs(13, chainVar);
        overriddenMethodGenerator.visitEnd();
    }

    @Override
    public void visitBeanDefinitionEnd() {
        String[] adviceInterfaces;
        if (this.declaredConstructor == null) {
            throw new IllegalStateException("The method visitBeanDefinitionConstructor(..) should be called at least once");
        }
        this.initConstructor(this.declaredConstructor);
        this.interceptorParameter.annotate("io.micronaut.inject.qualifiers.InterceptorBindingQualifier", builder -> {
            AnnotationValue[] interceptorBinding = this.interceptorBinding.values().toArray(new AnnotationValue[0]);
            builder.values(interceptorBinding);
        });
        this.qualifierParameter.annotate("javax.annotation.Nullable");
        String constructorDescriptor = AopProxyWriter.getConstructorDescriptor(Arrays.asList(this.newConstructor.getParameters()));
        ClassWriter proxyClassWriter = this.classWriter;
        this.constructorWriter = proxyClassWriter.visitMethod(1, "<init>", constructorDescriptor, null, null);
        GeneratorAdapter proxyConstructorGenerator = this.constructorGenerator = new GeneratorAdapter(this.constructorWriter, 1, "<init>", constructorDescriptor);
        proxyConstructorGenerator.loadThis();
        if (this.isInterface) {
            proxyConstructorGenerator.invokeConstructor(TYPE_OBJECT, METHOD_DEFAULT_CONSTRUCTOR);
        } else {
            ParameterElement[] existingArguments = this.declaredConstructor.getParameters();
            for (int i = 0; i < existingArguments.length; ++i) {
                proxyConstructorGenerator.loadArg(i);
            }
            String superConstructorDescriptor = AopProxyWriter.getConstructorDescriptor(Arrays.asList(existingArguments));
            proxyConstructorGenerator.invokeConstructor(AopProxyWriter.getTypeReferenceForName(this.targetClassFullName, new String[0]), new Method("<init>", superConstructorDescriptor));
        }
        this.proxyBeanDefinitionWriter.visitBeanDefinitionConstructor(this.newConstructor, this.constructorRequiresReflection);
        GeneratorAdapter targetDefinitionGenerator = null;
        GeneratorAdapter targetTypeGenerator = null;
        if (this.parentWriter != null) {
            this.proxyBeanDefinitionWriter.visitBeanDefinitionInterface(ProxyBeanDefinition.class);
            ClassVisitor pcw = this.proxyBeanDefinitionWriter.getClassWriter();
            targetDefinitionGenerator = new GeneratorAdapter(pcw.visitMethod(1, METHOD_PROXY_TARGET_TYPE.getName(), METHOD_PROXY_TARGET_TYPE.getDescriptor(), null, null), 1, METHOD_PROXY_TARGET_TYPE.getName(), METHOD_PROXY_TARGET_TYPE.getDescriptor());
            targetDefinitionGenerator.loadThis();
            targetDefinitionGenerator.push(AopProxyWriter.getTypeReferenceForName(this.parentWriter.getBeanDefinitionName(), new String[0]));
            targetDefinitionGenerator.returnValue();
            targetTypeGenerator = new GeneratorAdapter(pcw.visitMethod(1, METHOD_PROXY_TARGET_CLASS.getName(), METHOD_PROXY_TARGET_CLASS.getDescriptor(), null, null), 1, METHOD_PROXY_TARGET_CLASS.getName(), METHOD_PROXY_TARGET_CLASS.getDescriptor());
            targetTypeGenerator.loadThis();
            targetTypeGenerator.push(AopProxyWriter.getTypeReferenceForName(this.parentWriter.getBeanTypeName(), new String[0]));
            targetTypeGenerator.returnValue();
        }
        Class interceptedInterface = this.isIntroduction ? Introduced.class : Intercepted.class;
        Type targetType = AopProxyWriter.getTypeReferenceForName(this.targetClassFullName, new String[0]);
        if (this.isProxyTarget) {
            proxyClassWriter.visitField(18, FIELD_BEAN_LOCATOR, TYPE_BEAN_LOCATOR.getDescriptor(), null, null);
            proxyClassWriter.visitField(2, FIELD_BEAN_QUALIFIER, Type.getType(Qualifier.class).getDescriptor(), null, null);
            this.writeWithQualifierMethod(proxyClassWriter);
            if (this.lazy) {
                interceptedInterface = InterceptedProxy.class;
            } else {
                interceptedInterface = this.hotswap ? HotSwappableInterceptedProxy.class : InterceptedProxy.class;
                int modifiers = this.hotswap ? 2 : 18;
                proxyClassWriter.visitField(modifiers, FIELD_TARGET, targetType.getDescriptor(), null, null);
                if (this.hotswap) {
                    proxyClassWriter.visitField(18, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK.getDescriptor(), null, null);
                    proxyConstructorGenerator.loadThis();
                    this.pushNewInstance(proxyConstructorGenerator, TYPE_READ_WRITE_LOCK);
                    proxyConstructorGenerator.putField(this.proxyType, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK);
                    proxyClassWriter.visitField(18, FIELD_READ_LOCK, TYPE_LOCK.getDescriptor(), null, null);
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.getField(this.proxyType, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK);
                    proxyConstructorGenerator.invokeInterface(Type.getType(ReadWriteLock.class), Method.getMethod(Lock.class.getName() + " readLock()"));
                    proxyConstructorGenerator.putField(this.proxyType, FIELD_READ_LOCK, TYPE_LOCK);
                    proxyClassWriter.visitField(18, FIELD_WRITE_LOCK, Type.getDescriptor(Lock.class), null, null);
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.getField(this.proxyType, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK);
                    proxyConstructorGenerator.invokeInterface(Type.getType(ReadWriteLock.class), Method.getMethod(Lock.class.getName() + " writeLock()"));
                    proxyConstructorGenerator.putField(this.proxyType, FIELD_WRITE_LOCK, TYPE_LOCK);
                }
            }
            proxyConstructorGenerator.loadThis();
            proxyConstructorGenerator.loadArg(this.beanContextArgumentIndex);
            proxyConstructorGenerator.putField(this.proxyType, FIELD_BEAN_LOCATOR, TYPE_BEAN_LOCATOR);
            proxyConstructorGenerator.loadThis();
            proxyConstructorGenerator.loadArg(this.qualifierIndex);
            proxyConstructorGenerator.putField(this.proxyType, FIELD_BEAN_QUALIFIER, Type.getType(Qualifier.class));
            Method resolveTargetMethodDesc = this.writeResolveTargetMethod(proxyClassWriter, targetType);
            if (!this.lazy) {
                proxyConstructorGenerator.loadThis();
                proxyConstructorGenerator.loadThis();
                proxyConstructorGenerator.invokeVirtual(this.proxyType, resolveTargetMethodDesc);
                proxyConstructorGenerator.putField(this.proxyType, FIELD_TARGET, targetType);
            }
            this.writeInterceptedTargetMethod(proxyClassWriter, targetType, resolveTargetMethodDesc);
            if (this.hotswap && !this.lazy) {
                this.writeSwapMethod(proxyClassWriter, targetType);
            }
        }
        String[] interfaces = this.getImplementedInterfaceInternalNames();
        if (this.isInterface && this.implementInterface) {
            adviceInterfaces = new String[]{AopProxyWriter.getInternalName(this.targetClassFullName), Type.getInternalName(interceptedInterface)};
            interfaces = ArrayUtils.concat(interfaces, adviceInterfaces);
        } else {
            adviceInterfaces = new String[]{Type.getInternalName(interceptedInterface)};
            interfaces = ArrayUtils.concat(interfaces, adviceInterfaces);
        }
        proxyClassWriter.visit(52, 4096, this.proxyInternalName, null, this.isInterface ? TYPE_OBJECT.getInternalName() : AopProxyWriter.getTypeReferenceForName(this.targetClassFullName, new String[0]).getInternalName(), interfaces);
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.push(this.proxyMethodCount);
        proxyConstructorGenerator.newArray(EXECUTABLE_METHOD_TYPE);
        proxyConstructorGenerator.putField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.push(this.proxyMethodCount);
        proxyConstructorGenerator.newArray(INTERCEPTOR_ARRAY_TYPE);
        proxyConstructorGenerator.putField(this.proxyType, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS);
        if (this.isProxyTarget) {
            if (this.proxiedMethods.size() == this.proxyMethodCount) {
                Iterator<MethodRef> iterator = this.proxyTargetMethods.iterator();
                for (int i = 0; i < this.proxyMethodCount; ++i) {
                    MethodRef methodRef = iterator.next();
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
                    proxyConstructorGenerator.push(i);
                    proxyConstructorGenerator.loadArg(this.beanContextArgumentIndex);
                    proxyConstructorGenerator.push(targetType);
                    proxyConstructorGenerator.loadArg(this.qualifierIndex);
                    AopProxyWriter.pushMethodNameAndTypesArguments(proxyConstructorGenerator, methodRef.name, methodRef.argumentTypes);
                    proxyConstructorGenerator.invokeInterface(Type.getType(ExecutionHandleLocator.class), METHOD_GET_PROXY_TARGET);
                    proxyConstructorGenerator.visitInsn(83);
                    this.pushResolveInterceptorsCall(proxyConstructorGenerator, i, this.isIntroduction);
                }
            }
        } else {
            for (int i = 0; i < this.proxyMethodCount; ++i) {
                ExecutableMethodWriter executableMethodWriter = this.proxiedMethods.get(i);
                boolean introduction = this.isIntroduction && (executableMethodWriter.isAbstract() || executableMethodWriter.isInterface() && !executableMethodWriter.isDefault());
                proxyConstructorGenerator.loadThis();
                proxyConstructorGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
                proxyConstructorGenerator.push(i);
                Type methodType = Type.getObjectType(executableMethodWriter.getInternalName());
                proxyConstructorGenerator.newInstance(methodType);
                proxyConstructorGenerator.dup();
                if (executableMethodWriter.isSupportsInterceptedProxy()) {
                    proxyConstructorGenerator.push(true);
                    proxyConstructorGenerator.invokeConstructor(methodType, new Method("<init>", AopProxyWriter.getConstructorDescriptor(Boolean.TYPE)));
                } else {
                    proxyConstructorGenerator.invokeConstructor(methodType, new Method("<init>", "()V"));
                }
                proxyConstructorGenerator.visitInsn(83);
                this.pushResolveInterceptorsCall(proxyConstructorGenerator, i, introduction);
            }
        }
        for (Runnable fieldInjectionPoint : this.deferredInjectionPoints) {
            fieldInjectionPoint.run();
        }
        this.constructorWriter.visitInsn(177);
        this.constructorWriter.visitMaxs(13, 1);
        this.constructorWriter.visitEnd();
        this.proxyBeanDefinitionWriter.visitBeanDefinitionEnd();
        if (targetDefinitionGenerator != null) {
            targetDefinitionGenerator.visitMaxs(1, 1);
            targetDefinitionGenerator.visitEnd();
        }
        if (targetTypeGenerator != null) {
            targetTypeGenerator.visitMaxs(1, 1);
            targetTypeGenerator.visitEnd();
        }
        proxyClassWriter.visitEnd();
    }

    @Override
    public void writeTo(File compilationDir) throws IOException {
        this.accept(this.newClassWriterOutputVisitor(compilationDir));
    }

    @Override
    public void accept(ClassWriterOutputVisitor visitor) throws IOException {
        this.proxyBeanDefinitionWriter.accept(visitor);
        try (OutputStream out = visitor.visitClass(this.proxyFullName, this.getOriginatingElements());){
            out.write(this.classWriter.toByteArray());
        }
    }

    @Override
    public void visitSuperBeanDefinition(String name) {
        this.proxyBeanDefinitionWriter.visitSuperBeanDefinition(name);
    }

    @Override
    public void visitSuperBeanDefinitionFactory(String beanName) {
        this.proxyBeanDefinitionWriter.visitSuperBeanDefinitionFactory(beanName);
    }

    @Override
    public void visitSetterValue(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection, boolean isOptional) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitSetterValue(declaringType, methodElement, requiresReflection, isOptional));
    }

    @Override
    public void visitPostConstructMethod(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitPostConstructMethod(declaringType, methodElement, requiresReflection));
    }

    @Override
    public void visitPreDestroyMethod(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitPreDestroyMethod(declaringType, methodElement, requiresReflection));
    }

    @Override
    public void visitMethodInjectionPoint(TypedElement beanType, MethodElement methodElement, boolean requiresReflection) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitMethodInjectionPoint(beanType, methodElement, requiresReflection));
    }

    @Override
    public ExecutableMethodWriter visitExecutableMethod(TypedElement declaringBean, MethodElement methodElement) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitExecutableMethod(declaringBean, methodElement));
        return null;
    }

    @Override
    public void visitFieldInjectionPoint(TypedElement declaringType, FieldElement fieldType, boolean requiresReflection) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitFieldInjectionPoint(declaringType, fieldType, requiresReflection));
    }

    @Override
    public void visitFieldValue(TypedElement declaringType, FieldElement fieldType, boolean requiresReflection, boolean isOptional) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitFieldValue(declaringType, fieldType, requiresReflection, isOptional));
    }

    @Override
    public String getPackageName() {
        return this.proxyBeanDefinitionWriter.getPackageName();
    }

    @Override
    public String getBeanSimpleName() {
        return this.proxyBeanDefinitionWriter.getBeanSimpleName();
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.proxyBeanDefinitionWriter.getAnnotationMetadata();
    }

    @Override
    public void visitConfigBuilderField(ClassElement type, String field, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder, boolean isInterface) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderField(type, field, annotationMetadata, metadataBuilder, isInterface);
    }

    @Override
    public void visitConfigBuilderMethod(ClassElement type, String methodName, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder, boolean isInterface) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderMethod(type, methodName, annotationMetadata, metadataBuilder, isInterface);
    }

    @Override
    public void visitConfigBuilderMethod(String prefix, ClassElement returnType, String methodName, ClassElement paramType, Map<String, ClassElement> generics, String propertyPath) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderMethod(prefix, returnType, methodName, paramType, generics, propertyPath);
    }

    @Override
    public void visitConfigBuilderDurationMethod(String prefix, ClassElement returnType, String methodName, String propertyPath) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderDurationMethod(prefix, returnType, methodName, propertyPath);
    }

    @Override
    public void visitConfigBuilderEnd() {
        this.proxyBeanDefinitionWriter.visitConfigBuilderEnd();
    }

    @Override
    public void setRequiresMethodProcessing(boolean shouldPreProcess) {
        this.proxyBeanDefinitionWriter.setRequiresMethodProcessing(shouldPreProcess);
    }

    @Override
    public void visitTypeArguments(Map<String, Map<String, ClassElement>> typeArguments) {
        this.proxyBeanDefinitionWriter.visitTypeArguments(typeArguments);
    }

    @Override
    public boolean requiresMethodProcessing() {
        return this.proxyBeanDefinitionWriter.requiresMethodProcessing();
    }

    @Override
    public String getProxiedTypeName() {
        return this.targetClassFullName;
    }

    @Override
    public String getProxiedBeanDefinitionName() {
        return this.parentWriter != null ? this.parentWriter.getBeanDefinitionName() : null;
    }

    public void visitInterceptorBinding(AnnotationValue<?> ... interceptorBinding) {
        if (interceptorBinding != null) {
            for (AnnotationValue<?> annotationValue : interceptorBinding) {
                annotationValue.stringValue().ifPresent(annName -> this.interceptorBinding.put((String)annName, annotationValue));
            }
        }
    }

    private Map<String, AnnotationValue<?>> toInterceptorBindingMap(AnnotationValue<?>[] interceptorBinding) {
        LinkedHashMap binding = new LinkedHashMap(interceptorBinding.length);
        for (AnnotationValue<?> annotationValue : interceptorBinding) {
            annotationValue.stringValue().ifPresent(annName -> binding.put((String)annName, annotationValue));
        }
        return binding;
    }

    private void readUnlock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_READ_LOCK, Method.getMethod("void unlock()"));
    }

    private void readLock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_READ_LOCK, Method.getMethod("void lock()"));
    }

    private void writeUnlock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_WRITE_LOCK, Method.getMethod("void unlock()"));
    }

    private void writeLock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_WRITE_LOCK, Method.getMethod("void lock()"));
    }

    private void invokeMethodOnLock(GeneratorAdapter interceptedTargetVisitor, String field, Method method) {
        interceptedTargetVisitor.loadThis();
        interceptedTargetVisitor.getField(this.proxyType, field, TYPE_LOCK);
        interceptedTargetVisitor.invokeInterface(TYPE_LOCK, method);
    }

    private Method writeResolveTargetMethod(ClassWriter proxyClassWriter, Type targetType) {
        Method resolveTargetMethodDesc = Method.getMethod(this.targetClassFullName + " " + METHOD_RESOLVE_TARGET + "()");
        GeneratorAdapter resolveTargetMethod = new GeneratorAdapter(proxyClassWriter.visitMethod(2, resolveTargetMethodDesc.getName(), resolveTargetMethodDesc.getDescriptor(), null, null), 2, METHOD_RESOLVE_TARGET, resolveTargetMethodDesc.getDescriptor());
        resolveTargetMethod.loadThis();
        resolveTargetMethod.getField(this.proxyType, FIELD_BEAN_LOCATOR, TYPE_BEAN_LOCATOR);
        resolveTargetMethod.push(targetType);
        resolveTargetMethod.loadThis();
        resolveTargetMethod.getField(this.proxyType, FIELD_BEAN_QUALIFIER, Type.getType(Qualifier.class));
        resolveTargetMethod.invokeInterface(TYPE_BEAN_LOCATOR, METHOD_GET_PROXY_TARGET_BEAN);
        AopProxyWriter.pushCastToType((MethodVisitor)resolveTargetMethod, AopProxyWriter.getTypeReferenceForName(this.targetClassFullName, new String[0]));
        resolveTargetMethod.returnValue();
        resolveTargetMethod.visitMaxs(1, 1);
        return resolveTargetMethodDesc;
    }

    private void writeWithQualifierMethod(ClassWriter proxyClassWriter) {
        GeneratorAdapter withQualifierMethod = this.startPublicMethod(proxyClassWriter, "$withBeanQualifier", Void.TYPE.getName(), Qualifier.class.getName());
        withQualifierMethod.loadThis();
        withQualifierMethod.loadArg(0);
        withQualifierMethod.putField(this.proxyType, FIELD_BEAN_QUALIFIER, Type.getType(Qualifier.class));
        withQualifierMethod.visitInsn(177);
        withQualifierMethod.visitEnd();
        withQualifierMethod.visitMaxs(1, 1);
    }

    private void writeSwapMethod(ClassWriter proxyClassWriter, Type targetType) {
        GeneratorAdapter swapGenerator = this.startPublicMethod(proxyClassWriter, "swap", targetType.getClassName(), targetType.getClassName());
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        swapGenerator.visitTryCatchBlock(l0, l1, l2, null);
        this.writeLock(swapGenerator);
        swapGenerator.visitLabel(l0);
        swapGenerator.loadThis();
        swapGenerator.getField(this.proxyType, FIELD_TARGET, targetType);
        int localRef = swapGenerator.newLocal(targetType);
        swapGenerator.storeLocal(localRef);
        swapGenerator.loadThis();
        swapGenerator.visitVarInsn(25, 1);
        swapGenerator.putField(this.proxyType, FIELD_TARGET, targetType);
        swapGenerator.visitLabel(l1);
        this.writeUnlock(swapGenerator);
        swapGenerator.loadLocal(localRef);
        swapGenerator.returnValue();
        swapGenerator.visitLabel(l2);
        int var = swapGenerator.newLocal(targetType);
        swapGenerator.storeLocal(var);
        this.writeUnlock(swapGenerator);
        swapGenerator.loadLocal(var);
        swapGenerator.throwException();
        swapGenerator.visitMaxs(2, 3);
        swapGenerator.visitEnd();
    }

    private void writeInterceptedTargetMethod(ClassWriter proxyClassWriter, Type targetType, Method resolveTargetMethodDesc) {
        GeneratorAdapter interceptedTargetVisitor = this.startPublicMethod(proxyClassWriter, "interceptedTarget", Object.class.getName(), new String[0]);
        if (this.lazy) {
            interceptedTargetVisitor.loadThis();
            interceptedTargetVisitor.invokeVirtual(this.proxyType, resolveTargetMethodDesc);
            interceptedTargetVisitor.returnValue();
        } else {
            int localRef = -1;
            Label l1 = null;
            Label l2 = null;
            if (this.hotswap) {
                Label l0 = new Label();
                l1 = new Label();
                l2 = new Label();
                interceptedTargetVisitor.visitTryCatchBlock(l0, l1, l2, null);
                this.readLock(interceptedTargetVisitor);
                interceptedTargetVisitor.visitLabel(l0);
            }
            interceptedTargetVisitor.loadThis();
            interceptedTargetVisitor.getField(this.proxyType, FIELD_TARGET, targetType);
            if (this.hotswap) {
                localRef = interceptedTargetVisitor.newLocal(targetType);
                interceptedTargetVisitor.storeLocal(localRef);
                interceptedTargetVisitor.visitLabel(l1);
                this.readUnlock(interceptedTargetVisitor);
                interceptedTargetVisitor.loadLocal(localRef);
            }
            interceptedTargetVisitor.returnValue();
            if (localRef > -1) {
                interceptedTargetVisitor.visitLabel(l2);
                int var = interceptedTargetVisitor.newLocal(targetType);
                interceptedTargetVisitor.storeLocal(var);
                this.readUnlock(interceptedTargetVisitor);
                interceptedTargetVisitor.loadLocal(var);
                interceptedTargetVisitor.throwException();
            }
        }
        interceptedTargetVisitor.visitMaxs(1, 2);
        interceptedTargetVisitor.visitEnd();
    }

    private void pushResolveInterceptorsCall(GeneratorAdapter proxyConstructorGenerator, int i, boolean isIntroduction) {
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.getField(this.proxyType, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS);
        proxyConstructorGenerator.push(i);
        proxyConstructorGenerator.loadArg(this.beanContextArgumentIndex);
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
        proxyConstructorGenerator.push(i);
        proxyConstructorGenerator.visitInsn(50);
        proxyConstructorGenerator.loadArg(this.interceptorArgumentIndex);
        if (isIntroduction) {
            proxyConstructorGenerator.invokeStatic(TYPE_INTERCEPTOR_CHAIN, Method.getMethod(RESOLVE_INTRODUCTION_INTERCEPTORS_METHOD));
        } else {
            proxyConstructorGenerator.invokeStatic(TYPE_INTERCEPTOR_CHAIN, Method.getMethod(RESOLVE_AROUND_INTERCEPTORS_METHOD));
        }
        proxyConstructorGenerator.visitInsn(83);
    }

    private void processAlreadyVisitedMethods(BeanDefinitionWriter parent) {
        List<BeanDefinitionWriter.MethodVisitData> postConstructMethodVisits = parent.getPostConstructMethodVisits();
        for (BeanDefinitionWriter.MethodVisitData methodVisit : postConstructMethodVisits) {
            this.visitPostConstructMethod(methodVisit.getBeanType(), methodVisit.getMethodElement(), methodVisit.isRequiresReflection());
        }
        List<BeanDefinitionWriter.MethodVisitData> preDestroyMethodVisits = parent.getPreDestroyMethodVisits();
        for (BeanDefinitionWriter.MethodVisitData methodVisit : preDestroyMethodVisits) {
            this.visitPreDestroyMethod(methodVisit.getBeanType(), methodVisit.getMethodElement(), methodVisit.isRequiresReflection());
        }
    }

    private static final class MethodRef {
        protected final String name;
        protected final List<ClassElement> argumentTypes;
        protected final Type returnType;
        private final List<String> rawTypes;

        public MethodRef(String name, List<ParameterElement> argumentTypes, Type returnType) {
            this.name = name;
            this.argumentTypes = argumentTypes.stream().map(ParameterElement::getType).collect(Collectors.toList());
            this.rawTypes = this.argumentTypes.stream().map(Element::getName).collect(Collectors.toList());
            this.returnType = returnType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodRef methodRef = (MethodRef)o;
            return Objects.equals(this.name, methodRef.name) && Objects.equals(this.rawTypes, methodRef.rawTypes) && Objects.equals(this.returnType, methodRef.returnType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.rawTypes, this.returnType);
        }
    }
}

