/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.context.scope.CustomScopeRegistry;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Internal
class DefaultCustomScopeRegistry
implements CustomScopeRegistry {
    private final BeanLocator beanLocator;
    private final Map<String, Optional<CustomScope>> scopes = new ConcurrentHashMap<String, Optional<CustomScope>>(2);
    private final ClassLoader classLoader;

    DefaultCustomScopeRegistry(BeanLocator beanLocator, ClassLoader classLoader) {
        this.beanLocator = beanLocator;
        this.classLoader = classLoader;
    }

    @Override
    public Optional<CustomScope> findScope(Class<? extends Annotation> scopeAnnotation) {
        return this.scopes.computeIfAbsent(scopeAnnotation.getName(), s -> {
            Qualifier qualifier = Qualifiers.byTypeArguments(scopeAnnotation);
            return this.beanLocator.findBean(CustomScope.class, qualifier);
        });
    }

    @Override
    public Optional<CustomScope> findScope(String scopeAnnotation) {
        return this.scopes.computeIfAbsent(scopeAnnotation, type -> {
            Optional<Class> scopeClass = ClassUtils.forName(type, this.classLoader);
            if (scopeClass.isPresent()) {
                Qualifier qualifier = Qualifiers.byTypeArguments(scopeClass.get());
                return this.beanLocator.findBean(CustomScope.class, qualifier);
            }
            return Optional.empty();
        });
    }
}

