/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.Qualifier;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public interface ExecutionHandleLocator {
    public static final ExecutionHandleLocator EMPTY = new ExecutionHandleLocator(){};

    default public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, String method, Class ... arguments) {
        return Optional.empty();
    }

    default public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, Qualifier<?> qualifier, String method, Class ... arguments) {
        return Optional.empty();
    }

    default public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(T bean, String method, Class ... arguments) {
        return Optional.empty();
    }

    default public <T, R> Optional<ExecutableMethod<T, R>> findExecutableMethod(Class<T> beanType, String method, Class ... arguments) {
        return Optional.empty();
    }

    default public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(Class<T> beanType, String method, Class ... arguments) {
        return Optional.empty();
    }

    default public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(Class<T> beanType, Qualifier<T> qualifier, String method, Class ... arguments) {
        return Optional.empty();
    }

    default public <T, R> ExecutableMethod<T, R> getExecutableMethod(Class<T> beanType, String method, Class ... arguments) throws NoSuchMethodException {
        Optional<ExecutableMethod<T, R>> executableMethod = this.findExecutableMethod(beanType, method, arguments);
        return executableMethod.orElseThrow(() -> new NoSuchMethodException("No such method [" + method + "(" + Arrays.stream(arguments).map(Class::getName).collect(Collectors.joining(",")) + ") ] for bean [" + beanType.getName() + "]"));
    }

    default public <T, R> ExecutableMethod<T, R> getProxyTargetMethod(Class<T> beanType, String method, Class ... arguments) throws NoSuchMethodException {
        Optional<ExecutableMethod<T, R>> executableMethod = this.findProxyTargetMethod(beanType, method, arguments);
        return executableMethod.orElseThrow(() -> new NoSuchMethodException("No such method [" + method + "(" + Arrays.stream(arguments).map(Class::getName).collect(Collectors.joining(",")) + ") ] for bean [" + beanType.getName() + "]"));
    }

    default public <T, R> ExecutableMethod<T, R> getProxyTargetMethod(Class<T> beanType, Qualifier<T> qualifier, String method, Class ... arguments) throws NoSuchMethodException {
        Optional<ExecutableMethod<T, R>> executableMethod = this.findProxyTargetMethod(beanType, qualifier, method, arguments);
        return executableMethod.orElseThrow(() -> new NoSuchMethodException("No such method [" + method + "(" + Arrays.stream(arguments).map(Class::getName).collect(Collectors.joining(",")) + ") ] for bean [" + beanType.getName() + "]"));
    }

    default public <T, R> MethodExecutionHandle<T, R> getExecutionHandle(Class<T> beanType, String method, Class ... arguments) throws NoSuchMethodException {
        return this.findExecutionHandle((T)beanType, method, arguments).orElseThrow(() -> new NoSuchMethodException("No such method [" + method + "(" + Arrays.stream(arguments).map(Class::getName).collect(Collectors.joining(",")) + ") ] for bean [" + beanType.getName() + "]"));
    }

    default public <T, R> MethodExecutionHandle<T, R> getExecutionHandle(T bean, String method, Class ... arguments) throws NoSuchMethodException {
        return this.findExecutionHandle(bean, method, arguments).orElseThrow(() -> new NoSuchMethodException("No such method [" + method + "(" + Arrays.stream(arguments).map(Class::getName).collect(Collectors.joining(",")) + ") ] for bean [" + bean + "]"));
    }

    default public MethodExecutionHandle<?, Object> createExecutionHandle(BeanDefinition<?> beanDefinition, ExecutableMethod<Object, ?> method) {
        throw new UnsupportedOperationException("No such method [" + method + "(" + Arrays.stream(method.getArgumentTypes()).map(Class::getName).collect(Collectors.joining(",")) + ") ] for bean [" + beanDefinition.getBeanType() + "]");
    }
}

