/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.env.EnvironmentPropertySource;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.context.env.PropertySource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class KubernetesEnvironmentPropertySource
extends MapPropertySource {
    public static final String NAME = "k8s-env";
    static final List<String> VAR_SUFFIXES = Arrays.asList("_TCP", "_TCP_PORT", "_TCP_PROTO", "_TCP_ADDR", "_UDP_PORT", "_UDP_PROTO", "_UDP_ADDR", "_SERVICE_PORT", "_SERVICE_PORT_HTTP", "_SERVICE_HOST");

    public KubernetesEnvironmentPropertySource() {
        super(NAME, EnvironmentPropertySource.getEnv(KubernetesEnvironmentPropertySource.getEnvNoK8s(), null, null));
    }

    public KubernetesEnvironmentPropertySource(@Nullable List<String> includes, @Nullable List<String> excludes) {
        super(NAME, EnvironmentPropertySource.getEnv(KubernetesEnvironmentPropertySource.getEnvNoK8s(), includes, excludes));
    }

    @Override
    public int getOrder() {
        return -200;
    }

    @Override
    public PropertySource.PropertyConvention getConvention() {
        return PropertySource.PropertyConvention.ENVIRONMENT_VARIABLE;
    }

    static Map<String, String> getEnvNoK8s() {
        HashMap<String, String> props = new HashMap<String, String>(System.getenv());
        props.entrySet().removeIf(entry -> VAR_SUFFIXES.stream().anyMatch(s -> ((String)entry.getKey()).endsWith((String)s)));
        props.entrySet().removeIf(entry -> ((String)entry.getKey()).endsWith("_PORT") && ((String)entry.getValue()).startsWith("tcp://"));
        return props;
    }
}

