/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env.yaml;

import io.micronaut.context.env.AbstractPropertySourceLoader;
import io.micronaut.context.env.yaml.CustomSafeConstructor;
import io.micronaut.core.util.CollectionUtils;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YamlPropertySourceLoader
extends AbstractPropertySourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(YamlPropertySourceLoader.class);

    @Override
    public boolean isEnabled() {
        return YamlPropertySourceLoader.isSnakeYamlPresent();
    }

    @Override
    public Set<String> getExtensions() {
        return CollectionUtils.setOf("yml", "yaml");
    }

    @Override
    protected void processInput(String name, InputStream input, Map<String, Object> finalMap) {
        Yaml yaml;
        Iterable<Object> objects;
        Iterator<Object> i;
        if (System.getProperty("java.runtime.name") == null) {
            System.setProperty("java.runtime.name", "Unknown");
        }
        if ((i = (objects = (yaml = new Yaml(new CustomSafeConstructor())).loadAll(input)).iterator()).hasNext()) {
            while (i.hasNext()) {
                Object object = i.next();
                if (!(object instanceof Map)) continue;
                Map map = (Map)object;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing YAML: {}", (Object)map);
                }
                String prefix = "";
                this.processMap(finalMap, map, prefix);
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("PropertySource [{}] produced no YAML content", (Object)name);
        }
    }

    private static boolean isSnakeYamlPresent() {
        try {
            Class<Yaml> yamlClass = Yaml.class;
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

