/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.async.subscriber;

import io.micronaut.core.async.subscriber.Emitter;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class CompletionAwareSubscriber<T>
implements Subscriber<T>,
Emitter<T> {
    protected Subscription subscription;
    private final AtomicBoolean complete = new AtomicBoolean(false);

    @Override
    public final void onSubscribe(Subscription s) {
        this.subscription = s;
        this.doOnSubscribe(this.subscription);
    }

    public boolean isComplete() {
        return this.complete.get();
    }

    @Override
    public final void onNext(T t) {
        if (!this.complete.get()) {
            try {
                this.doOnNext(t);
            }
            catch (Throwable e) {
                this.onError(e);
            }
        }
    }

    @Override
    public final void onError(Throwable t) {
        if (this.subscription != null && this.complete.compareAndSet(false, true)) {
            this.subscription.cancel();
            this.doOnError(t);
        }
    }

    @Override
    public final void onComplete() {
        if (this.complete.compareAndSet(false, true)) {
            try {
                this.doOnComplete();
            }
            catch (Exception e) {
                this.doOnError(e);
            }
        }
    }

    protected abstract void doOnSubscribe(Subscription var1);

    protected abstract void doOnNext(T var1);

    protected abstract void doOnError(Throwable var1);

    protected abstract void doOnComplete();
}

