/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.exceptions.NoAvailableServiceException;
import io.micronaut.http.client.loadbalance.FixedLoadBalancer;
import java.net.URL;
import java.util.Optional;
import org.reactivestreams.Publisher;

@FunctionalInterface
public interface LoadBalancer {
    public Publisher<ServiceInstance> select(@Nullable Object var1);

    default public Optional<String> getContextPath() {
        return Optional.empty();
    }

    default public Publisher<ServiceInstance> select() {
        return this.select(null);
    }

    public static LoadBalancer fixed(URL url) {
        return new FixedLoadBalancer(url);
    }

    public static LoadBalancer empty() {
        return discriminator -> Publishers.just(new NoAvailableServiceException("Load balancer contains no servers"));
    }
}

