/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import org.reactivestreams.Publisher;

public abstract class OncePerRequestHttpServerFilter
implements HttpServerFilter {
    @Override
    public final Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        String attributeKey = OncePerRequestHttpServerFilter.getKey(this.getClass());
        ConvertibleValues attrs = request.getAttributes();
        if (attrs.contains(attributeKey)) {
            return chain.proceed(request);
        }
        attrs.put(attributeKey, true);
        return this.doFilterOnce(request, chain);
    }

    public static String getKey(Class<? extends OncePerRequestHttpServerFilter> filterClass) {
        return "micronaut.once." + filterClass.getSimpleName();
    }

    protected abstract Publisher<MutableHttpResponse<?>> doFilterOnce(HttpRequest<?> var1, ServerFilterChain var2);
}

