/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.graal;

import com.oracle.svm.core.annotate.AutomaticFeature;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.graal.AutomaticFeatureUtils;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

@Internal
@AutomaticFeature
public class HttpNettyFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{"io.netty.channel.epoll", "io.netty.channel.kqueue", "io.netty.channel.unix"});
        this.registerClasses(access, "io.netty.channel.kqueue.KQueueChannelOption", "io.netty.channel.epoll.EpollChannelOption");
    }

    private void registerClasses(Feature.BeforeAnalysisAccess access, String ... classes) {
        for (String clazz : classes) {
            AutomaticFeatureUtils.registerClassForRuntimeReflection(access, clazz);
            AutomaticFeatureUtils.registerFieldsForRuntimeReflection(access, clazz);
        }
    }
}

