/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.core.bind.exceptions.UnsatisfiedArgumentException;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Produces
public class UnsatisfiedArgumentHandler
implements ExceptionHandler<UnsatisfiedArgumentException, HttpResponse> {
    private final ErrorResponseProcessor<?> responseProcessor;

    @Deprecated
    public UnsatisfiedArgumentHandler() {
        this.responseProcessor = null;
    }

    @Inject
    public UnsatisfiedArgumentHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    @Override
    public HttpResponse handle(HttpRequest request, final UnsatisfiedArgumentException exception) {
        MutableHttpResponse response = HttpResponse.badRequest();
        if (this.responseProcessor != null) {
            return this.responseProcessor.processResponse(ErrorContext.builder(request).cause(exception).error(new Error(){

                @Override
                public String getMessage() {
                    return exception.getMessage();
                }

                @Override
                public Optional<String> getPath() {
                    return Optional.of('/' + exception.getArgument().getName());
                }
            }).build(), response);
        }
        return response.body(new JsonError(exception.getMessage()).path('/' + exception.getArgument().getName()).link(Link.SELF, Link.of(request.getUri())));
    }
}

