/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.env.Environment;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.async.SupplierUtil;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.core.naming.Named;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.discovery.EmbeddedServerInstance;
import io.micronaut.discovery.event.ServiceReadyEvent;
import io.micronaut.discovery.event.ServiceStoppedEvent;
import io.micronaut.http.HttpRequestFactory;
import io.micronaut.http.HttpResponseFactory;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.channel.ChannelPipelineCustomizer;
import io.micronaut.http.netty.channel.ChannelPipelineListener;
import io.micronaut.http.netty.channel.DefaultEventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.EventLoopGroupRegistry;
import io.micronaut.http.netty.channel.converters.ChannelOptionFactory;
import io.micronaut.http.netty.stream.HttpStreamsServerHandler;
import io.micronaut.http.netty.stream.StreamingInboundHttp2ToHttpAdapter;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.http.server.netty.HttpCompressionStrategy;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.HttpToHttpsRedirectHandler;
import io.micronaut.http.server.netty.NettyEmbeddedServerInstance;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.SmartHttpContentCompressor;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.decoders.HttpRequestDecoder;
import io.micronaut.http.server.netty.encoders.HttpResponseEncoder;
import io.micronaut.http.server.netty.handler.accesslog.HttpAccessLogHandler;
import io.micronaut.http.server.netty.ssl.HttpRequestCertificateHandler;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import io.micronaut.http.server.netty.websocket.NettyServerWebSocketUpgradeHandler;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.event.ServerShutdownEvent;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
@TypeHint(value={ChannelOption.class}, accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_DECLARED_FIELDS})
public class NettyHttpServer
implements EmbeddedServer,
WebSocketSessionRepository,
ChannelPipelineCustomizer {
    public static final String OUTBOUND_KEY = "-outbound-";
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private final List<ChannelOutboundHandler> outboundHandlers;
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final NettyHttpServerConfiguration serverConfiguration;
    private final ServerSslConfiguration sslConfiguration;
    private final StaticResourceResolver staticResourceResolver;
    private final Environment environment;
    private final Router router;
    private final RequestArgumentSatisfier requestArgumentSatisfier;
    private final BeanLocator beanLocator;
    private final ThreadFactory threadFactory;
    private final WebSocketBeanRegistry webSocketBeanRegistry;
    private final int specifiedPort;
    private final HttpCompressionStrategy httpCompressionStrategy;
    private final EventLoopGroupRegistry eventLoopGroupRegistry;
    private final HttpVersion httpVersion;
    private final HttpRequestCertificateHandler requestCertificateHandler;
    private final RoutingInBoundHandler routingHandler;
    private volatile int serverPort;
    private final ApplicationContext applicationContext;
    private final SslContext sslContext;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ChannelGroup webSocketSessions = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
    private final EventLoopGroupFactory eventLoopGroupFactory;
    private final ChannelOptionFactory channelOptionFactory;
    private final HttpHostResolver hostResolver;
    private boolean shutdownWorker = false;
    private boolean shutdownParent = false;
    private EventLoopGroup workerGroup;
    private EventLoopGroup parentGroup;
    private EmbeddedServerInstance serviceInstance;
    private final Collection<ChannelPipelineListener> pipelineListeners = new ArrayList<ChannelPipelineListener>(2);

    public NettyHttpServer(NettyHttpServerConfiguration serverConfiguration, ApplicationContext applicationContext, Router router, RequestArgumentSatisfier requestArgumentSatisfier, MediaTypeCodecRegistry mediaTypeCodecRegistry, NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry, StaticResourceResolver resourceResolver, @javax.inject.Named(value="io") BeanProvider<ExecutorService> ioExecutor, @javax.inject.Named(value="netty") ThreadFactory threadFactory, ExecutorSelector executorSelector, @Nullable ServerSslBuilder serverSslBuilder, List<ChannelOutboundHandler> outboundHandlers, EventLoopGroupFactory eventLoopGroupFactory, EventLoopGroupRegistry eventLoopGroupRegistry, HttpCompressionStrategy httpCompressionStrategy, HttpContentProcessorResolver httpContentProcessorResolver, ChannelOptionFactory channelOptionFactory, ErrorResponseProcessor<?> errorResponseProcessor, HttpHostResolver hostResolver) {
        this.httpCompressionStrategy = httpCompressionStrategy;
        Optional<File> location = serverConfiguration.getMultipart().getLocation();
        location.ifPresent(dir -> {
            DiskFileUpload.baseDirectory = dir.getAbsolutePath();
        });
        this.applicationContext = applicationContext;
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.beanLocator = applicationContext;
        this.environment = applicationContext.getEnvironment();
        this.serverConfiguration = serverConfiguration;
        this.router = router;
        int port = this.specifiedPort = this.getHttpPort(serverConfiguration);
        if (serverSslBuilder != null) {
            this.sslConfiguration = serverSslBuilder.getSslConfiguration();
            this.sslContext = serverSslBuilder.build().orElse(null);
            if (this.sslConfiguration.isEnabled()) {
                port = this.sslConfiguration.getPort();
            }
        } else {
            this.sslConfiguration = null;
            this.sslContext = null;
        }
        this.httpVersion = serverConfiguration.getHttpVersion();
        this.serverPort = this.getPortOrDefault(port);
        OrderUtil.sort(outboundHandlers);
        this.outboundHandlers = outboundHandlers;
        this.requestArgumentSatisfier = requestArgumentSatisfier;
        this.staticResourceResolver = resourceResolver;
        this.threadFactory = threadFactory;
        this.webSocketBeanRegistry = WebSocketBeanRegistry.forServer(applicationContext);
        this.eventLoopGroupFactory = eventLoopGroupFactory;
        this.eventLoopGroupRegistry = eventLoopGroupRegistry;
        this.requestCertificateHandler = new HttpRequestCertificateHandler();
        this.routingHandler = new RoutingInBoundHandler(applicationContext, router, mediaTypeCodecRegistry, customizableResponseTypeHandlerRegistry, this.staticResourceResolver, serverConfiguration, requestArgumentSatisfier, executorSelector, SupplierUtil.memoized(ioExecutor::get), httpContentProcessorResolver, errorResponseProcessor);
        this.channelOptionFactory = channelOptionFactory;
        this.hostResolver = hostResolver;
    }

    private int getPortOrDefault(int port) {
        return port == -1 ? SocketUtils.findAvailableTcpPort() : port;
    }

    private int getHttpPort(NettyHttpServerConfiguration serverConfiguration) {
        Integer configPort = serverConfiguration.getPort().orElse(null);
        return this.getHttpPort(configPort);
    }

    private int getHttpPort(Integer configPort) {
        if (configPort != null) {
            return configPort;
        }
        if (this.environment.getActiveNames().contains("test")) {
            return -1;
        }
        return 8080;
    }

    @Override
    public boolean isKeepAlive() {
        return false;
    }

    public NettyHttpServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public synchronized EmbeddedServer start() {
        if (!this.isRunning()) {
            Set<Integer> exposedPorts;
            HttpRequestFactory requestFactory = HttpRequestFactory.INSTANCE;
            HttpResponseFactory responseFactory = HttpResponseFactory.INSTANCE;
            EventLoopGroupConfiguration workerConfig = this.resolveWorkerConfiguration();
            this.workerGroup = this.createWorkerEventLoopGroup(workerConfig);
            this.parentGroup = this.createParentEventLoopGroup();
            ServerBootstrap serverBootstrap = this.createServerBootstrap();
            serverBootstrap.channelFactory(() -> this.eventLoopGroupFactory.serverSocketChannelInstance(workerConfig));
            this.processOptions(this.serverConfiguration.getOptions(), serverBootstrap::option);
            this.processOptions(this.serverConfiguration.getChildOptions(), serverBootstrap::childOption);
            serverBootstrap = serverBootstrap.group(this.parentGroup, this.workerGroup).childHandler(new NettyHttpServerInitializer());
            Optional<String> host = this.serverConfiguration.getHost();
            this.serverPort = this.bindServerToHost(serverBootstrap, host.orElse(null), this.serverPort, new AtomicInteger(0));
            ArrayList<Integer> defaultPorts = new ArrayList<Integer>(2);
            defaultPorts.add(this.serverPort);
            if (this.serverConfiguration.isDualProtocol()) {
                int httpPort = this.getPortOrDefault(this.getHttpPort(this.serverConfiguration));
                defaultPorts.add(httpPort);
                this.bindServerToHost(serverBootstrap, host.orElse(null), httpPort, new AtomicInteger(0));
            }
            if (CollectionUtils.isNotEmpty(exposedPorts = this.router.getExposedPorts())) {
                this.router.applyDefaultPorts(defaultPorts);
                for (Integer exposedPort : exposedPorts) {
                    try {
                        if (host.isPresent()) {
                            serverBootstrap.bind(host.get(), (int)exposedPort).sync();
                            continue;
                        }
                        serverBootstrap.bind(exposedPort).sync();
                    }
                    catch (Throwable e) {
                        boolean isBindError = e instanceof BindException;
                        if (LOG.isErrorEnabled()) {
                            if (isBindError) {
                                LOG.error("Unable to start server. Additional specified server port {} already in use.", (Object)exposedPort);
                            } else {
                                LOG.error("Error starting Micronaut server: " + e.getMessage(), e);
                            }
                        }
                        throw new ServerStartupException("Unable to start Micronaut server on port: " + this.serverPort, e);
                    }
                }
            }
            this.fireStartupEvents();
            this.running.set(true);
        }
        return this;
    }

    private EventLoopGroupConfiguration resolveWorkerConfiguration() {
        EventLoopGroupConfiguration workerConfig = this.serverConfiguration.getWorker();
        if (workerConfig == null) {
            workerConfig = this.eventLoopGroupRegistry.getEventLoopGroupConfiguration("default").orElse(null);
        } else {
            String eventLoopGroupName = workerConfig.getName();
            if (!"default".equals(eventLoopGroupName)) {
                workerConfig = this.eventLoopGroupRegistry.getEventLoopGroupConfiguration(eventLoopGroupName).orElse(workerConfig);
            }
        }
        return workerConfig;
    }

    @Override
    public synchronized EmbeddedServer stop() {
        if (this.isRunning() && this.workerGroup != null && this.running.compareAndSet(true, false)) {
            this.stopInternal();
        }
        return this;
    }

    @Override
    public int getPort() {
        return this.serverPort;
    }

    @Override
    public String getHost() {
        return this.serverConfiguration.getHost().orElseGet(() -> Optional.ofNullable(System.getenv("HOSTNAME")).orElse("localhost"));
    }

    @Override
    public String getScheme() {
        return this.sslConfiguration != null && this.sslConfiguration.isEnabled() ? "https" : "http";
    }

    @Override
    public URL getURL() {
        try {
            return new URL(this.getScheme() + "://" + this.getHost() + ':' + this.getPort());
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), e);
        }
    }

    @Override
    public URI getURI() {
        try {
            return new URI(this.getScheme() + "://" + this.getHost() + ':' + this.getPort());
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), e);
        }
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public ApplicationConfiguration getApplicationConfiguration() {
        return this.serverConfiguration.getApplicationConfiguration();
    }

    protected EventLoopGroup createParentEventLoopGroup() {
        NettyHttpServerConfiguration.Parent parent = this.serverConfiguration.getParent();
        return this.eventLoopGroupRegistry.getEventLoopGroup(parent != null ? parent.getName() : "parent").orElseGet(() -> {
            EventLoopGroup newGroup = this.newEventLoopGroup(parent);
            this.shutdownParent = true;
            return newGroup;
        });
    }

    protected EventLoopGroup createWorkerEventLoopGroup(@Nullable EventLoopGroupConfiguration workerConfig) {
        String configName = workerConfig != null ? workerConfig.getName() : "default";
        return this.eventLoopGroupRegistry.getEventLoopGroup(configName).orElseGet(() -> {
            LOG.warn("The configuration for 'micronaut.server.netty.worker.{}' is deprecated. Use 'micronaut.netty.event-loops.default' configuration instead.", (Object)configName);
            EventLoopGroup newGroup = this.newEventLoopGroup(workerConfig);
            this.shutdownWorker = true;
            return newGroup;
        });
    }

    protected ServerBootstrap createServerBootstrap() {
        return new ServerBootstrap();
    }

    private int bindServerToHost(ServerBootstrap serverBootstrap, @Nullable String host, int port, AtomicInteger attempts) {
        boolean isRandomPort = this.specifiedPort == -1;
        Optional<String> applicationName = this.serverConfiguration.getApplicationConfiguration().getName();
        if (applicationName.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Binding {} server to {}:{}", applicationName.get(), host != null ? host : "*", port);
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Binding server to {}:{}", (Object)(host != null ? host : "*"), (Object)port);
        }
        try {
            if (host != null) {
                serverBootstrap.bind(host, port).sync();
            } else {
                serverBootstrap.bind(port).sync();
            }
            return port;
        }
        catch (Throwable e) {
            boolean isBindError = e instanceof BindException;
            if (LOG.isErrorEnabled()) {
                if (isBindError) {
                    LOG.error("Unable to start server. Port already {} in use.", (Object)port);
                } else {
                    LOG.error("Error starting Micronaut server: " + e.getMessage(), e);
                }
            }
            int attemptCount = attempts.getAndIncrement();
            if (isRandomPort && attemptCount < 3) {
                port = SocketUtils.findAvailableTcpPort();
                return this.bindServerToHost(serverBootstrap, host, port, attempts);
            }
            this.stopInternal();
            throw new ServerStartupException("Unable to start Micronaut server on port: " + port, e);
        }
    }

    private void fireStartupEvents() {
        Optional<String> applicationName = this.serverConfiguration.getApplicationConfiguration().getName();
        this.applicationContext.publishEvent(new ServerStartupEvent(this));
        applicationName.ifPresent(id -> {
            this.serviceInstance = this.applicationContext.createBean(NettyEmbeddedServerInstance.class, id, this);
            this.applicationContext.publishEvent(new ServiceReadyEvent(this.serviceInstance));
        });
    }

    private void logShutdownErrorIfNecessary(Future<?> future) {
        if (!future.isSuccess() && LOG.isWarnEnabled()) {
            Throwable e = future.cause();
            LOG.warn("Error stopping Micronaut server: " + e.getMessage(), e);
        }
    }

    private void stopInternal() {
        block8: {
            try {
                if (this.shutdownParent) {
                    NettyHttpServerConfiguration.Parent parent = this.serverConfiguration.getParent();
                    if (parent != null) {
                        long quietPeriod = parent.getShutdownQuietPeriod().toMillis();
                        long timeout = parent.getShutdownTimeout().toMillis();
                        this.parentGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS).addListener(this::logShutdownErrorIfNecessary);
                    } else {
                        this.parentGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary);
                    }
                }
                if (this.shutdownWorker) {
                    this.workerGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary);
                }
                this.webSocketSessions.close();
                this.applicationContext.publishEvent(new ServerShutdownEvent(this));
                if (this.serviceInstance != null) {
                    this.applicationContext.publishEvent(new ServiceStoppedEvent(this.serviceInstance));
                }
                if (this.applicationContext.isRunning()) {
                    this.applicationContext.stop();
                }
                this.serverConfiguration.getMultipart().getLocation().ifPresent(dir -> {
                    DiskFileUpload.baseDirectory = null;
                });
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error("Error stopping Micronaut server: " + e.getMessage(), e);
            }
        }
    }

    private EventLoopGroup newEventLoopGroup(EventLoopGroupConfiguration config) {
        if (config != null) {
            ExecutorService executorService = config.getExecutorName().flatMap(name -> this.beanLocator.findBean(ExecutorService.class, Qualifiers.byName(name))).orElse(null);
            if (executorService != null) {
                return this.eventLoopGroupFactory.createEventLoopGroup(config.getNumThreads(), executorService, (Integer)config.getIoRatio().orElse(null));
            }
            return this.eventLoopGroupFactory.createEventLoopGroup(config, this.threadFactory);
        }
        return this.eventLoopGroupFactory.createEventLoopGroup(new DefaultEventLoopGroupConfiguration(), this.threadFactory);
    }

    private void processOptions(Map<ChannelOption, Object> options, BiConsumer<ChannelOption, Object> biConsumer) {
        options.forEach((option, value) -> biConsumer.accept((ChannelOption)option, this.channelOptionFactory.convertValue((ChannelOption<?>)option, value, this.environment)));
    }

    @Override
    public void addChannel(Channel channel) {
        this.webSocketSessions.add(channel);
    }

    @Override
    public void removeChannel(Channel channel) {
        this.webSocketSessions.remove(channel);
    }

    @Override
    public ChannelGroup getChannelGroup() {
        return this.webSocketSessions;
    }

    public WebSocketSessionRepository getWebSocketSessionRepository() {
        return this;
    }

    private HttpToHttp2ConnectionHandler newHttpToHttp2ConnectionHandler() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        StreamingInboundHttp2ToHttpAdapter http2ToHttpAdapter = new StreamingInboundHttp2ToHttpAdapter(connection, (int)this.serverConfiguration.getMaxRequestSize(), this.serverConfiguration.isValidateHeaders(), true);
        HttpToHttp2ConnectionHandlerBuilder builder = new HttpToHttp2ConnectionHandlerBuilder().frameListener(http2ToHttpAdapter).validateHeaders(this.serverConfiguration.isValidateHeaders()).initialSettings(this.serverConfiguration.getHttp2().http2Settings());
        this.serverConfiguration.getLogLevel().ifPresent(logLevel -> builder.frameLogger(new Http2FrameLogger((LogLevel)((Object)logLevel), NettyHttpServer.class)));
        return builder.connection(connection).build();
    }

    @Override
    public boolean isClientChannel() {
        return false;
    }

    @Override
    public void doOnConnect(@NonNull ChannelPipelineListener listener) {
        this.pipelineListeners.add(Objects.requireNonNull(listener, "The listener cannot be null"));
    }

    private class NettyHttpServerInitializer
    extends ChannelInitializer<SocketChannel> {
        final Http2OrHttpHandler http2OrHttpHandler;
        final LoggingHandler loggingHandler;

        private NettyHttpServerInitializer() {
            this.http2OrHttpHandler = new Http2OrHttpHandler(NettyHttpServer.this.sslContext != null, NettyHttpServer.this.serverConfiguration.getFallbackProtocol());
            this.loggingHandler = NettyHttpServer.this.serverConfiguration.getLogLevel().isPresent() ? new LoggingHandler(NettyHttpServer.class, NettyHttpServer.this.serverConfiguration.getLogLevel().get()) : null;
        }

        @Override
        protected void initChannel(SocketChannel ch) {
            boolean ssl;
            ChannelPipeline pipeline = ch.pipeline();
            int port = ch.localAddress().getPort();
            boolean bl = ssl = NettyHttpServer.this.sslContext != null && NettyHttpServer.this.sslConfiguration != null && port == NettyHttpServer.this.serverPort;
            if (ssl) {
                pipeline.addLast(NettyHttpServer.this.sslContext.newHandler(ch.alloc()));
            }
            if (this.loggingHandler != null) {
                pipeline.addLast(this.loggingHandler);
            }
            if (NettyHttpServer.this.httpVersion != HttpVersion.HTTP_2_0) {
                this.http2OrHttpHandler.configurePipeline("http/1.1", pipeline);
            } else if (ssl) {
                pipeline.addLast(this.http2OrHttpHandler);
            } else {
                HttpToHttp2ConnectionHandler connectionHandler = NettyHttpServer.this.newHttpToHttp2ConnectionHandler();
                String fallbackHandlerName = "http1-fallback-handler";
                HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
                    if (AsciiString.contentEquals(Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, protocol)) {
                        return new Http2ServerUpgradeCodec("http2-connection", connectionHandler){

                            @Override
                            public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
                                ChannelPipeline p = ctx.pipeline();
                                p.remove("http1-fallback-handler");
                                NettyHttpServerInitializer.this.http2OrHttpHandler.getHandlerForProtocol(null).forEach(p::addLast);
                                for (ChannelPipelineListener pipelineListener : NettyHttpServer.this.pipelineListeners) {
                                    pipelineListener.onConnect(p);
                                }
                                super.upgradeTo(ctx, upgradeRequest);
                            }
                        };
                    }
                    return null;
                };
                HttpServerCodec sourceCodec = new HttpServerCodec();
                final HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler(sourceCodec, upgradeCodecFactory);
                CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, connectionHandler);
                pipeline.addLast(cleartextHttp2ServerUpgradeHandler);
                pipeline.addLast("http1-fallback-handler", (ChannelHandler)new SimpleChannelInboundHandler<HttpMessage>(){

                    @Override
                    protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) {
                        HttpRequest req;
                        if (msg instanceof HttpRequest && (req = (HttpRequest)msg).headers().contains(AbstractNettyHttpRequest.STREAM_ID)) {
                            ChannelPipeline pipeline = ctx.pipeline();
                            pipeline.remove(this);
                            pipeline.fireChannelRead(ReferenceCountUtil.retain(msg));
                            return;
                        }
                        ChannelPipeline pipeline = ctx.pipeline();
                        HttpServerCodec upgradeCodec = pipeline.get(HttpServerCodec.class);
                        pipeline.remove(upgradeCodec);
                        pipeline.remove(upgradeHandler);
                        pipeline.remove(this);
                        NettyHttpServerInitializer.this.http2OrHttpHandler.getHandlerForProtocol("http/1.1").forEach(pipeline::addLast);
                        for (ChannelPipelineListener pipelineListener : NettyHttpServer.this.pipelineListeners) {
                            pipelineListener.onConnect(pipeline);
                        }
                        pipeline.fireChannelRead(ReferenceCountUtil.retain(msg));
                    }
                });
            }
        }
    }

    @ChannelHandler.Sharable
    private final class Http2OrHttpHandler
    extends ApplicationProtocolNegotiationHandler {
        private final boolean useSsl;
        final HttpAccessLogHandler accessLogHandler;
        final HttpRequestDecoder requestDecoder;
        final HttpResponseEncoder responseDecoder;

        Http2OrHttpHandler(boolean useSsl, String fallbackProtocol) {
            super(fallbackProtocol);
            this.accessLogHandler = NettyHttpServer.this.serverConfiguration.getAccessLogger() != null && NettyHttpServer.this.serverConfiguration.getAccessLogger().isEnabled() ? new HttpAccessLogHandler(NettyHttpServer.this.serverConfiguration.getAccessLogger().getLoggerName(), NettyHttpServer.this.serverConfiguration.getAccessLogger().getLogFormat()) : null;
            this.requestDecoder = new HttpRequestDecoder(NettyHttpServer.this, NettyHttpServer.this.environment, NettyHttpServer.this.serverConfiguration);
            this.responseDecoder = new HttpResponseEncoder(NettyHttpServer.this.mediaTypeCodecRegistry, NettyHttpServer.this.serverConfiguration);
            this.useSsl = useSsl;
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            SslHandshakeCompletionEvent event;
            if (evt instanceof SslHandshakeCompletionEvent && !(event = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                Throwable cause = event.cause();
                if (!(cause instanceof ClosedChannelException)) {
                    super.userEventTriggered(ctx, evt);
                } else {
                    return;
                }
            }
            super.userEventTriggered(ctx, evt);
        }

        @Override
        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            ChannelPipeline pipeline = ctx.pipeline();
            this.configurePipeline(protocol, pipeline);
            ctx.read();
        }

        private void configurePipeline(String protocol, ChannelPipeline pipeline) {
            Map<String, ChannelHandler> handlers = this.getHandlerForProtocol(protocol);
            handlers.forEach(pipeline::addLast);
            for (ChannelPipelineListener pipelineListener : NettyHttpServer.this.pipelineListeners) {
                pipelineListener.onConnect(pipeline);
            }
        }

        private void registerMicronautChannelHandlers(Map<String, ChannelHandler> channelHandlerMap) {
            int i = 0;
            for (ChannelOutboundHandler outboundHandlerAdapter : NettyHttpServer.this.outboundHandlers) {
                String name = outboundHandlerAdapter instanceof Named ? ((Named)((Object)outboundHandlerAdapter)).getName() : "micronaut-inbound-handler-outbound-" + ++i;
                channelHandlerMap.put(name, outboundHandlerAdapter);
            }
        }

        @NotNull
        private Map<String, ChannelHandler> getHandlerForProtocol(@Nullable String protocol) {
            Duration idleTime = NettyHttpServer.this.serverConfiguration.getIdleTimeout();
            LinkedHashMap<String, ChannelHandler> handlers = new LinkedHashMap<String, ChannelHandler>(15);
            if (!idleTime.isNegative()) {
                handlers.put("idle-state", new IdleStateHandler((int)NettyHttpServer.this.serverConfiguration.getReadIdleTimeout().getSeconds(), (int)NettyHttpServer.this.serverConfiguration.getWriteIdleTimeout().getSeconds(), (int)idleTime.getSeconds()));
            }
            if (protocol == null) {
                handlers.put("flow-control-handler", new FlowControlHandler());
                if (this.accessLogHandler != null) {
                    handlers.put("http-access-logger", this.accessLogHandler);
                }
            } else if ("h2".equals(protocol)) {
                HttpToHttp2ConnectionHandler httpToHttp2ConnectionHandler = NettyHttpServer.this.newHttpToHttp2ConnectionHandler();
                handlers.put("http2-connection", httpToHttp2ConnectionHandler);
                this.registerMicronautChannelHandlers(handlers);
                handlers.put("flow-control-handler", new FlowControlHandler());
                if (this.accessLogHandler != null) {
                    handlers.put("http-access-logger", this.accessLogHandler);
                }
            } else {
                handlers.put("http-server-codec", new HttpServerCodec(NettyHttpServer.this.serverConfiguration.getMaxInitialLineLength(), NettyHttpServer.this.serverConfiguration.getMaxHeaderSize(), NettyHttpServer.this.serverConfiguration.getMaxChunkSize(), NettyHttpServer.this.serverConfiguration.isValidateHeaders(), NettyHttpServer.this.serverConfiguration.getInitialBufferSize()));
                if (this.accessLogHandler != null) {
                    handlers.put("http-access-logger", this.accessLogHandler);
                }
                this.registerMicronautChannelHandlers(handlers);
                handlers.put("flow-control-handler", new FlowControlHandler());
                handlers.put("http-keep-alive-handler", new HttpServerKeepAliveHandler());
                handlers.put("http-compressor", new SmartHttpContentCompressor(NettyHttpServer.this.httpCompressionStrategy));
                handlers.put("http-decompressor", new HttpContentDecompressor());
            }
            handlers.put("http-streams-codec", new HttpStreamsServerHandler());
            handlers.put("chunk-writer", new ChunkedWriteHandler());
            handlers.put("micronaut-http-decoder", this.requestDecoder);
            if (NettyHttpServer.this.serverConfiguration.isDualProtocol() && NettyHttpServer.this.serverConfiguration.isHttpToHttpsRedirect() && this.useSsl) {
                handlers.put("http-to-https-redirect", new HttpToHttpsRedirectHandler(NettyHttpServer.this.sslConfiguration, NettyHttpServer.this.hostResolver));
            }
            if (this.useSsl) {
                handlers.put("request-certificate-handler", NettyHttpServer.this.requestCertificateHandler);
            }
            handlers.put("micronaut-http-encoder", this.responseDecoder);
            handlers.put("websocket-upgrade-handler", new NettyServerWebSocketUpgradeHandler(NettyHttpServer.this.getWebSocketSessionRepository(), NettyHttpServer.this.router, NettyHttpServer.this.requestArgumentSatisfier.getBinderRegistry(), NettyHttpServer.this.webSocketBeanRegistry, NettyHttpServer.this.mediaTypeCodecRegistry, NettyHttpServer.this.applicationContext));
            handlers.put("micronaut-inbound-handler", NettyHttpServer.this.routingHandler);
            return handlers;
        }
    }
}

