/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.BeanContext;
import io.micronaut.context.exceptions.BeanCreationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.KotlinUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpMessage;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.binders.ContinuationArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.OncePerRequestHttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.multipart.PartData;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.content.HttpContentUtil;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.http.server.netty.DelegateStreamedHttpResponse;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.HttpDataReference;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.async.ContextCompletionAwareSubscriber;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.multipart.NettyPartData;
import io.micronaut.http.server.netty.multipart.NettyStreamingFileUpload;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandler;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import io.micronaut.http.server.netty.types.files.NettyStreamedFileCustomizableResponseType;
import io.micronaut.http.server.netty.types.files.NettySystemFileCustomizableResponseType;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.MethodReference;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.util.KotlinExecutableMethodUtils;
import io.micronaut.runtime.http.codec.TextPlainCodec;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.web.router.BasicObjectRouteMatch;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.exceptions.DuplicateRouteException;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.UnicastProcessor;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@ChannelHandler.Sharable
class RoutingInBoundHandler
extends SimpleChannelInboundHandler<HttpRequest<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingInBoundHandler.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final Argument ARGUMENT_PART_DATA = Argument.of(PartData.class);
    private static final Object NOT_FOUND = new Object();
    private final Router router;
    private final ExecutorSelector executorSelector;
    private final StaticResourceResolver staticResourceResolver;
    private final BeanContext beanContext;
    private final NettyHttpServerConfiguration serverConfiguration;
    private final HttpContentProcessorResolver httpContentProcessorResolver;
    private final ErrorResponseProcessor<?> errorResponseProcessor;
    private final RequestArgumentSatisfier requestArgumentSatisfier;
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry;
    private final Supplier<ExecutorService> ioExecutorSupplier;
    private final String serverHeader;
    private final boolean multipartEnabled;
    private ExecutorService ioExecutor;

    RoutingInBoundHandler(BeanContext beanContext, Router router, MediaTypeCodecRegistry mediaTypeCodecRegistry, NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry, StaticResourceResolver staticResourceResolver, NettyHttpServerConfiguration serverConfiguration, RequestArgumentSatisfier requestArgumentSatisfier, ExecutorSelector executorSelector, Supplier<ExecutorService> ioExecutor, HttpContentProcessorResolver httpContentProcessorResolver, ErrorResponseProcessor<?> errorResponseProcessor) {
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.customizableResponseTypeHandlerRegistry = customizableResponseTypeHandlerRegistry;
        this.beanContext = beanContext;
        this.staticResourceResolver = staticResourceResolver;
        this.ioExecutorSupplier = ioExecutor;
        this.executorSelector = executorSelector;
        this.router = router;
        this.requestArgumentSatisfier = requestArgumentSatisfier;
        this.serverConfiguration = serverConfiguration;
        this.serverHeader = serverConfiguration.getServerHeader().orElse(null);
        this.httpContentProcessorResolver = httpContentProcessorResolver;
        this.errorResponseProcessor = errorResponseProcessor;
        Optional<Boolean> multipartEnabled = serverConfiguration.getMultipart().getEnabled();
        this.multipartEnabled = !multipartEnabled.isPresent() || multipartEnabled.get() != false;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.cleanupIfNecessary(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (ctx.channel().isWritable()) {
            ctx.flush();
        }
        this.cleanupIfNecessary(ctx);
    }

    private void cleanupIfNecessary(ChannelHandlerContext ctx) {
        NettyHttpRequest.remove(ctx);
    }

    private void cleanupRequest(ChannelHandlerContext ctx, NettyHttpRequest request) {
        try {
            request.release();
        }
        finally {
            ctx.executor().execute(() -> {
                block2: {
                    try {
                        this.beanContext.publishEvent(new HttpRequestTerminatedEvent(request));
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) break block2;
                        LOG.error("Error publishing request terminated event: " + e.getMessage(), e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            IdleStateEvent idleStateEvent;
            IdleState state;
            if (evt instanceof IdleStateEvent && (state = (idleStateEvent = (IdleStateEvent)evt).state()) == IdleState.ALL_IDLE) {
                ctx.close();
            }
        }
        finally {
            super.userEventTriggered(ctx, evt);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        NettyHttpRequest nettyHttpRequest = NettyHttpRequest.remove(ctx);
        if (nettyHttpRequest == null) {
            if (cause instanceof SSLException || cause.getCause() instanceof SSLException || this.isIgnorable(cause)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
                }
            } else if (LOG.isErrorEnabled()) {
                LOG.error("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
            }
            ctx.writeAndFlush(new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
            return;
        }
        this.exceptionCaughtInternal(ctx, cause, nettyHttpRequest, true);
    }

    private void exceptionCaughtInternal(final ChannelHandlerContext ctx, Throwable t, final NettyHttpRequest nettyHttpRequest, final boolean skipOncePerRequest) {
        Optional<Class> rootBeanType;
        Throwable cause;
        RouteMatch errorRoute = null;
        RouteMatch<?> originalRoute = nettyHttpRequest.getMatchedRoute();
        Class declaringType = null;
        if (originalRoute instanceof MethodExecutionHandle) {
            declaringType = ((MethodExecutionHandle)((Object)originalRoute)).getDeclaringType();
        }
        if ((cause = (t instanceof CompletionException || t instanceof ExecutionException) && t.getCause() != null ? t.getCause() : t) instanceof UnsatisfiedRouteException) {
            if (declaringType != null) {
                errorRoute = this.router.findStatusRoute(declaringType, HttpStatus.BAD_REQUEST, nettyHttpRequest).orElse(null);
            }
            if (errorRoute == null) {
                errorRoute = this.router.findStatusRoute(HttpStatus.BAD_REQUEST, nettyHttpRequest).orElse(null);
            }
        } else if (cause instanceof HttpStatusException) {
            HttpStatusException statusException = (HttpStatusException)cause;
            if (declaringType != null) {
                errorRoute = this.router.findStatusRoute(declaringType, statusException.getStatus(), nettyHttpRequest).orElse(null);
            }
            if (errorRoute == null) {
                errorRoute = this.router.findStatusRoute(statusException.getStatus(), nettyHttpRequest).orElse(null);
            }
        } else if (cause instanceof BeanCreationException && declaringType != null && (rootBeanType = ((BeanCreationException)cause).getRootBeanType().map(BeanType::getBeanType)).isPresent() && declaringType == rootBeanType.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to instantiate [{}]. Skipping lookup of a local error route", (Object)declaringType.getName());
            }
            declaringType = null;
        }
        if (errorRoute == null) {
            if (declaringType != null) {
                errorRoute = this.router.findErrorRoute(declaringType, cause, nettyHttpRequest).orElse(null);
            }
            if (errorRoute == null) {
                errorRoute = this.router.findErrorRoute(cause, nettyHttpRequest).orElse(null);
            }
        }
        if (errorRoute != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found matching exception handler for exception [{}]: {}", (Object)cause.getMessage(), (Object)errorRoute);
            }
            errorRoute = this.requestArgumentSatisfier.fulfillArgumentRequirements(errorRoute, nettyHttpRequest, false);
            try {
                this.executeRoute(errorRoute, nettyHttpRequest, ctx, ctx.executor(), true, skipOncePerRequest, null);
            }
            catch (Throwable e) {
                this.writeDefaultErrorResponse(ctx, nettyHttpRequest, e, skipOncePerRequest);
            }
        } else {
            Optional<ExceptionHandler> exceptionHandler = this.beanContext.findBean(ExceptionHandler.class, Qualifiers.byTypeArgumentsClosest(cause.getClass(), Object.class));
            if (exceptionHandler.isPresent()) {
                final ExceptionHandler handler = exceptionHandler.get();
                try {
                    Flowable<MutableHttpResponse<?>> routePublisher = Flowable.fromCallable(() -> {
                        Object result = handler.handle(nettyHttpRequest, cause);
                        return this.errorResultToResponse(result);
                    });
                    this.filterPublisher(new AtomicReference(nettyHttpRequest), routePublisher, skipOncePerRequest).subscribe(new CompletionAwareSubscriber<MutableHttpResponse<?>>(){
                        MutableHttpResponse<?> mutableHttpResponse;

                        @Override
                        public void doOnSubscribe(Subscription s) {
                            s.request(1L);
                        }

                        @Override
                        public void doOnNext(MutableHttpResponse<?> mutableHttpResponse) {
                            this.mutableHttpResponse = mutableHttpResponse;
                        }

                        @Override
                        public void doOnError(Throwable throwable) {
                            RoutingInBoundHandler.this.writeDefaultErrorResponse(ctx, nettyHttpRequest, throwable, skipOncePerRequest);
                        }

                        @Override
                        public void doOnComplete() {
                            RoutingInBoundHandler.this.encodeHttpResponse(ctx, nettyHttpRequest, this.mutableHttpResponse, this.mutableHttpResponse.body(), () -> MediaType.fromType(handler.getClass()).orElse(MediaType.APPLICATION_JSON_TYPE));
                        }
                    });
                    if (this.serverConfiguration.isLogHandledExceptions()) {
                        this.logException(cause);
                    }
                }
                catch (Throwable e) {
                    this.writeDefaultErrorResponse(ctx, nettyHttpRequest, e, skipOncePerRequest);
                }
            } else if (this.isIgnorable(cause)) {
                this.logIgnoredException(cause);
                ctx.read();
            } else {
                this.writeDefaultErrorResponse(ctx, nettyHttpRequest, cause, skipOncePerRequest);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest<?> request) {
        void var12_19;
        NettyHttpRequest nettyHttpRequest;
        io.netty.handler.codec.http.HttpRequest nativeRequest;
        DecoderResult decoderResult;
        ctx.channel().config().setAutoRead(false);
        HttpMethod httpMethod = request.getMethod();
        String requestPath = request.getUri().getPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request {} {}", (Object)httpMethod, (Object)request.getUri());
        }
        if ((decoderResult = (nativeRequest = (nettyHttpRequest = (NettyHttpRequest)request).getNativeRequest()).decoderResult()).isFailure()) {
            Throwable cause = decoderResult.cause();
            HttpStatus status = cause instanceof TooLongFrameException ? HttpStatus.REQUEST_ENTITY_TOO_LARGE : HttpStatus.BAD_REQUEST;
            this.handleStatusError(ctx, request, nettyHttpRequest, HttpResponse.status(status), status.getReason());
            return;
        }
        MediaType contentType = request.getContentType().orElse(null);
        String requestMethodName = request.getMethodName();
        if (!this.multipartEnabled && contentType != null && contentType.equals(MediaType.MULTIPART_FORM_DATA_TYPE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Multipart uploads have been disabled via configuration. Rejected request for URI {}, method {}, and content type {}", request.getUri(), requestMethodName, contentType);
            }
            this.handleStatusError(ctx, request, nettyHttpRequest, HttpResponse.status(HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Content Type [" + contentType + "] not allowed");
            return;
        }
        UriRouteMatch<Object, Object> routeMatch = null;
        List<UriRouteMatch<Object, Object>> uriRoutes = this.router.findAllClosest(request);
        if (uriRoutes.size() > 1) {
            throw new DuplicateRouteException(requestPath, uriRoutes);
        }
        if (uriRoutes.size() == 1) {
            UriRouteMatch<Object, Object> uriRouteMatch = uriRoutes.get(0);
            request.setAttribute(HttpAttributes.ROUTE, uriRouteMatch.getRoute());
            request.setAttribute(HttpAttributes.ROUTE_MATCH, uriRouteMatch);
            request.setAttribute(HttpAttributes.URI_TEMPLATE, uriRouteMatch.getRoute().getUriMatchTemplate().toString());
            routeMatch = uriRouteMatch;
        }
        if (routeMatch == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No matching route: {} {}", (Object)httpMethod, (Object)request.getUri());
            }
            List anyMatchingRoutes = this.router.findAny(request.getUri().toString(), request).collect(Collectors.toList());
            Collection<MediaType> acceptedTypes = request.accept();
            boolean hasAcceptHeader = CollectionUtils.isNotEmpty(acceptedTypes);
            HashSet<MediaType> acceptableContentTypes = contentType != null ? new HashSet<MediaType>(5) : null;
            HashSet<String> allowedMethods = new HashSet<String>(5);
            HashSet<MediaType> produceableContentTypes = hasAcceptHeader ? new HashSet<MediaType>(5) : null;
            for (UriRouteMatch anyRoute : anyMatchingRoutes) {
                String routeMethod = anyRoute.getRoute().getHttpMethodName();
                if (!requestMethodName.equals(routeMethod)) {
                    allowedMethods.add(routeMethod);
                }
                if (contentType != null && !anyRoute.doesConsume(contentType)) {
                    acceptableContentTypes.addAll(anyRoute.getRoute().getConsumes());
                }
                if (!hasAcceptHeader || anyRoute.doesProduce(acceptedTypes)) continue;
                produceableContentTypes.addAll(anyRoute.getRoute().getProduces());
            }
            if (CollectionUtils.isNotEmpty(acceptableContentTypes)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", request.getUri(), requestMethodName, contentType);
                }
                this.handleStatusError(ctx, request, nettyHttpRequest, HttpResponse.status(HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Content Type [" + contentType + "] not allowed. Allowed types: " + acceptableContentTypes);
                return;
            }
            if (CollectionUtils.isNotEmpty(produceableContentTypes)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", request.getUri(), requestMethodName, contentType);
                }
                this.handleStatusError(ctx, request, nettyHttpRequest, HttpResponse.status(HttpStatus.NOT_ACCEPTABLE), "Specified Accept Types " + acceptedTypes + " not supported. Supported types: " + produceableContentTypes);
                return;
            }
            if (!allowedMethods.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Method not allowed for URI {} and method {}", (Object)request.getUri(), (Object)requestMethodName);
                }
                this.handleStatusError(ctx, request, nettyHttpRequest, HttpResponse.notAllowedGeneric(allowedMethods), "Method [" + requestMethodName + "] not allowed for URI [" + request.getUri() + "]. Allowed methods: " + allowedMethods);
                return;
            }
            Optional<? extends FileCustomizableResponseType> optionalFile = this.matchFile(requestPath);
            if (optionalFile.isPresent()) {
                BasicObjectRouteMatch basicObjectRouteMatch = new BasicObjectRouteMatch(optionalFile.get());
            } else {
                Optional statusRoute = this.router.findStatusRoute(HttpStatus.NOT_FOUND, request);
                if (!statusRoute.isPresent()) {
                    this.emitDefaultNotFoundResponse(ctx, request, false);
                    return;
                }
                RouteMatch routeMatch2 = statusRoute.get();
            }
        } else {
            UriRouteMatch<Object, Object> uriRouteMatch = routeMatch;
        }
        if (LOG.isTraceEnabled()) {
            if (var12_19 instanceof MethodBasedRouteMatch) {
                LOG.trace("Matched route {} - {} to controller {}", requestMethodName, requestPath, var12_19.getDeclaringType());
            } else {
                LOG.trace("Matched route {} - {}", (Object)requestMethodName, (Object)requestPath);
            }
        }
        if (var12_19.isWebSocketRoute()) {
            this.handleStatusError(ctx, request, nettyHttpRequest, HttpResponse.status(HttpStatus.BAD_REQUEST), "Not a WebSocket request");
            return;
        }
        this.handleRouteMatch((RouteMatch<?>)var12_19, nettyHttpRequest, ctx, false);
    }

    private void handleStatusError(ChannelHandlerContext ctx, HttpRequest<?> request, NettyHttpRequest nettyHttpRequest, MutableHttpResponse<?> defaultResponse, String message) {
        Optional statusRoute = this.router.findStatusRoute(defaultResponse.status(), request);
        if (statusRoute.isPresent()) {
            RouteMatch routeMatch = statusRoute.get();
            this.handleRouteMatch(routeMatch, nettyHttpRequest, ctx, false);
        } else {
            if (request.getMethod() != HttpMethod.HEAD) {
                defaultResponse = this.errorResponseProcessor.processResponse(ErrorContext.builder(request).errorMessage(message).build(), defaultResponse);
            }
            this.filterAndEncodeResponse(ctx, request, nettyHttpRequest, defaultResponse, MediaType.APPLICATION_JSON_TYPE, false);
        }
    }

    private void filterAndEncodeResponse(final ChannelHandlerContext ctx, HttpRequest<?> request, final NettyHttpRequest nettyHttpRequest, MutableHttpResponse<?> finalResponse, final MediaType defaultResponseMediaType, boolean skipOncePerRequest) {
        AtomicReference requestReference = new AtomicReference(request);
        this.filterPublisher(requestReference, Publishers.just(finalResponse), skipOncePerRequest).subscribe(new CompletionAwareSubscriber<MutableHttpResponse<?>>(){
            MutableHttpResponse<?> mutableHttpResponse;

            @Override
            public void doOnSubscribe(Subscription s) {
                s.request(1L);
            }

            @Override
            public void doOnNext(MutableHttpResponse<?> mutableHttpResponse) {
                this.mutableHttpResponse = mutableHttpResponse;
            }

            @Override
            public void doOnError(Throwable throwable) {
                RoutingInBoundHandler.this.exceptionCaughtInternal(ctx, throwable, nettyHttpRequest, false);
            }

            @Override
            public void doOnComplete() {
                RoutingInBoundHandler.this.encodeHttpResponse(ctx, nettyHttpRequest, this.mutableHttpResponse, this.mutableHttpResponse.body(), () -> defaultResponseMediaType);
            }
        });
    }

    private Optional<? extends FileCustomizableResponseType> matchFile(String path) {
        Optional<URL> optionalUrl = this.staticResourceResolver.resolve(path);
        if (optionalUrl.isPresent()) {
            try {
                File file;
                URL url = optionalUrl.get();
                if (url.getProtocol().equals("file") && (file = Paths.get(url.toURI()).toFile()).exists() && !file.isDirectory() && file.canRead()) {
                    return Optional.of(new NettySystemFileCustomizableResponseType(file));
                }
                return Optional.of(new NettyStreamedFileCustomizableResponseType(url));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private void emitDefaultNotFoundResponse(ChannelHandlerContext ctx, HttpRequest<?> request, boolean skipOncePerRequest) {
        MutableHttpResponse<?> res = this.newNotFoundError(request);
        this.filterAndEncodeResponse(ctx, request, (NettyHttpRequest)request, res, MediaType.APPLICATION_JSON_TYPE, skipOncePerRequest);
    }

    private MutableHttpResponse<?> newNotFoundError(HttpRequest<?> request) {
        return this.errorResponseProcessor.processResponse(ErrorContext.builder(request).errorMessage("Page Not Found").build(), HttpResponse.notFound());
    }

    private MutableHttpResponse errorResultToResponse(Object result) {
        if (result instanceof HttpResponse) {
            return this.toNettyResponse((HttpResponse)result);
        }
        MutableHttpMessage<Object> response = result instanceof HttpStatus ? HttpResponse.status((HttpStatus)result) : HttpResponse.serverError().body(result);
        return response;
    }

    private void handleRouteMatch(RouteMatch<?> route, NettyHttpRequest<?> request, ChannelHandlerContext context, boolean skipOncePerRequest) {
        request.setMatchedRoute(route);
        route = this.requestArgumentSatisfier.fulfillArgumentRequirements(route, request, false);
        request.setMatchedRoute(route);
        Optional<Argument> bodyArgument = route.getBodyArgument().filter(argument -> argument.getAnnotationMetadata().hasAnnotation(Body.class));
        io.netty.handler.codec.http.HttpRequest nativeRequest = request.getNativeRequest();
        HttpContentProcessor<?> contentProcessor = null;
        if (!(route.isExecutable() || !HttpMethod.permitsRequestBody(request.getMethod()) || !(nativeRequest instanceof StreamedHttpRequest) || bodyArgument.isPresent() && route.isSatisfied(bodyArgument.get().getName()))) {
            contentProcessor = this.httpContentProcessorResolver.resolve(request, route);
        } else {
            context.read();
        }
        ExecutorService executor = route instanceof MethodReference ? (ExecutorService)this.executorSelector.select((MethodReference)((Object)route), this.serverConfiguration.getThreadSelection()).orElse(null) : null;
        boolean isErrorRoute = false;
        this.executeRoute(route, request, context, executor, isErrorRoute, skipOncePerRequest, contentProcessor);
    }

    private boolean isJsonFormattable(Argument<?> argument) {
        Class javaType = argument.getType();
        if (Publishers.isConvertibleToPublisher(javaType)) {
            javaType = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT).getType();
        }
        return javaType != byte[].class && !ByteBuffer.class.isAssignableFrom(javaType) && !ByteBuf.class.isAssignableFrom(javaType);
    }

    private Subscriber<Object> buildSubscriber(final NettyHttpRequest<?> request, final RouteMatch<?> finalRoute, final SingleEmitter<RouteMatch<?>> emitter) {
        boolean isFormData = request.isFormOrMultipartData();
        if (isFormData) {
            return new CompletionAwareSubscriber<Object>(){
                final boolean alwaysAddContent;
                RouteMatch<?> routeMatch;
                final AtomicBoolean executed;
                final AtomicLong pressureRequested;
                final ConcurrentHashMap<String, UnicastProcessor> subjects;
                final ConcurrentHashMap<Integer, HttpDataReference> dataReferences;
                final ConversionService conversionService;
                Subscription s;
                final LongConsumer onRequest;
                {
                    this.alwaysAddContent = request.isFormData();
                    this.routeMatch = finalRoute;
                    this.executed = new AtomicBoolean(false);
                    this.pressureRequested = new AtomicLong(0L);
                    this.subjects = new ConcurrentHashMap();
                    this.dataReferences = new ConcurrentHashMap();
                    this.conversionService = ConversionService.SHARED;
                    this.onRequest = num -> this.pressureRequested.updateAndGet(p -> {
                        long newVal = p - num;
                        if (newVal < 0L) {
                            this.s.request(num - p);
                            return 0L;
                        }
                        return newVal;
                    });
                }

                Flowable processFlowable(Flowable flowable, Integer dataKey, boolean controlsFlow) {
                    if (controlsFlow) {
                        flowable = flowable.doOnRequest(this.onRequest);
                    }
                    return flowable.doAfterTerminate(() -> {
                        if (controlsFlow) {
                            HttpDataReference dataReference = this.dataReferences.get(dataKey);
                            dataReference.destroy();
                        }
                    });
                }

                @Override
                protected void doOnSubscribe(Subscription subscription) {
                    this.s = subscription;
                    subscription.request(1L);
                }

                @Override
                protected void doOnNext(Object message) {
                    boolean executed = this.executed.get();
                    if (message instanceof ByteBufHolder) {
                        if (message instanceof HttpData) {
                            String name;
                            Optional<Argument<?>> requiredInput;
                            HttpData data = (HttpData)message;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Received HTTP Data for request [{}]: {}", (Object)request, message);
                            }
                            if ((requiredInput = this.routeMatch.getRequiredInput(name = data.getName())).isPresent()) {
                                Supplier<Object> value;
                                Argument<?> argument = requiredInput.get();
                                boolean isPublisher = Publishers.isConvertibleToPublisher(argument.getType());
                                boolean chunkedProcessing = false;
                                if (isPublisher) {
                                    UnicastProcessor ds;
                                    Integer dataKey = System.identityHashCode(data);
                                    HttpDataReference dataReference = this.dataReferences.computeIfAbsent(dataKey, key -> new HttpDataReference(data));
                                    Argument<Object> typeVariable = StreamingFileUpload.class.isAssignableFrom(argument.getType()) ? ARGUMENT_PART_DATA : argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                                    Class typeVariableType = typeVariable.getType();
                                    UnicastProcessor namedSubject = this.subjects.computeIfAbsent(name, key -> UnicastProcessor.create());
                                    boolean bl = chunkedProcessing = PartData.class.equals(typeVariableType) || Publishers.isConvertibleToPublisher(typeVariableType) || ClassUtils.isJavaLangType(typeVariableType);
                                    if (Publishers.isConvertibleToPublisher(typeVariableType)) {
                                        boolean streamingFileUpload = StreamingFileUpload.class.isAssignableFrom(typeVariableType);
                                        typeVariable = streamingFileUpload ? ARGUMENT_PART_DATA : typeVariable.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                                        dataReference.subject.getAndUpdate(subject -> {
                                            if (subject == null) {
                                                UnicastProcessor childSubject = UnicastProcessor.create();
                                                Flowable flowable = this.processFlowable(childSubject, dataKey, true);
                                                if (streamingFileUpload && data instanceof FileUpload) {
                                                    namedSubject.onNext(new NettyStreamingFileUpload((FileUpload)data, RoutingInBoundHandler.this.serverConfiguration.getMultipart(), RoutingInBoundHandler.this.getIoExecutor(), flowable));
                                                } else {
                                                    namedSubject.onNext(flowable);
                                                }
                                                return childSubject;
                                            }
                                            return subject;
                                        });
                                    }
                                    UnicastProcessor subject2 = (ds = dataReference.subject.get()) != null ? ds : namedSubject;
                                    Object part = data;
                                    if (chunkedProcessing) {
                                        HttpDataReference.Component component;
                                        try {
                                            component = dataReference.addComponent();
                                            if (component == null) {
                                                this.s.request(1L);
                                                return;
                                            }
                                        }
                                        catch (IOException e) {
                                            subject2.onError(e);
                                            this.s.cancel();
                                            return;
                                        }
                                        part = new NettyPartData(dataReference, component);
                                    }
                                    if (data instanceof FileUpload && StreamingFileUpload.class.isAssignableFrom(argument.getType())) {
                                        dataReference.upload.getAndUpdate(upload -> {
                                            if (upload == null) {
                                                return new NettyStreamingFileUpload((FileUpload)data, RoutingInBoundHandler.this.serverConfiguration.getMultipart(), RoutingInBoundHandler.this.getIoExecutor(), this.processFlowable(subject2, dataKey, true));
                                            }
                                            return upload;
                                        });
                                    }
                                    Optional<Object> converted = this.conversionService.convert(part, typeVariable);
                                    converted.ifPresent(subject2::onNext);
                                    if (data.isCompleted() && chunkedProcessing) {
                                        subject2.onComplete();
                                    }
                                    value = () -> {
                                        StreamingFileUpload upload = dataReference.upload.get();
                                        if (upload != null) {
                                            return upload;
                                        }
                                        return this.processFlowable(namedSubject, dataKey, dataReference.subject.get() == null);
                                    };
                                } else {
                                    if (data instanceof Attribute && !data.isCompleted()) {
                                        request.addContent(data);
                                        this.s.request(1L);
                                        return;
                                    }
                                    value = () -> {
                                        if (data.refCnt() > 0) {
                                            return data;
                                        }
                                        return null;
                                    };
                                }
                                if (!executed) {
                                    String argumentName = argument.getName();
                                    if (!this.routeMatch.isSatisfied(argumentName)) {
                                        this.routeMatch = this.routeMatch.fulfill(Collections.singletonMap(argumentName, value.get()));
                                    }
                                    if (isPublisher && chunkedProcessing) {
                                        this.pressureRequested.incrementAndGet();
                                    }
                                    if (this.routeMatch.isExecutable() || message instanceof LastHttpContent) {
                                        this.executeRoute();
                                        executed = true;
                                    }
                                }
                                if (this.alwaysAddContent) {
                                    request.addContent(data);
                                }
                                if (!executed || !chunkedProcessing) {
                                    this.s.request(1L);
                                }
                            } else {
                                request.addContent(data);
                                this.s.request(1L);
                            }
                        } else {
                            request.addContent((ByteBufHolder)message);
                            this.s.request(1L);
                        }
                    } else {
                        request.setBody(message);
                        this.s.request(1L);
                    }
                }

                @Override
                protected void doOnError(Throwable t) {
                    this.s.cancel();
                    emitter.onError(t);
                }

                @Override
                protected void doOnComplete() {
                    for (UnicastProcessor subject : this.subjects.values()) {
                        if (subject.hasComplete()) continue;
                        subject.onComplete();
                    }
                    this.executeRoute();
                }

                private void executeRoute() {
                    if (this.executed.compareAndSet(false, true)) {
                        emitter.onSuccess(this.routeMatch);
                    }
                }
            };
        }
        return new CompletionAwareSubscriber<Object>(){
            private Subscription s;
            private RouteMatch<?> routeMatch;
            private AtomicBoolean executed;
            {
                this.routeMatch = finalRoute;
                this.executed = new AtomicBoolean(false);
            }

            @Override
            protected void doOnSubscribe(Subscription subscription) {
                this.s = subscription;
                subscription.request(1L);
            }

            @Override
            protected void doOnNext(Object message) {
                if (message instanceof ByteBufHolder) {
                    request.addContent((ByteBufHolder)message);
                    this.s.request(1L);
                } else {
                    request.setBody(message);
                    this.s.request(1L);
                }
            }

            @Override
            protected void doOnError(Throwable t) {
                this.s.cancel();
                emitter.onError(t);
            }

            @Override
            protected void doOnComplete() {
                if (this.executed.compareAndSet(false, true)) {
                    emitter.onSuccess(this.routeMatch);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getIoExecutor() {
        ExecutorService executor = this.ioExecutor;
        if (executor == null) {
            RoutingInBoundHandler routingInBoundHandler = this;
            synchronized (routingInBoundHandler) {
                executor = this.ioExecutor;
                if (executor == null) {
                    this.ioExecutor = executor = this.ioExecutorSupplier.get();
                }
            }
        }
        return executor;
    }

    private boolean isSingle(RouteMatch<?> finalRoute, Class<?> bodyClass) {
        return finalRoute.isSpecifiedSingle() || finalRoute.isSingleResult() && (finalRoute.isAsync() || finalRoute.isSuspended() || Publishers.isSingle(bodyClass));
    }

    private void executeRoute(final RouteMatch<?> routeMatch, final NettyHttpRequest<?> request, final ChannelHandlerContext context, final ExecutorService executor, final boolean isErrorRoute, final boolean skipOncePerRequest, HttpContentProcessor<?> contentProcessor) {
        final Supplier<MediaType> defaultResponseMediaType = () -> this.resolveDefaultResponseContentType(request, routeMatch);
        final AtomicReference requestReference = new AtomicReference(request);
        Publisher<MutableHttpResponse<?>> filteredPublisher = this.buildResultEmitter(request, requestReference, routeMatch, executor, isErrorRoute, skipOncePerRequest, contentProcessor);
        filteredPublisher.subscribe(new ContextCompletionAwareSubscriber<MutableHttpResponse<?>>(context){

            @Override
            protected void onComplete(final MutableHttpResponse<?> message) {
                RouteMatch statusRoute;
                final HttpRequest incomingRequest = (HttpRequest)requestReference.get();
                RoutingInBoundHandler.this.applyConfiguredHeaders((MutableHttpHeaders)message.getHeaders());
                HttpStatus status = message.status();
                if (status.getCode() >= 400 && !isErrorRoute && (statusRoute = RoutingInBoundHandler.this.findStatusRoute(incomingRequest, status, routeMatch)) != null) {
                    incomingRequest.setAttribute(HttpAttributes.ROUTE_MATCH, statusRoute);
                    RoutingInBoundHandler.this.executeRoute(statusRoute, request, context, executor, true, true, null);
                    return;
                }
                MediaType specifiedMediaType = message.getContentType().orElse(null);
                final MediaType mediaType = specifiedMediaType != null ? specifiedMediaType : (MediaType)defaultResponseMediaType.get();
                Object body = message.body();
                if (body != null) {
                    boolean isReactive;
                    boolean bl = isReactive = routeMatch.isAsyncOrReactive() || Publishers.isConvertibleToPublisher(body);
                    if (isReactive && Publishers.isConvertibleToPublisher(body)) {
                        boolean isCompletable;
                        message.body((Object)null);
                        Class<?> bodyClass = body.getClass();
                        boolean isSingle = RoutingInBoundHandler.this.isSingle(routeMatch, bodyClass);
                        boolean bl2 = isCompletable = !isSingle && routeMatch.isVoid() && Publishers.isCompletable(bodyClass);
                        if (isSingle || isCompletable) {
                            Publisher publisher = Publishers.convertPublisher(body, Publisher.class);
                            publisher.subscribe(new CompletionAwareSubscriber<Object>(){
                                Object result = RoutingInBoundHandler.access$1100();

                                @Override
                                protected void doOnSubscribe(Subscription subscription) {
                                    subscription.request(1L);
                                }

                                @Override
                                protected void doOnNext(Object result) {
                                    this.result = result;
                                }

                                @Override
                                protected void doOnError(Throwable throwable) {
                                    RoutingInBoundHandler.this.exceptionCaughtInternal(context, throwable, request, false);
                                }

                                @Override
                                protected void doOnComplete() {
                                    if (this.result == NOT_FOUND) {
                                        if (isCompletable || routeMatch.isVoid() || routeMatch.isSuspended()) {
                                            message.body((Object)null);
                                            message.header("Content-Length", HttpHeaderValues.ZERO);
                                            RoutingInBoundHandler.this.writeFinalNettyResponse(message, request, context);
                                        } else if (!isErrorRoute) {
                                            RouteMatch statusRoute = RoutingInBoundHandler.this.findStatusRoute(incomingRequest, HttpStatus.NOT_FOUND, routeMatch);
                                            if (statusRoute != null) {
                                                RoutingInBoundHandler.this.executeRoute(statusRoute, request, context, executor, true, true, null);
                                            } else {
                                                RoutingInBoundHandler.this.emitDefaultNotFoundResponse(context, (HttpRequest)requestReference.get(), skipOncePerRequest);
                                            }
                                        } else {
                                            RoutingInBoundHandler.this.emitDefaultNotFoundResponse(context, (HttpRequest)requestReference.get(), skipOncePerRequest);
                                        }
                                    } else {
                                        MutableHttpResponse finalResponse;
                                        if (this.result instanceof HttpResponse) {
                                            finalResponse = RoutingInBoundHandler.this.toMutableResponse((HttpResponse)this.result);
                                            this.result = finalResponse.body();
                                        } else {
                                            finalResponse = message;
                                        }
                                        RoutingInBoundHandler.this.encodeHttpResponse(context, request, finalResponse, this.result, defaultResponseMediaType);
                                    }
                                }
                            });
                        } else {
                            boolean isHttp2;
                            Argument<Object> typeArgument = routeMatch.getReturnType().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                            boolean bl3 = isHttp2 = request.getHttpVersion() == HttpVersion.HTTP_2_0;
                            if (HttpResponse.class.isAssignableFrom(typeArgument.getType()) && !typeArgument.getFirstTypeVariable().map(TypeInformation::isAsyncOrReactive).orElse(false).booleanValue()) {
                                Publisher bodyPublisher = Publishers.convertPublisher(body, Publisher.class);
                                if (isHttp2) {
                                    bodyPublisher.subscribe(new CompletionAwareSubscriber<HttpResponse<?>>(){

                                        @Override
                                        protected void doOnSubscribe(Subscription subscription) {
                                            subscription.request(1L);
                                        }

                                        @Override
                                        protected void doOnNext(HttpResponse<?> message) {
                                            RoutingInBoundHandler.this.encodeHttpResponse(context, request, RoutingInBoundHandler.this.toNettyResponse(message), message.body(), defaultResponseMediaType);
                                            this.subscription.request(1L);
                                        }

                                        @Override
                                        protected void doOnError(Throwable throwable) {
                                            RoutingInBoundHandler.this.exceptionCaughtInternal(context, throwable, request, false);
                                        }

                                        @Override
                                        protected void doOnComplete() {
                                        }
                                    });
                                } else {
                                    bodyPublisher.subscribe(new CompletionAwareSubscriber<HttpResponse<?>>(){
                                        final AtomicBoolean received = new AtomicBoolean();

                                        @Override
                                        protected void doOnSubscribe(Subscription subscription) {
                                            subscription.request(1L);
                                        }

                                        @Override
                                        protected void doOnNext(HttpResponse<?> message) {
                                            RoutingInBoundHandler.this.encodeHttpResponse(context, request, RoutingInBoundHandler.this.toNettyResponse(message), message.body(), defaultResponseMediaType);
                                            this.received.set(true);
                                        }

                                        @Override
                                        protected void doOnError(Throwable throwable) {
                                            RoutingInBoundHandler.this.exceptionCaughtInternal(context, throwable, request, false);
                                        }

                                        @Override
                                        protected void doOnComplete() {
                                            if (!this.received.get()) {
                                                this.doOnError(new NoSuchElementException());
                                            }
                                        }
                                    });
                                }
                            } else {
                                final boolean isJson = mediaType.getExtension().equals("json") && RoutingInBoundHandler.this.isJsonFormattable(typeArgument);
                                Publisher bodyPublisher = RoutingInBoundHandler.this.applyExecutorToPublisher(Publishers.convertPublisher(body, Publisher.class), executor);
                                final NettyByteBufferFactory byteBufferFactory = new NettyByteBufferFactory(context.alloc());
                                Publisher<HttpContent> httpContentPublisher = Publishers.map(bodyPublisher, new Function<Object, HttpContent>(){
                                    boolean first = true;

                                    @Override
                                    public HttpContent apply(Object message) {
                                        HttpContent httpContent;
                                        if (message instanceof ByteBuf) {
                                            httpContent = new DefaultHttpContent((ByteBuf)message);
                                        } else if (message instanceof ByteBuffer) {
                                            ByteBuffer byteBuffer = (ByteBuffer)message;
                                            Object nativeBuffer = byteBuffer.asNativeBuffer();
                                            httpContent = nativeBuffer instanceof ByteBuf ? new DefaultHttpContent((ByteBuf)nativeBuffer) : new DefaultHttpContent(Unpooled.copiedBuffer(byteBuffer.asNioBuffer()));
                                        } else if (message instanceof byte[]) {
                                            httpContent = new DefaultHttpContent(Unpooled.copiedBuffer((byte[])message));
                                        } else if (message instanceof HttpContent) {
                                            httpContent = (HttpContent)message;
                                        } else {
                                            MediaTypeCodec codec = RoutingInBoundHandler.this.mediaTypeCodecRegistry.findCodec(mediaType, message.getClass()).orElse(new TextPlainCodec(RoutingInBoundHandler.this.serverConfiguration.getDefaultCharset()));
                                            if (LOG.isTraceEnabled()) {
                                                LOG.trace("Encoding emitted response object [{}] using codec: {}", message, (Object)codec);
                                            }
                                            ByteBuffer<ByteBuf> encoded = codec.encode(message, byteBufferFactory);
                                            httpContent = new DefaultHttpContent(encoded.asNativeBuffer());
                                        }
                                        if (!isJson || this.first) {
                                            this.first = false;
                                            return httpContent;
                                        }
                                        return HttpContentUtil.prefixComma(httpContent);
                                    }
                                });
                                if (isJson) {
                                    httpContentPublisher = Flowable.concat(Flowable.fromCallable(HttpContentUtil::openBracket), httpContentPublisher, Flowable.fromCallable(HttpContentUtil::closeBracket));
                                }
                                if (mediaType.equals(MediaType.TEXT_EVENT_STREAM_TYPE)) {
                                    httpContentPublisher = Publishers.onComplete(httpContentPublisher, () -> {
                                        CompletableFuture future = new CompletableFuture();
                                        if (!request.getHeaders().isKeepAlive() && context.channel().isOpen()) {
                                            context.pipeline().writeAndFlush(new DefaultLastHttpContent()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                                                if (f.isSuccess()) {
                                                    future.complete(null);
                                                } else {
                                                    future.completeExceptionally(f.cause());
                                                }
                                            }));
                                        }
                                        return future;
                                    });
                                }
                                httpContentPublisher = Publishers.then(httpContentPublisher, httpContent -> context.read());
                                httpContentPublisher = Flowable.fromPublisher(httpContentPublisher).doAfterTerminate(() -> RoutingInBoundHandler.this.cleanupRequest(context, request));
                                DelegateStreamedHttpResponse streamedResponse = new DelegateStreamedHttpResponse(RoutingInBoundHandler.this.toNettyResponse(message).toHttpResponse(), httpContentPublisher);
                                io.netty.handler.codec.http.HttpHeaders headers = streamedResponse.headers();
                                headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                                headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
                                if (isHttp2) {
                                    RoutingInBoundHandler.this.addHttp2StreamHeader(request, streamedResponse);
                                }
                                context.writeAndFlush(streamedResponse);
                                context.read();
                            }
                        }
                    } else {
                        RoutingInBoundHandler.this.encodeHttpResponse(context, request, message, body, defaultResponseMediaType);
                    }
                } else {
                    RoutingInBoundHandler.this.writeFinalNettyResponse(message, (HttpRequest)requestReference.get(), context);
                }
            }

            @Override
            protected void doOnError(Throwable t) {
                NettyHttpRequest nettyHttpRequest = (NettyHttpRequest)requestReference.get();
                RoutingInBoundHandler.this.exceptionCaughtInternal(context, t, nettyHttpRequest, true);
            }
        });
    }

    private Publisher<? extends MutableHttpResponse<?>> buildResultEmitter(NettyHttpRequest<?> request, AtomicReference<HttpRequest<?>> requestReference, RouteMatch<?> finalRoute, ExecutorService executor, boolean isErrorRoute, boolean skipOncePerRequest, HttpContentProcessor<?> contentProcessor) {
        Publisher<MutableHttpResponse<Object>> executeRoutePublisher = contentProcessor != null ? Single.create(emitter -> contentProcessor.subscribe(this.buildSubscriber(request, finalRoute, emitter))).flatMapPublisher(route -> this.createExecuteRoutePublisher(request, requestReference, (RouteMatch<?>)route, isErrorRoute, executor)) : this.createExecuteRoutePublisher(request, requestReference, finalRoute, isErrorRoute, executor);
        return this.filterPublisher(requestReference, executeRoutePublisher, skipOncePerRequest);
    }

    private Publisher<MutableHttpResponse<?>> createExecuteRoutePublisher(final NettyHttpRequest<?> request, final AtomicReference<HttpRequest<?>> requestReference, final RouteMatch<?> routeMatch, final boolean isErrorRoute, final Executor executor) {
        return new Publisher<MutableHttpResponse<?>>(){

            @Override
            public void subscribe(Subscriber<? super MutableHttpResponse<?>> subscriber) {
                if (executor == null) {
                    this.doSubscribe(subscriber);
                } else {
                    executor.execute(() -> this.doSubscribe(subscriber));
                }
            }

            private void doSubscribe(final Subscriber<? super MutableHttpResponse<?>> subscriber) {
                subscriber.onSubscribe(new Subscription(){
                    boolean done;

                    @Override
                    public void request(long n) {
                        if (this.done) {
                            return;
                        }
                        this.done = true;
                        try {
                            ServerRequestContext.set((HttpRequest)requestReference.get());
                            RoutingInBoundHandler.this.emitRouteResponse(subscriber, request, requestReference, routeMatch, isErrorRoute);
                        }
                        finally {
                            ServerRequestContext.set(null);
                        }
                    }

                    @Override
                    public void cancel() {
                    }
                });
            }
        };
    }

    private void emitRouteResponse(final Subscriber<MutableHttpResponse<?>> subscriber, final NettyHttpRequest<?> request, AtomicReference<HttpRequest<?>> requestReference, final RouteMatch<?> routeMatch, boolean isErrorRoute) {
        try {
            MutableHttpMessage<Object> outgoingResponse;
            final RouteMatch<?> finalRoute = !routeMatch.isExecutable() ? this.requestArgumentSatisfier.fulfillArgumentRequirements(routeMatch, requestReference.get(), true) : routeMatch;
            boolean isSuspended = finalRoute.isSuspended();
            Object body = finalRoute.execute();
            if (body instanceof Optional) {
                body = ((Optional)body).orElse(null);
            }
            HttpRequest<?> incomingRequest = requestReference.get();
            if (body == null) {
                if (finalRoute.isVoid()) {
                    outgoingResponse = this.forStatus(finalRoute);
                    if (HttpMethod.permitsRequestBody(request.getMethod())) {
                        outgoingResponse.header("Content-Length", HttpHeaderValues.ZERO);
                    }
                } else {
                    outgoingResponse = this.newNotFoundError(request);
                }
            } else {
                boolean isReactive;
                final HttpStatus defaultHttpStatus = isErrorRoute ? HttpStatus.INTERNAL_SERVER_ERROR : HttpStatus.OK;
                boolean bl = isReactive = finalRoute.isAsyncOrReactive() || Publishers.isConvertibleToPublisher(body);
                if (isReactive) {
                    boolean isCompletable;
                    Class<?> bodyClass = body.getClass();
                    boolean isSingle = this.isSingle(finalRoute, bodyClass);
                    boolean bl2 = isCompletable = !isSingle && finalRoute.isVoid() && Publishers.isCompletable(bodyClass);
                    if (isSingle || isCompletable) {
                        Publisher publisher = Publishers.convertPublisher(body, Publisher.class);
                        Publishers.mapOrSupplyEmpty(publisher, new Publishers.MapOrSupplyEmpty<Object, MutableHttpResponse<?>>(){

                            @Override
                            public MutableHttpResponse<?> map(Object o) {
                                if (o instanceof Optional) {
                                    Optional optional = (Optional)o;
                                    if (optional.isPresent()) {
                                        o = ((Optional)o).get();
                                    } else {
                                        return this.supplyEmpty();
                                    }
                                }
                                MutableHttpMessage singleResponse = o instanceof HttpResponse ? RoutingInBoundHandler.this.toMutableResponse((HttpResponse)o) : (o instanceof HttpStatus ? RoutingInBoundHandler.this.forStatus(routeMatch, (HttpStatus)o) : RoutingInBoundHandler.this.forStatus(routeMatch, defaultHttpStatus).body(o));
                                singleResponse.setAttribute(HttpAttributes.ROUTE_MATCH, finalRoute);
                                return singleResponse;
                            }

                            @Override
                            public MutableHttpResponse<?> supplyEmpty() {
                                MutableHttpMessage singleResponse = isCompletable || finalRoute.isVoid() ? RoutingInBoundHandler.this.forStatus(finalRoute, HttpStatus.OK).header("Content-Length", HttpHeaderValues.ZERO) : RoutingInBoundHandler.this.newNotFoundError(request);
                                singleResponse.setAttribute(HttpAttributes.ROUTE_MATCH, finalRoute);
                                return singleResponse;
                            }
                        }).subscribe(new CompletionAwareSubscriber<MutableHttpResponse<?>>(){

                            @Override
                            public void doOnSubscribe(Subscription s) {
                                s.request(1L);
                            }

                            @Override
                            public void doOnNext(MutableHttpResponse<?> mutableHttpResponse) {
                                subscriber.onNext(mutableHttpResponse);
                            }

                            @Override
                            public void doOnError(Throwable t) {
                                subscriber.onError(t);
                            }

                            @Override
                            public void doOnComplete() {
                                subscriber.onComplete();
                            }
                        });
                        return;
                    }
                }
                if (body instanceof HttpStatus) {
                    outgoingResponse = HttpResponse.status((HttpStatus)body);
                } else if (isSuspended) {
                    boolean isKotlinFunctionReturnTypeUnit = finalRoute instanceof MethodBasedRouteMatch && KotlinExecutableMethodUtils.isKotlinFunctionReturnTypeUnit(((MethodBasedRouteMatch)finalRoute).getExecutableMethod());
                    Supplier<CompletableFuture<?>> supplier = ContinuationArgumentBinder.extractContinuationCompletableFutureSupplier(incomingRequest);
                    if (KotlinUtils.isKotlinCoroutineSuspended(body)) {
                        CompletableFuture<?> f = supplier.get();
                        f.whenComplete((o, throwable) -> {
                            if (throwable != null) {
                                subscriber.onError((Throwable)throwable);
                            } else {
                                if (o == null) {
                                    subscriber.onNext(this.newNotFoundError(request));
                                } else {
                                    MutableHttpMessage<Object> response;
                                    if (o instanceof HttpResponse) {
                                        response = this.toMutableResponse((HttpResponse)o);
                                    } else {
                                        response = this.forStatus(routeMatch, defaultHttpStatus);
                                        if (!isKotlinFunctionReturnTypeUnit) {
                                            response = response.body(o);
                                        }
                                    }
                                    response.setAttribute(HttpAttributes.ROUTE_MATCH, finalRoute);
                                    subscriber.onNext((MutableHttpResponse<?>)response);
                                }
                                subscriber.onComplete();
                            }
                        });
                        return;
                    }
                    Completable suspendedBody = isKotlinFunctionReturnTypeUnit ? Completable.complete() : body;
                    outgoingResponse = suspendedBody instanceof HttpResponse ? this.toMutableResponse((HttpResponse)((Object)suspendedBody)) : this.forStatus(finalRoute, defaultHttpStatus).body(suspendedBody);
                } else {
                    outgoingResponse = body instanceof HttpResponse ? this.toMutableResponse((HttpResponse)body) : this.forStatus(finalRoute, defaultHttpStatus).body(body);
                }
                if (incomingRequest != null && incomingRequest.getMethod().equals(HttpMethod.HEAD)) {
                    Object o2 = outgoingResponse.getBody().orElse(null);
                    if (o2 instanceof ReferenceCounted) {
                        ((ReferenceCounted)o2).release();
                    }
                    outgoingResponse.body((Object)null);
                }
            }
            outgoingResponse.setAttribute(HttpAttributes.ROUTE_MATCH, finalRoute);
            subscriber.onNext((MutableHttpResponse<?>)outgoingResponse);
            subscriber.onComplete();
        }
        catch (Throwable e) {
            subscriber.onError(e);
        }
    }

    private void encodeHttpResponse(ChannelHandlerContext context, NettyHttpRequest<?> nettyRequest, MutableHttpResponse<?> response, Object body, Supplier<MediaType> defaultResponseMediaType) {
        boolean isNotHead;
        boolean bl = isNotHead = nettyRequest.getMethod() != HttpMethod.HEAD;
        if (isNotHead) {
            if (body instanceof Writable) {
                this.getIoExecutor().execute(() -> {
                    ByteBuf byteBuf = context.alloc().ioBuffer(128);
                    ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
                    try {
                        Writable writable = (Writable)body;
                        writable.writeTo(outputStream, nettyRequest.getCharacterEncoding());
                        response.body(byteBuf);
                        if (!response.getHeaders().contains("Content-Type")) {
                            response.header("Content-Type", (CharSequence)defaultResponseMediaType.get());
                        }
                        this.writeFinalNettyResponse(response, nettyRequest, context);
                    }
                    catch (IOException e) {
                        this.exceptionCaughtInternal(context, e, nettyRequest, false);
                    }
                });
            } else {
                this.encodeResponseBody(context, nettyRequest, response, body, defaultResponseMediaType);
                this.writeFinalNettyResponse(response, nettyRequest, context);
            }
        } else {
            response.body((Object)null);
            this.writeFinalNettyResponse(response, nettyRequest, context);
        }
    }

    @Nullable
    private RouteMatch<Object> findStatusRoute(HttpRequest<?> incomingRequest, HttpStatus status, RouteMatch<?> finalRoute) {
        Class<?> declaringType = this.getDeclaringType(finalRoute);
        RouteMatch statusRoute = null;
        if (declaringType != null) {
            statusRoute = this.router.findStatusRoute(declaringType, status, incomingRequest).orElseGet(() -> this.router.findStatusRoute(status, incomingRequest).orElse(null));
        }
        return statusRoute;
    }

    private void encodeResponseBody(ChannelHandlerContext context, HttpRequest<?> request, MutableHttpResponse<?> message, Object body, Supplier<MediaType> defaultResponseMediaType) {
        MediaType responseMediaType;
        if (body == null) {
            return;
        }
        MediaType specifiedMediaType = message.getContentType().orElse(null);
        MediaType mediaType = responseMediaType = specifiedMediaType != null ? specifiedMediaType : defaultResponseMediaType.get();
        if (body instanceof CharSequence) {
            ByteBuf byteBuf = Unpooled.wrappedBuffer(body.toString().getBytes(message.getCharacterEncoding()));
            this.setResponseBody(message, responseMediaType, byteBuf);
        } else if (body instanceof byte[]) {
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])body);
            this.setResponseBody(message, responseMediaType, byteBuf);
        } else if (body instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)body;
            Object nativeBuffer = byteBuffer.asNativeBuffer();
            if (nativeBuffer instanceof ByteBuf) {
                this.setResponseBody(message, responseMediaType, (ByteBuf)nativeBuffer);
            } else if (nativeBuffer instanceof java.nio.ByteBuffer) {
                ByteBuf byteBuf = Unpooled.wrappedBuffer((java.nio.ByteBuffer)nativeBuffer);
                this.setResponseBody(message, responseMediaType, byteBuf);
            }
        } else if (body instanceof ByteBuf) {
            this.setResponseBody(message, responseMediaType, (ByteBuf)body);
        } else {
            Optional<NettyCustomizableResponseTypeHandler> typeHandler = this.customizableResponseTypeHandlerRegistry.findTypeHandler(body.getClass());
            if (typeHandler.isPresent()) {
                NettyCustomizableResponseTypeHandler th = typeHandler.get();
                this.setBodyContent(message, new NettyCustomizableResponseTypeHandlerInvoker(th, body));
            } else if (specifiedMediaType != null) {
                Optional<MediaTypeCodec> registeredCodec = this.mediaTypeCodecRegistry.findCodec(responseMediaType, body.getClass());
                if (registeredCodec.isPresent()) {
                    MediaTypeCodec codec = registeredCodec.get();
                    if (!message.getHeaders().contains("Content-Type")) {
                        message.header("Content-Type", responseMediaType);
                    }
                    this.encodeBodyWithCodec(message, body, codec, responseMediaType, context, request);
                }
            } else {
                Optional<MediaTypeCodec> registeredCodec = this.mediaTypeCodecRegistry.findCodec(responseMediaType, body.getClass());
                if (registeredCodec.isPresent()) {
                    MediaTypeCodec codec = registeredCodec.get();
                    if (!message.getHeaders().contains("Content-Type")) {
                        message.header("Content-Type", responseMediaType);
                    }
                    this.encodeBodyWithCodec(message, body, codec, responseMediaType, context, request);
                } else {
                    if (!message.getHeaders().contains("Content-Type")) {
                        message.header("Content-Type", responseMediaType);
                    }
                    TextPlainCodec defaultCodec = new TextPlainCodec(this.serverConfiguration.getDefaultCharset());
                    this.encodeBodyWithCodec(message, body, defaultCodec, responseMediaType, context, request);
                }
            }
        }
    }

    @Nullable
    private Class<?> getDeclaringType(RouteMatch<?> route) {
        if (route instanceof MethodBasedRouteMatch) {
            return ((MethodBasedRouteMatch)route).getDeclaringType();
        }
        return null;
    }

    private MediaType resolveDefaultResponseContentType(NettyHttpRequest<?> request, RouteMatch<?> finalRoute) {
        MediaType mt;
        List<MediaType> producesList = finalRoute.getProduces();
        Iterator<MediaType> i = request.accept().iterator();
        if (i.hasNext() && producesList.contains(mt = i.next())) {
            return mt;
        }
        Iterator<MediaType> produces = producesList.iterator();
        MediaType defaultResponseMediaType = produces.hasNext() ? produces.next() : MediaType.APPLICATION_JSON_TYPE;
        return defaultResponseMediaType;
    }

    private void writeFinalNettyResponse(MutableHttpResponse<?> message, HttpRequest<?> request, final ChannelHandlerContext context) {
        HttpStatus httpStatus = message.status();
        HttpVersion httpVersion = request.getHttpVersion();
        boolean isHttp2 = httpVersion == HttpVersion.HTTP_2_0;
        Object body = message.body();
        if (body instanceof NettyCustomizableResponseTypeHandlerInvoker) {
            if (!isHttp2 && !message.getHeaders().contains("Connection")) {
                if (httpStatus.getCode() > 499) {
                    message.getHeaders().set("Connection", HttpHeaderValues.CLOSE);
                } else {
                    message.getHeaders().set("Connection", HttpHeaderValues.KEEP_ALIVE);
                }
            }
            NettyCustomizableResponseTypeHandlerInvoker handler = (NettyCustomizableResponseTypeHandlerInvoker)body;
            message.body((Object)null);
            handler.invoke(request, message, context);
        } else {
            final io.netty.handler.codec.http.HttpResponse nettyResponse = NettyHttpResponseBuilder.toHttpResponse(message);
            io.netty.handler.codec.http.HttpHeaders nettyHeaders = nettyResponse.headers();
            if (!isHttp2 && !nettyHeaders.contains(HttpHeaderNames.CONNECTION)) {
                boolean expectKeepAlive;
                boolean bl = expectKeepAlive = nettyResponse.protocolVersion().isKeepAliveDefault() || request.getHeaders().isKeepAlive();
                if (!expectKeepAlive || httpStatus.getCode() > 499) {
                    nettyHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                } else {
                    nettyHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                }
            }
            if (!nettyHeaders.contains(HttpHeaderNames.CONTENT_LENGTH) && !nettyHeaders.contains(HttpHeaderNames.TRANSFER_ENCODING)) {
                nettyHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            NettyHttpRequest nettyHttpRequest = (NettyHttpRequest)request;
            if (isHttp2) {
                this.addHttp2StreamHeader(request, nettyResponse);
            }
            io.netty.handler.codec.http.HttpRequest nativeRequest = nettyHttpRequest.getNativeRequest();
            final GenericFutureListener<Future> requestCompletor = future -> {
                try {
                    Throwable throwable;
                    if (!future.isSuccess() && !((throwable = future.cause()) instanceof ClosedChannelException)) {
                        Http2Exception.StreamException se;
                        if (throwable instanceof Http2Exception.StreamException && (se = (Http2Exception.StreamException)throwable).error() == Http2Error.STREAM_CLOSED) {
                            return;
                        }
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error writing final response: " + throwable.getMessage(), throwable);
                        }
                    }
                }
                finally {
                    this.cleanupRequest(context, nettyHttpRequest);
                    context.read();
                }
            };
            if (nativeRequest instanceof StreamedHttpRequest && !((StreamedHttpRequest)nativeRequest).isConsumed()) {
                StreamedHttpRequest streamedHttpRequest = (StreamedHttpRequest)nativeRequest;
                streamedHttpRequest.subscribe(new Subscriber<HttpContent>(){
                    private Subscription streamSub;

                    @Override
                    public void onSubscribe(Subscription s) {
                        this.streamSub = s;
                        s.request(1L);
                    }

                    @Override
                    public void onNext(HttpContent httpContent) {
                        httpContent.release();
                        this.streamSub.request(1L);
                    }

                    @Override
                    public void onError(Throwable t) {
                        context.writeAndFlush(nettyResponse).addListener(requestCompletor);
                    }

                    @Override
                    public void onComplete() {
                        context.writeAndFlush(nettyResponse).addListener(requestCompletor);
                    }
                });
            } else {
                context.writeAndFlush(nettyResponse).addListener((GenericFutureListener<? extends Future<? super Void>>)requestCompletor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response {} - {} {}", nettyResponse.status().code(), request.getMethodName(), request.getUri());
                }
            }
        }
    }

    private void addHttp2StreamHeader(HttpRequest<?> request, io.netty.handler.codec.http.HttpResponse nettyResponse) {
        String streamId = (String)request.getHeaders().get(AbstractNettyHttpRequest.STREAM_ID);
        if (streamId != null) {
            nettyResponse.headers().set((CharSequence)AbstractNettyHttpRequest.STREAM_ID, (Object)streamId);
        }
    }

    private MutableHttpResponse<?> toMutableResponse(HttpResponse<?> message) {
        MutableHttpResponse mutableHttpResponse;
        if (message instanceof MutableHttpResponse) {
            mutableHttpResponse = (MutableHttpResponse)message;
        } else {
            HttpStatus httpStatus = message.status();
            mutableHttpResponse = HttpResponse.status(httpStatus, httpStatus.getReason());
            mutableHttpResponse.body(message.body());
            message.getHeaders().forEach((name, value) -> {
                for (String val : value) {
                    mutableHttpResponse.header((CharSequence)name, val);
                }
            });
            mutableHttpResponse.getAttributes().putAll(message.getAttributes());
        }
        return mutableHttpResponse;
    }

    @NotNull
    private NettyMutableHttpResponse<?> toNettyResponse(HttpResponse<?> message) {
        NettyMutableHttpResponse nettyHttpResponse;
        if (message instanceof NettyMutableHttpResponse) {
            nettyHttpResponse = (NettyMutableHttpResponse)message;
        } else {
            HttpStatus httpStatus = message.status();
            Object body = message.body();
            DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(this.serverConfiguration.isValidateHeaders());
            message.getHeaders().forEach(nettyHeaders::set);
            nettyHttpResponse = new NettyMutableHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(httpStatus.getCode(), httpStatus.getReason()), body instanceof ByteBuf ? body : null, ConversionService.SHARED);
        }
        return nettyHttpResponse;
    }

    private MutableHttpResponse<?> encodeBodyWithCodec(MutableHttpResponse<?> response, Object body, MediaTypeCodec codec, MediaType mediaType, ChannelHandlerContext context, HttpRequest<?> request) {
        try {
            ByteBuf byteBuf = this.encodeBodyAsByteBuf(body, codec, context, request);
            this.setResponseBody(response, mediaType, byteBuf);
            return response;
        }
        catch (LinkageError e) {
            throw new InternalServerException("Fatal error encoding bytebuf: " + e.getMessage(), e);
        }
    }

    private void setResponseBody(MutableHttpResponse<?> response, MediaType mediaType, ByteBuf byteBuf) {
        int len = byteBuf.readableBytes();
        HttpHeaders headers = response.getHeaders();
        if (!headers.contains("Content-Type")) {
            headers.add(HttpHeaderNames.CONTENT_TYPE, mediaType);
        }
        headers.set(HttpHeaderNames.CONTENT_LENGTH, String.valueOf(len));
        this.setBodyContent(response, byteBuf);
    }

    private MutableHttpResponse<?> setBodyContent(MutableHttpResponse response, Object bodyContent) {
        MutableHttpMessage res = response.body(bodyContent);
        return res;
    }

    private ByteBuf encodeBodyAsByteBuf(Object body, MediaTypeCodec codec, ChannelHandlerContext context, HttpRequest<?> request) {
        ByteBuf byteBuf;
        if (body instanceof ByteBuf) {
            byteBuf = (ByteBuf)body;
        } else if (body instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)body;
            Object nativeBuffer = byteBuffer.asNativeBuffer();
            byteBuf = nativeBuffer instanceof ByteBuf ? (ByteBuf)nativeBuffer : Unpooled.wrappedBuffer(byteBuffer.asNioBuffer());
        } else if (body instanceof byte[]) {
            byteBuf = Unpooled.wrappedBuffer((byte[])body);
        } else if (body instanceof Writable) {
            byteBuf = context.alloc().ioBuffer(128);
            ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
            Writable writable = (Writable)body;
            try {
                writable.writeTo(outputStream, request.getCharacterEncoding());
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage());
                }
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Encoding emitted response object [{}] using codec: {}", body, (Object)codec);
            }
            byteBuf = codec.encode(body, new NettyByteBufferFactory(context.alloc())).asNativeBuffer();
        }
        return byteBuf;
    }

    private MutableHttpResponse<Object> forStatus(RouteMatch routeMatch) {
        return this.forStatus(routeMatch, HttpStatus.OK);
    }

    private MutableHttpResponse<Object> forStatus(RouteMatch routeMatch, HttpStatus defaultStatus) {
        HttpStatus status = routeMatch.findStatus(defaultStatus);
        return new NettyMutableHttpResponse<Object>(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(status.getCode()), ConversionService.SHARED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Publisher<MutableHttpResponse<?>> filterPublisher(final AtomicReference<HttpRequest<?>> requestReference, final Publisher<MutableHttpResponse<?>> upstreamResponsePublisher, boolean skipOncePerRequest) {
        List<HttpFilter> httpFilters = this.router.findFilters(requestReference.get());
        if (httpFilters.isEmpty()) {
            return upstreamResponsePublisher;
        }
        final ArrayList<HttpFilter> filters = new ArrayList<HttpFilter>(httpFilters);
        if (skipOncePerRequest) {
            filters.removeIf(filter -> filter instanceof OncePerRequestHttpServerFilter);
        }
        if (filters.isEmpty()) {
            return upstreamResponsePublisher;
        }
        final AtomicInteger integer = new AtomicInteger();
        final int len = filters.size();
        ServerFilterChain filterChain = new ServerFilterChain(){

            @Override
            public Publisher<MutableHttpResponse<?>> proceed(HttpRequest<?> request) {
                int pos = integer.incrementAndGet();
                if (pos > len) {
                    throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
                }
                if (pos == len) {
                    return upstreamResponsePublisher;
                }
                HttpFilter httpFilter = (HttpFilter)filters.get(pos);
                return httpFilter.doFilter(requestReference.getAndSet(request), this);
            }
        };
        Optional prevRequest = ServerRequestContext.currentRequest();
        try {
            ServerRequestContext.set(requestReference.get());
            HttpFilter httpFilter = (HttpFilter)filters.get(0);
            Publisher<? extends HttpResponse<?>> publisher = httpFilter.doFilter(requestReference.get(), filterChain);
            return publisher;
        }
        finally {
            if (prevRequest.isPresent()) {
                ServerRequestContext.set(prevRequest.get());
            } else {
                ServerRequestContext.set(null);
            }
        }
    }

    private <T> Publisher<T> applyExecutorToPublisher(Publisher<T> publisher, @Nullable ExecutorService executor) {
        if (executor != null) {
            Scheduler scheduler = Schedulers.from(executor);
            return this.publisherToFlowable(publisher).subscribeOn(scheduler).observeOn(scheduler);
        }
        return publisher;
    }

    private <T> Flowable<T> publisherToFlowable(Publisher<T> publisher) {
        if (publisher instanceof Flowable) {
            return (Flowable)publisher;
        }
        return Flowable.fromPublisher(publisher);
    }

    private void writeDefaultErrorResponse(ChannelHandlerContext ctx, NettyHttpRequest nettyHttpRequest, Throwable cause, boolean skipOncePerRequest) {
        this.logException(cause);
        MutableHttpResponse<?> response = this.errorResponseProcessor.processResponse(ErrorContext.builder(nettyHttpRequest).cause(cause).errorMessage("Internal Server Error: " + cause.getMessage()).build(), HttpResponse.serverError());
        this.filterAndEncodeResponse(ctx, nettyHttpRequest, nettyHttpRequest, response, MediaType.APPLICATION_JSON_TYPE, skipOncePerRequest);
    }

    private void logException(Throwable cause) {
        if (this.isIgnorable(cause)) {
            this.logIgnoredException(cause);
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Unexpected error occurred: " + cause.getMessage(), cause);
        }
    }

    private boolean isIgnorable(Throwable cause) {
        String message = cause.getMessage();
        return cause instanceof IOException && message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches();
    }

    private void logIgnoredException(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Swallowed an IOException caused by client connectivity: " + cause.getMessage(), cause);
        }
    }

    private void applyConfiguredHeaders(MutableHttpHeaders headers) {
        if (this.serverConfiguration.isDateHeader() && !headers.contains("Date")) {
            headers.date(LocalDateTime.now());
        }
        if (this.serverHeader != null && !headers.contains("Server")) {
            headers.add((CharSequence)"Server", this.serverHeader);
        }
    }

    private static class NettyCustomizableResponseTypeHandlerInvoker {
        final NettyCustomizableResponseTypeHandler handler;
        final Object body;

        NettyCustomizableResponseTypeHandlerInvoker(NettyCustomizableResponseTypeHandler handler, Object body) {
            this.handler = handler;
            this.body = body;
        }

        void invoke(HttpRequest<?> request, MutableHttpResponse response, ChannelHandlerContext channelHandlerContext) {
            this.handler.handle(this.body, request, response, channelHandlerContext);
        }
    }
}

