/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.binders.PublisherBodyBinder;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Internal
public class SingleBodyBinder
extends DefaultBodyAnnotationBinder<Single>
implements NonBlockingBodyArgumentBinder<Single> {
    public static final Argument<Single> TYPE = Argument.of(Single.class);
    private PublisherBodyBinder publisherBodyBinder;

    public SingleBodyBinder(ConversionService conversionService, HttpContentProcessorResolver httpContentProcessorResolver) {
        super(conversionService);
        this.publisherBodyBinder = new PublisherBodyBinder(conversionService, httpContentProcessorResolver);
    }

    @Override
    @NonNull
    public List<Class<?>> superTypes() {
        return Collections.singletonList(SingleSource.class);
    }

    @Override
    @Deprecated
    public boolean supportsSuperTypes() {
        return false;
    }

    @Override
    public Argument<Single> argumentType() {
        return TYPE;
    }

    @Override
    public ArgumentBinder.BindingResult<Single> bind(ArgumentConversionContext<Single> context, HttpRequest<?> source) {
        Collection<Argument<?>> typeVariables = context.getArgument().getTypeVariables().values();
        ArgumentBinder.BindingResult<Publisher> result = this.publisherBodyBinder.bind(ConversionContext.of(Argument.of(Publisher.class, typeVariables.toArray(Argument.ZERO_ARGUMENTS))), source);
        if (result.isPresentAndSatisfied()) {
            return () -> Optional.of(Single.fromPublisher((Publisher)result.get()));
        }
        return ArgumentBinder.BindingResult.EMPTY;
    }
}

