/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.configuration;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.format.ReadableBytes;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.netty.channel.ChannelPipelineListener;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import io.netty.channel.ChannelOption;
import io.netty.handler.logging.LogLevel;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

@ConfigurationProperties(value="netty")
@Replaces(value=HttpServerConfiguration.class)
public class NettyHttpServerConfiguration
extends HttpServerConfiguration {
    public static final boolean DEFAULT_USE_NATIVE_TRANSPORT = false;
    public static final int DEFAULT_MAXINITIALLINELENGTH = 4096;
    public static final int DEFAULT_MAXHEADERSIZE = 8192;
    public static final int DEFAULT_MAXCHUNKSIZE = 8192;
    public static final boolean DEFAULT_CHUNKSUPPORTED = true;
    public static final boolean DEFAULT_VALIDATEHEADERS = true;
    public static final int DEFAULT_INITIALBUFFERSIZE = 128;
    public static final int DEFAULT_COMPRESSIONTHRESHOLD = 1024;
    public static final int DEFAULT_COMPRESSIONLEVEL = 6;
    private final List<ChannelPipelineListener> pipelineCustomizers;
    private Map<ChannelOption, Object> childOptions = Collections.emptyMap();
    private Map<ChannelOption, Object> options = Collections.emptyMap();
    private Worker worker;
    private Parent parent;
    private int maxInitialLineLength = 4096;
    private int maxHeaderSize = 8192;
    private int maxChunkSize = 8192;
    private boolean chunkedSupported = true;
    private boolean validateHeaders = true;
    private int initialBufferSize = 128;
    private LogLevel logLevel;
    private int compressionThreshold = 1024;
    private int compressionLevel = 6;
    private boolean useNativeTransport = false;
    private String fallbackProtocol = "http/1.1";
    private AccessLogger accessLogger;
    private Http2Settings http2Settings = new Http2Settings();

    public NettyHttpServerConfiguration() {
        this(null, Collections.emptyList());
    }

    public NettyHttpServerConfiguration(ApplicationConfiguration applicationConfiguration) {
        this(applicationConfiguration, Collections.emptyList());
    }

    @Inject
    public NettyHttpServerConfiguration(ApplicationConfiguration applicationConfiguration, List<ChannelPipelineListener> pipelineCustomizers) {
        super(applicationConfiguration);
        this.pipelineCustomizers = pipelineCustomizers;
    }

    public AccessLogger getAccessLogger() {
        return this.accessLogger;
    }

    public void setAccessLogger(AccessLogger accessLogger) {
        this.accessLogger = accessLogger;
    }

    public Http2Settings getHttp2() {
        return this.http2Settings;
    }

    public void setHttp2(Http2Settings http2) {
        if (http2 != null) {
            this.http2Settings = http2;
        }
    }

    public List<ChannelPipelineListener> getPipelineCustomizers() {
        return this.pipelineCustomizers;
    }

    public String getFallbackProtocol() {
        return this.fallbackProtocol;
    }

    public void setFallbackProtocol(String fallbackProtocol) {
        if (fallbackProtocol != null) {
            this.fallbackProtocol = fallbackProtocol;
        }
    }

    public Optional<LogLevel> getLogLevel() {
        return Optional.ofNullable(this.logLevel);
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public boolean isChunkedSupported() {
        return this.chunkedSupported;
    }

    public boolean isUseNativeTransport() {
        return this.useNativeTransport;
    }

    public boolean isValidateHeaders() {
        return this.validateHeaders;
    }

    public int getInitialBufferSize() {
        return this.initialBufferSize;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public Map<ChannelOption, Object> getChildOptions() {
        return this.childOptions;
    }

    public Map<ChannelOption, Object> getOptions() {
        return this.options;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public Parent getParent() {
        return this.parent;
    }

    public void setChildOptions(Map<ChannelOption, Object> childOptions) {
        this.childOptions = childOptions;
    }

    public void setOptions(Map<ChannelOption, Object> options) {
        this.options = options;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public void setParent(Parent parent) {
        this.parent = parent;
    }

    public void setMaxInitialLineLength(@ReadableBytes int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
    }

    public void setMaxHeaderSize(@ReadableBytes int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
    }

    public void setMaxChunkSize(@ReadableBytes int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public void setChunkedSupported(boolean chunkedSupported) {
        this.chunkedSupported = chunkedSupported;
    }

    public void setUseNativeTransport(boolean useNativeTransport) {
        this.useNativeTransport = useNativeTransport;
    }

    public void setValidateHeaders(boolean validateHeaders) {
        this.validateHeaders = validateHeaders;
    }

    public void setInitialBufferSize(int initialBufferSize) {
        this.initialBufferSize = initialBufferSize;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setCompressionThreshold(@ReadableBytes int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    public void setCompressionLevel(@ReadableBytes int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public static abstract class EventLoopConfig
    implements EventLoopGroupConfiguration {
        private int threads;
        private Integer ioRatio;
        private String executor;
        private boolean preferNativeTransport = false;
        private Duration shutdownQuietPeriod = Duration.ofSeconds(2L);
        private Duration shutdownTimeout = Duration.ofSeconds(15L);
        private String name;

        EventLoopConfig(String name) {
            this.name = name;
        }

        @Override
        @NonNull
        public String getName() {
            return this.name;
        }

        public void setEventLoopGroup(String name) {
            if (StringUtils.isNotEmpty(name)) {
                this.name = name;
            }
        }

        public void setThreads(int threads) {
            this.threads = threads;
        }

        public void setIoRatio(Integer ioRatio) {
            this.ioRatio = ioRatio;
        }

        public void setExecutor(String executor) {
            this.executor = executor;
        }

        public void setPreferNativeTransport(boolean preferNativeTransport) {
            this.preferNativeTransport = preferNativeTransport;
        }

        public void setShutdownQuietPeriod(Duration shutdownQuietPeriod) {
            if (shutdownQuietPeriod != null) {
                this.shutdownQuietPeriod = shutdownQuietPeriod;
            }
        }

        public void setShutdownTimeout(Duration shutdownTimeout) {
            if (shutdownTimeout != null) {
                this.shutdownTimeout = shutdownTimeout;
            }
        }

        public int getNumOfThreads() {
            return this.threads;
        }

        @Override
        public Optional<Integer> getIoRatio() {
            if (this.ioRatio != null) {
                return Optional.of(this.ioRatio);
            }
            return Optional.empty();
        }

        @Override
        public Optional<String> getExecutorName() {
            if (this.executor != null) {
                return Optional.of(this.executor);
            }
            return Optional.empty();
        }

        @Override
        public int getNumThreads() {
            return this.threads;
        }

        @Override
        public boolean isPreferNativeTransport() {
            return this.preferNativeTransport;
        }

        @Override
        public Duration getShutdownQuietPeriod() {
            return this.shutdownQuietPeriod;
        }

        @Override
        public Duration getShutdownTimeout() {
            return this.shutdownTimeout;
        }
    }

    @ConfigurationProperties(value="parent")
    @Requires(missingProperty="micronaut.netty.event-loops.parent")
    public static class Parent
    extends EventLoopConfig {
        public static final String NAME = "parent";

        Parent() {
            super(NAME);
        }
    }

    @ConfigurationProperties(value="worker")
    public static class Worker
    extends EventLoopConfig {
        Worker() {
            super("default");
        }
    }

    @ConfigurationProperties(value="access-logger")
    public static class AccessLogger {
        private boolean enabled;
        private String loggerName;
        private String logFormat;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public void setLoggerName(String loggerName) {
            this.loggerName = loggerName;
        }

        public String getLogFormat() {
            return this.logFormat;
        }

        public void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }
    }

    @ConfigurationProperties(value="http2")
    public static class Http2Settings {
        private final io.netty.handler.codec.http2.Http2Settings settings = io.netty.handler.codec.http2.Http2Settings.defaultSettings();

        public io.netty.handler.codec.http2.Http2Settings http2Settings() {
            return this.settings;
        }

        public Long getHeaderTableSize() {
            return this.settings.headerTableSize();
        }

        public void setHeaderTableSize(Long value) {
            if (value != null) {
                this.settings.headerTableSize(value);
            }
        }

        public Boolean getPushEnabled() {
            return this.settings.pushEnabled();
        }

        public void setPushEnabled(Boolean enabled) {
            if (enabled != null) {
                this.settings.pushEnabled(enabled);
            }
        }

        public Long getMaxConcurrentStreams() {
            return this.settings.maxConcurrentStreams();
        }

        public void setMaxConcurrentStreams(Long value) {
            if (value != null) {
                this.settings.maxConcurrentStreams(value);
            }
        }

        public Integer getInitialWindowSize() {
            return this.settings.initialWindowSize();
        }

        public void setInitialWindowSize(Integer value) {
            if (value != null) {
                this.settings.initialWindowSize(value);
            }
        }

        public Integer getMaxFrameSize() {
            return this.settings.maxFrameSize();
        }

        public void setMaxFrameSize(Integer value) {
            if (value != null) {
                this.settings.maxFrameSize(value);
            }
        }

        public Long getMaxHeaderListSize() {
            return this.settings.maxHeaderListSize();
        }

        public void setMaxHeaderListSize(Long value) {
            if (value != null) {
                this.settings.maxHeaderListSize(value);
            }
        }
    }
}

