/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.http.server.netty.handler.accesslog.element.AbstractHttpMessageLogElement;
import io.micronaut.http.server.netty.handler.accesslog.element.LogElement;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.List;
import java.util.StringJoiner;

final class HeaderElement
extends AbstractHttpMessageLogElement {
    public static final String REQUEST_HEADER = "i";
    public static final String RESPONSE_HEADER = "o";
    private final String header;

    HeaderElement(boolean onRequest, String header) {
        this.header = header;
        this.events = onRequest ? LogElement.Event.REQUEST_HEADERS_EVENTS : LogElement.Event.RESPONSE_HEADERS_EVENTS;
    }

    @Override
    protected String value(HttpHeaders headers) {
        List<String> values = headers.getAllAsString(this.header);
        if (values.isEmpty()) {
            return "-";
        }
        if (values.size() == 1) {
            return values.iterator().next();
        }
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        for (String v : values) {
            joiner.add(v);
        }
        return joiner.toString();
    }

    public String toString() {
        return "%{" + this.header + '}' + (this.events.contains((Object)LogElement.Event.ON_REQUEST_HEADERS) ? REQUEST_HEADER : RESPONSE_HEADER);
    }
}

