/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentSubscriberFactory;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.jackson.JsonContentProcessor;
import javax.inject.Singleton;

@Consumes(value={"application/x-json-stream", "application/json"})
@Singleton
@Internal
public class JsonHttpContentSubscriberFactory
implements HttpContentSubscriberFactory {
    private final HttpServerConfiguration httpServerConfiguration;
    @Nullable
    private final JsonFactory jsonFactory;
    private final DeserializationConfig deserializationConfig;

    public JsonHttpContentSubscriberFactory(ObjectMapper objectMapper, HttpServerConfiguration httpServerConfiguration, @Nullable JsonFactory jsonFactory) {
        ArgumentUtils.requireNonNull("objectMapper", objectMapper);
        this.httpServerConfiguration = httpServerConfiguration;
        this.jsonFactory = jsonFactory;
        this.deserializationConfig = objectMapper.getDeserializationConfig();
    }

    @Override
    public HttpContentProcessor build(NettyHttpRequest request) {
        return new JsonContentProcessor(request, this.httpServerConfiguration, this.jsonFactory, this.deserializationConfig);
    }
}

