/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.websocket;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.websocket.NettyServerWebSocketHandler;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.annotation.OnOpen;
import io.micronaut.websocket.annotation.ServerWebSocket;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class NettyServerWebSocketUpgradeHandler
extends SimpleChannelInboundHandler<NettyHttpRequest<?>> {
    public static final String ID = "websocket-upgrade-handler";
    public static final String SCHEME_WEBSOCKET = "ws://";
    public static final String SCHEME_SECURE_WEBSOCKET = "wss://";
    private static final Logger LOG = LoggerFactory.getLogger(NettyServerWebSocketUpgradeHandler.class);
    private static final AsciiString WEB_SOCKET_HEADER_VALUE = AsciiString.cached("websocket");
    private final Router router;
    private final RequestBinderRegistry binderRegistry;
    private final WebSocketBeanRegistry webSocketBeanRegistry;
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final WebSocketSessionRepository webSocketSessionRepository;
    private final ApplicationEventPublisher eventPublisher;
    private WebSocketServerHandshaker handshaker;

    public NettyServerWebSocketUpgradeHandler(WebSocketSessionRepository webSocketSessionRepository, Router router, RequestBinderRegistry binderRegistry, WebSocketBeanRegistry webSocketBeanRegistry, MediaTypeCodecRegistry mediaTypeCodecRegistry, ApplicationEventPublisher eventPublisher) {
        this.router = router;
        this.binderRegistry = binderRegistry;
        this.webSocketBeanRegistry = webSocketBeanRegistry;
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.webSocketSessionRepository = webSocketSessionRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public boolean acceptInboundMessage(Object msg) {
        NettyHttpRequest request;
        if (msg instanceof NettyHttpRequest && (request = (NettyHttpRequest)msg).getNativeRequest().headers().contains((CharSequence)HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.UPGRADE, true)) {
            return request.getNativeRequest().headers().containsValue(HttpHeaderNames.UPGRADE, WEB_SOCKET_HEADER_VALUE, true);
        }
        return false;
    }

    @Override
    protected final void channelRead0(ChannelHandlerContext ctx, NettyHttpRequest<?> msg) {
        Optional<UriRouteMatch> routeMatch = this.router.find(HttpMethod.GET, msg.getUri().toString(), msg).filter(rm -> rm.isAnnotationPresent(OnMessage.class) || rm.isAnnotationPresent(OnOpen.class)).findFirst();
        if (routeMatch.isPresent()) {
            Publisher<Object> finalPublisher;
            UriRouteMatch rm2 = routeMatch.get();
            msg.setAttribute(HttpAttributes.ROUTE_MATCH, rm2);
            List<HttpFilter> filters = this.router.findFilters(msg);
            final AtomicReference requestReference = new AtomicReference(msg);
            MutableHttpResponse proceed = HttpResponse.ok();
            Flowable routePublisher = Flowable.create(emitter -> {
                emitter.onNext(proceed);
                emitter.onComplete();
            }, BackpressureStrategy.ERROR);
            if (!filters.isEmpty()) {
                filters = new ArrayList<HttpFilter>(filters);
                filters.add((req, chain) -> routePublisher);
                final AtomicInteger integer = new AtomicInteger();
                final int len = filters.size();
                final List<HttpFilter> finalFilters = filters;
                ServerFilterChain filterChain = new ServerFilterChain(){

                    @Override
                    public Publisher<MutableHttpResponse<?>> proceed(HttpRequest<?> request) {
                        int pos = integer.incrementAndGet();
                        if (pos > len) {
                            throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
                        }
                        HttpFilter httpFilter = (HttpFilter)finalFilters.get(pos);
                        return httpFilter.doFilter(requestReference.getAndSet(request), this);
                    }
                };
                HttpFilter httpFilter = filters.get(0);
                Publisher<? extends HttpResponse<?>> resultingPublisher = httpFilter.doFilter((HttpRequest)requestReference.get(), filterChain);
                finalPublisher = resultingPublisher;
            } else {
                finalPublisher = routePublisher;
            }
            Channel channel = ctx.channel();
            Single.fromPublisher(finalPublisher).subscribeOn(Schedulers.from(channel.eventLoop())).subscribe((actualResponse, throwable) -> {
                if (throwable != null) {
                    ctx.fireExceptionCaught((Throwable)throwable);
                } else if (actualResponse == proceed) {
                    WebSocketBean<?> webSocketBean = this.webSocketBeanRegistry.getWebSocket(rm2.getTarget().getClass());
                    this.handleHandshake(ctx, msg, webSocketBean, (MutableHttpResponse<?>)actualResponse);
                    ChannelPipeline pipeline = ctx.pipeline();
                    try {
                        pipeline.remove("http-streams-codec");
                        pipeline.remove(this);
                        ChannelHandler accessLoggerHandler = pipeline.get("http-access-logger");
                        if (accessLoggerHandler != null) {
                            pipeline.remove(accessLoggerHandler);
                        }
                        NettyServerWebSocketHandler webSocketHandler = new NettyServerWebSocketHandler(this.webSocketSessionRepository, this.handshaker, msg, rm2, webSocketBean, this.binderRegistry, this.mediaTypeCodecRegistry, this.eventPublisher, ctx);
                        pipeline.addAfter("wsdecoder", "websocket-handler", webSocketHandler);
                    }
                    catch (Throwable e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error opening WebSocket: " + e.getMessage(), e);
                        }
                        ctx.writeAndFlush(new CloseWebSocketFrame(CloseReason.INTERNAL_ERROR.getCode(), CloseReason.INTERNAL_ERROR.getReason()));
                    }
                } else {
                    ctx.writeAndFlush(actualResponse);
                }
            });
        } else {
            ctx.fireExceptionCaught(new HttpStatusException(HttpStatus.NOT_FOUND, "WebSocket Not Found"));
        }
    }

    protected ChannelFuture handleHandshake(ChannelHandlerContext ctx, NettyHttpRequest req, WebSocketBean<?> webSocketBean, MutableHttpResponse<?> response) {
        io.netty.handler.codec.http.HttpHeaders nettyHeaders;
        int maxFramePayloadLength = webSocketBean.messageMethod().map(m -> m.intValue(OnMessage.class, "maxPayloadLength").orElse(65536)).orElse(65536);
        String subprotocols = webSocketBean.getBeanDefinition().stringValue(ServerWebSocket.class, "subprotocols").filter(s -> !StringUtils.isEmpty(s)).orElse(null);
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(ctx, req), subprotocols, true, maxFramePayloadLength);
        this.handshaker = wsFactory.newHandshaker(req.getNativeRequest());
        HttpHeaders headers = response.getHeaders();
        if (headers instanceof NettyHttpHeaders) {
            nettyHeaders = ((NettyHttpHeaders)headers).getNettyHeaders();
        } else {
            nettyHeaders = new DefaultHttpHeaders();
            for (Map.Entry entry : headers) {
                nettyHeaders.add(entry.getKey(), (Iterable)entry.getValue());
            }
        }
        Channel channel = ctx.channel();
        if (this.handshaker == null) {
            return WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel);
        }
        return this.handshaker.handshake(channel, req.getNativeRequest(), nettyHeaders, channel.newPromise());
    }

    protected String getWebSocketURL(ChannelHandlerContext ctx, HttpRequest req) {
        boolean isSecure = ctx.pipeline().get(SslHandler.class) != null;
        return (isSecure ? SCHEME_SECURE_WEBSOCKET : SCHEME_WEBSOCKET) + (String)req.getHeaders().get(HttpHeaderNames.HOST) + req.getUri();
    }
}

