/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Internal
abstract class AbstractAnnotationMetadata
implements AnnotationMetadata {
    protected final Map<String, Annotation> annotationMap;
    protected final Map<String, Annotation> declaredAnnotationMap;
    private Annotation[] allAnnotationArray;
    private Annotation[] declaredAnnotationArray;

    protected AbstractAnnotationMetadata(@Nullable Map<String, Map<CharSequence, Object>> declaredAnnotations, @Nullable Map<String, Map<CharSequence, Object>> allAnnotations) {
        this.declaredAnnotationMap = declaredAnnotations != null ? new ConcurrentHashMap(declaredAnnotations.size()) : null;
        this.annotationMap = allAnnotations != null ? new ConcurrentHashMap(allAnnotations.size()) : null;
    }

    protected AbstractAnnotationMetadata() {
        this.annotationMap = new ConcurrentHashMap<String, Annotation>(2);
        this.declaredAnnotationMap = new ConcurrentHashMap<String, Annotation>(2);
    }

    @Override
    @Nullable
    public <T extends Annotation> T synthesize(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        if (this.annotationMap == null) {
            return null;
        }
        if (this.hasAnnotation(annotationClass) || this.hasStereotype((Class<? extends Annotation>)annotationClass)) {
            String annotationName = annotationClass.getName();
            return (T)this.annotationMap.computeIfAbsent(annotationName, s -> {
                AnnotationValue annotationValue = this.findAnnotation(annotationClass).orElse(null);
                return AnnotationMetadataSupport.buildAnnotation(annotationClass, annotationValue);
            });
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends Annotation> T synthesizeDeclared(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        if (this.declaredAnnotationMap == null) {
            return null;
        }
        String annotationName = annotationClass.getName();
        if (this.hasAnnotation(annotationName) || this.hasStereotype(annotationName)) {
            return (T)this.declaredAnnotationMap.computeIfAbsent(annotationName, s -> {
                AnnotationValue annotationValue = this.findAnnotation(annotationClass).orElse(null);
                return AnnotationMetadataSupport.buildAnnotation(annotationClass, annotationValue);
            });
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Annotation[] synthesizeAll() {
        if (this.annotationMap == null) {
            return AnnotationUtil.ZERO_ANNOTATIONS;
        }
        Annotation[] annotations = this.allAnnotationArray;
        if (annotations == null) {
            AbstractAnnotationMetadata abstractAnnotationMetadata = this;
            synchronized (abstractAnnotationMetadata) {
                annotations = this.allAnnotationArray;
                if (annotations == null) {
                    annotations = this.initializeAnnotations(this.getAnnotationNames());
                    this.allAnnotationArray = annotations;
                }
            }
        }
        return annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Annotation[] synthesizeDeclared() {
        if (this.declaredAnnotationMap == null) {
            return AnnotationUtil.ZERO_ANNOTATIONS;
        }
        Annotation[] annotations = this.declaredAnnotationArray;
        if (annotations == null) {
            AbstractAnnotationMetadata abstractAnnotationMetadata = this;
            synchronized (abstractAnnotationMetadata) {
                annotations = this.declaredAnnotationArray;
                if (annotations == null) {
                    annotations = this.initializeAnnotations(this.getDeclaredAnnotationNames());
                    this.declaredAnnotationArray = annotations;
                }
            }
        }
        return annotations;
    }

    protected final void addAnnotationValuesFromData(List results, Map<CharSequence, Object> values) {
        block2: {
            Object v;
            block3: {
                AnnotationValue[] avs;
                if (values == null) break block2;
                v = values.get("value");
                if (!(v instanceof AnnotationValue[])) break block3;
                for (AnnotationValue av : avs = (AnnotationValue[])v) {
                    this.addValuesToResults(results, av);
                }
                break block2;
            }
            if (!(v instanceof Collection)) break block2;
            Collection c = (Collection)v;
            for (Object o : c) {
                if (!(o instanceof AnnotationValue)) continue;
                this.addValuesToResults(results, (AnnotationValue)o);
            }
        }
    }

    protected void addValuesToResults(List<AnnotationValue> results, AnnotationValue values) {
        results.add(values);
    }

    private Annotation[] initializeAnnotations(Set<String> names) {
        if (CollectionUtils.isNotEmpty(names)) {
            ArrayList annotations = new ArrayList();
            for (String name : names) {
                Optional<Class> loaded = ClassUtils.forName(name, this.getClass().getClassLoader());
                loaded.ifPresent(aClass -> {
                    Object ann = this.synthesize((Class)aClass);
                    if (ann != null) {
                        annotations.add(ann);
                    }
                });
            }
            return annotations.toArray(new Annotation[0]);
        }
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }
}

