/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.visitor;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Collections;
import java.util.Set;

public interface TypeElementVisitor<C, E>
extends Ordered,
Toggleable {
    default public void visitClass(ClassElement element, VisitorContext context) {
    }

    default public void visitMethod(MethodElement element, VisitorContext context) {
    }

    default public void visitConstructor(ConstructorElement element, VisitorContext context) {
    }

    default public void visitField(FieldElement element, VisitorContext context) {
    }

    default public void start(VisitorContext visitorContext) {
    }

    default public void finish(VisitorContext visitorContext) {
    }

    default public Set<String> getSupportedAnnotationNames() {
        Class[] classes = GenericTypeUtils.resolveInterfaceTypeArguments(this.getClass(), TypeElementVisitor.class);
        if (classes.length == 2) {
            Class classType = classes[0];
            if (classType == Object.class) {
                return Collections.singleton("*");
            }
            Class methodType = classes[1];
            if (methodType != Object.class) {
                return CollectionUtils.setOf(classType.getName(), methodType.getName());
            }
            return CollectionUtils.setOf(classType.getName());
        }
        return Collections.singleton("*");
    }

    default public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @NonNull
    default public VisitorKind getVisitorKind() {
        return VisitorKind.AGGREGATING;
    }

    public static enum VisitorKind {
        ISOLATING,
        AGGREGATING;

    }
}

