/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.bind;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.BeanPropertyBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.jackson.JacksonConfiguration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
@Primary
public class JacksonBeanPropertyBinder
implements BeanPropertyBinder {
    private final ObjectMapper objectMapper;
    private final int arraySizeThreshhold;

    public JacksonBeanPropertyBinder(ObjectMapper objectMapper, JacksonConfiguration configuration) {
        this.objectMapper = objectMapper;
        this.arraySizeThreshhold = configuration.getArraySizeThreshold();
    }

    @Override
    public ArgumentBinder.BindingResult<Object> bind(final ArgumentConversionContext<Object> context, Map<CharSequence, ? super Object> source) {
        try {
            ObjectNode objectNode = this.buildSourceObjectNode(source.entrySet());
            JsonParser jsonParser = this.objectMapper.treeAsTokens(objectNode);
            TypeFactory typeFactory = this.objectMapper.getTypeFactory();
            JavaType javaType = JacksonConfiguration.constructType(context.getArgument(), typeFactory);
            Object result = this.objectMapper.readValue(jsonParser, javaType);
            return () -> Optional.of(result);
        }
        catch (Exception e) {
            context.reject(e);
            return new ArgumentBinder.BindingResult<Object>(){

                @Override
                public List<ConversionError> getConversionErrors() {
                    return CollectionUtils.iterableToList(context);
                }

                @Override
                public boolean isSatisfied() {
                    return false;
                }

                @Override
                public Optional<Object> getValue() {
                    return Optional.empty();
                }
            };
        }
    }

    @Override
    public <T2> T2 bind(Class<T2> type, Set<? extends Map.Entry<? extends CharSequence, Object>> source) throws ConversionErrorException {
        try {
            ObjectNode objectNode = this.buildSourceObjectNode(source);
            return this.objectMapper.treeToValue(objectNode, type);
        }
        catch (Exception e) {
            throw this.newConversionError(null, e);
        }
    }

    @Override
    public <T2> T2 bind(T2 object, ArgumentConversionContext<T2> context, Set<? extends Map.Entry<? extends CharSequence, Object>> source) {
        try {
            ObjectNode objectNode = this.buildSourceObjectNode(source);
            this.objectMapper.readerForUpdating(object).readValue(objectNode);
        }
        catch (Exception e) {
            context.reject(e);
        }
        return object;
    }

    @Override
    public <T2> T2 bind(T2 object, Set<? extends Map.Entry<? extends CharSequence, Object>> source) throws ConversionErrorException {
        try {
            ObjectNode objectNode = this.buildSourceObjectNode(source);
            return (T2)this.objectMapper.readerForUpdating(object).readValue(objectNode);
        }
        catch (Exception e) {
            throw this.newConversionError(object, e);
        }
    }

    protected ConversionErrorException newConversionError(Object object, final Exception e) {
        if (e instanceof InvalidFormatException) {
            InvalidFormatException ife = (InvalidFormatException)e;
            final Object originalValue = ife.getValue();
            ConversionError conversionError = new ConversionError(){

                @Override
                public Exception getCause() {
                    return e;
                }

                @Override
                public Optional<Object> getOriginalValue() {
                    return Optional.ofNullable(originalValue);
                }
            };
            Class type = object != null ? object.getClass() : Object.class;
            List<JsonMappingException.Reference> path = ife.getPath();
            String name = !path.isEmpty() ? path.get(path.size() - 1).getFieldName() : NameUtils.decapitalize(type.getSimpleName());
            return new ConversionErrorException(Argument.of(ife.getTargetType(), name), conversionError);
        }
        ConversionError conversionError = new ConversionError(){

            @Override
            public Exception getCause() {
                return e;
            }

            @Override
            public Optional<Object> getOriginalValue() {
                return Optional.empty();
            }
        };
        Class type = object != null ? object.getClass() : Object.class;
        return new ConversionErrorException(Argument.of(type), conversionError);
    }

    private ObjectNode buildSourceObjectNode(Set<? extends Map.Entry<? extends CharSequence, Object>> source) {
        JsonNodeFactory nodeFactory = this.objectMapper.getNodeFactory();
        ObjectNode rootNode = new ObjectNode(nodeFactory);
        for (Map.Entry<? extends CharSequence, Object> entry : source) {
            CharSequence key = entry.getKey();
            Object value = entry.getValue();
            String property = key.toString();
            JsonNode current = rootNode;
            String index = null;
            Iterator<String> tokenIterator = StringUtils.splitOmitEmptyStringsIterator(property, '.');
            while (tokenIterator.hasNext()) {
                JsonNode jsonNode;
                ArrayNode arrayNode;
                ObjectNode objectNode;
                String token = tokenIterator.next();
                int j = token.indexOf(91);
                if (j > -1 && token.endsWith("]")) {
                    index = token.substring(j + 1, token.length() - 1);
                    token = token.substring(0, j);
                }
                if (!tokenIterator.hasNext()) {
                    if (current instanceof ObjectNode) {
                        objectNode = current;
                        if (index != null) {
                            JsonNode existing = objectNode.get(index);
                            if (!(existing instanceof ObjectNode)) {
                                existing = new ObjectNode(nodeFactory);
                                objectNode.set(index, existing);
                            }
                            ObjectNode node = (ObjectNode)existing;
                            node.set(token, (JsonNode)this.objectMapper.valueToTree(value));
                            index = null;
                            continue;
                        }
                        objectNode.set(token, (JsonNode)this.objectMapper.valueToTree(value));
                        continue;
                    }
                    if (!(current instanceof ArrayNode) || index == null) continue;
                    arrayNode = (ArrayNode)current;
                    int arrayIndex = Integer.parseInt(index);
                    if (arrayIndex < this.arraySizeThreshhold) {
                        if (arrayIndex < arrayNode.size()) {
                            jsonNode = arrayNode.get(arrayIndex);
                            if (jsonNode instanceof ObjectNode) {
                                ((ObjectNode)jsonNode).set(token, (JsonNode)this.objectMapper.valueToTree(value));
                            } else {
                                arrayNode.set(arrayIndex, new ObjectNode(nodeFactory, CollectionUtils.mapOf(token, this.objectMapper.valueToTree(value))));
                            }
                        } else {
                            this.expandArrayToThreshold(arrayIndex, arrayNode);
                            arrayNode.set(arrayIndex, new ObjectNode(nodeFactory, CollectionUtils.mapOf(token, this.objectMapper.valueToTree(value))));
                        }
                    }
                    index = null;
                    continue;
                }
                if (current instanceof ObjectNode) {
                    objectNode = current;
                    JsonNode existing = objectNode.get(token);
                    if (index != null) {
                        if (StringUtils.isDigits(index)) {
                            ArrayNode arrayNode2;
                            int arrayIndex = Integer.parseInt(index);
                            if (!(existing instanceof ArrayNode)) {
                                ArrayNode arrayNode3 = new ArrayNode(nodeFactory);
                                objectNode.set(token, arrayNode3);
                            } else {
                                arrayNode2 = (ArrayNode)existing;
                            }
                            this.expandArrayToThreshold(arrayIndex, arrayNode2);
                            jsonNode = this.getOrCreateNodeAtIndex(nodeFactory, arrayNode2, arrayIndex);
                        } else {
                            if (!(existing instanceof ObjectNode)) {
                                existing = new ObjectNode(nodeFactory);
                                objectNode.set(token, existing);
                            }
                            if (!((jsonNode = existing.get(index)) instanceof ObjectNode)) {
                                jsonNode = new ObjectNode(nodeFactory);
                                ((ObjectNode)existing).set(index, jsonNode);
                            }
                        }
                        current = jsonNode;
                        index = null;
                        continue;
                    }
                    if (!(existing instanceof ObjectNode)) {
                        existing = new ObjectNode(nodeFactory);
                        objectNode.set(token, existing);
                    }
                    current = existing;
                    continue;
                }
                if (!(current instanceof ArrayNode) || !StringUtils.isDigits(index)) continue;
                arrayNode = (ArrayNode)current;
                int arrayIndex = Integer.parseInt(index);
                this.expandArrayToThreshold(arrayIndex, arrayNode);
                jsonNode = this.getOrCreateNodeAtIndex(nodeFactory, arrayNode, arrayIndex);
                current = new ObjectNode(nodeFactory);
                ((ObjectNode)jsonNode).set(token, current);
                index = null;
            }
        }
        return rootNode;
    }

    private JsonNode getOrCreateNodeAtIndex(JsonNodeFactory nodeFactory, ArrayNode arrayNode, int arrayIndex) {
        JsonNode jsonNode = arrayNode.get(arrayIndex);
        if (!(jsonNode instanceof ObjectNode)) {
            jsonNode = new ObjectNode(nodeFactory);
            arrayNode.set(arrayIndex, jsonNode);
        }
        return jsonNode;
    }

    private void expandArrayToThreshold(int arrayIndex, ArrayNode arrayNode) {
        if (arrayIndex < this.arraySizeThreshhold) {
            while (arrayNode.size() != arrayIndex + 1) {
                arrayNode.addNull();
            }
        }
    }
}

