/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.micronaut.core.convert.value.ConvertibleValues;
import java.io.IOException;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
public class ConvertibleValuesSerializer
extends JsonSerializer<ConvertibleValues<?>> {
    @Override
    public boolean isEmpty(SerializerProvider provider, ConvertibleValues<?> value) {
        return value.isEmpty();
    }

    @Override
    public void serialize(ConvertibleValues<?> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<String, ?> entry : value) {
            String fieldName = entry.getKey();
            Object v = entry.getValue();
            if (v == null) continue;
            gen.writeFieldName(fieldName);
            gen.writeObject(v);
        }
        gen.writeEndObject();
    }
}

