/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.logging;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.StringUtils;
import io.micronaut.logging.LogLevel;
import io.micronaut.logging.LoggingSystem;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import java.util.HashMap;
import java.util.List;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BootstrapContextCompatible
@Singleton
@Context
@Requirements(value={@Requires(beans={LoggingSystem.class}), @Requires(beans={Environment.class}), @Requires(property="logger.levels")})
@Internal
final class PropertiesLoggingLevelsConfigurer
implements ApplicationEventListener<RefreshEvent> {
    static final String LOGGER_LEVELS_PROPERTY_PREFIX = "logger.levels";
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesLoggingLevelsConfigurer.class);
    private final Environment environment;
    private final List<LoggingSystem> loggingSystems;

    public PropertiesLoggingLevelsConfigurer(Environment environment, List<LoggingSystem> loggingSystems) {
        this.environment = environment;
        this.loggingSystems = loggingSystems;
        this.configureLogLevels();
    }

    @Override
    public void onApplicationEvent(RefreshEvent event) {
        if (event.getSource().keySet().stream().anyMatch(key -> key.startsWith(LOGGER_LEVELS_PROPERTY_PREFIX))) {
            this.configureLogLevels();
        }
    }

    private void configureLogLevels() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.environment.getProperties(LOGGER_LEVELS_PROPERTY_PREFIX));
        properties.putAll(this.environment.getProperties(LOGGER_LEVELS_PROPERTY_PREFIX, StringConvention.RAW));
        properties.forEach(this::configureLogLevelForPrefix);
    }

    private void configureLogLevelForPrefix(String loggerPrefix, Object levelValue) {
        LogLevel newLevel = levelValue instanceof Boolean && (Boolean)levelValue == false ? LogLevel.OFF : PropertiesLoggingLevelsConfigurer.toLogLevel(levelValue.toString());
        if (newLevel == null) {
            throw new ConfigurationException("Invalid log level: '" + levelValue + "' for logger: '" + loggerPrefix + "'");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting log level '{}' for logger: '{}'", (Object)newLevel, (Object)loggerPrefix);
        }
        LOGGER.info("Setting log level '{}' for logger: '{}'", (Object)newLevel, (Object)loggerPrefix);
        for (LoggingSystem loggingSystem : this.loggingSystems) {
            loggingSystem.setLogLevel(loggerPrefix, newLevel);
        }
    }

    private static LogLevel toLogLevel(String logLevel) {
        if (StringUtils.isEmpty(logLevel)) {
            return LogLevel.NOT_SPECIFIED;
        }
        try {
            return Enum.valueOf(LogLevel.class, logLevel);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

